<?php namespace App\Http\Controllers\Editions;

use App\Http\Controllers\Controller;
use Auth\AuthController;
use App\Models\Beneficiaire;
use App\Models\Versement;
use App\Models\Banque;
use App\Models\User;
use App\Models\Role2;
use App\Models\Parametre;
use Illuminate\Support\Facades\Session;
use View;

use Codedge\Fpdf\Fpdf\Fpdf;

class PDF_versements extends FPDF
{
    var $Titre="";
    var $param_EDI_CLR="";
    var $beneficiaire="";
    var $user="";

    function setParam_EDI_CLR($param_EDI_CLR) { $this->param_EDI_CLR=$param_EDI_CLR;}
    function set_titre($titre) { $this->titre=$titre;}
    function set_beneficiaire($beneficiaire) { $this->beneficiaire=$beneficiaire;}
    function set_user($user) { $this->user=$user;}

    public function setParametres()
    {
        
    }


    function Footer()
    {
        //Titre
        $this->SetFont("Arial",'',7);
        $this->SetY(285);
        $this->SetX(2);
        //$fpdf->Line(1,100,1,180);
        $this->Cell(60,7,utf8_decode("Edité par ".$this->user->nom),"T",0,'L');
        $this->Cell(100,7,"CPSWF - BP 125 MATA UTU - 98600 WALLIS - TEL : 72.01.20","T",0,'C');
        $this->Cell(40,7,$this->PageNo(),"T",0,'R');  
    }



    function Header()
    {
        $depX=5;$depY=5;$l=60;$h=5;
        $this->SetXY(260,$depY);
        $this->SetFont('Arial','',10);
        $this->Cell(30,$h,date('d/m/Y'),0,0,'R');
        $this->SetFont('Arial','',9);
        
        $this->SetXY($depX,$depY);
        $this->MultiCell($l,$h,utf8_decode($this->param_EDI_CLR),"",'C');  

        $depX=20;$depY=$this->GetY()+10;
        $this->SetXY($depX,$depY);
        $this->SetFont('Arial','B',14);
        $this->SetFillColor(153 , 204, 255);
        $this->Cell(165,$h,utf8_decode($this->titre),0,0,'C',1);

        $this->ln(10);
        $this->SetFont('Arial','BU',10);
        $this->Cell(25,$h,utf8_decode("Bénéficiaire :"),0,0,'L');
        $this->SetFont('Arial','BI',10);
        $this->Cell(50,$h,utf8_decode($this->beneficiaire->id." - ".$this->beneficiaire->nom_complet),0,1,'L');
        $this->SetFont('Arial','',10);
        $this->Cell(25,$h,utf8_decode("Né(e) le :"),0,0,'L');
        $this->SetFont('Arial','BI',10);
        $this->Cell(50,$h,utf8_decode($this->beneficiaire->datenaiss),0,0,'L');
        $this->SetFont('Arial','',10);
        $this->Cell(35,$h,utf8_decode("Immatriculation le :"),0,0,'L');
        $this->SetFont('Arial','BI',10);
        $this->Cell(50,$h,utf8_decode($this->beneficiaire->date_pi),0,0,'L'); 
    }  
}


/* ************* Editions *************** */
class EditionVersements extends Controller {
    public function imprime_versements($beneficiaire_id) //Request $request,
    {
        $avec_nom_employeur=false;
        $orientation=($avec_nom_employeur)?'L':'';
        $user=User::where('id','=',Session::get('id'))->first(); 

        $beneficiaire=Beneficiaire::find($beneficiaire_id);
        $Param_EDI_CLR=Parametre::where('ref','=','EDI_CLR_ATT_RET')->first()->value;
        $titre="VERSEMENTS";
        $versements = Versement::where('benum','=',$beneficiaire_id)->orderBy('date','DESC')->get();    

        $fpdf = new PDF_versements();
        $fpdf->SetParametres();
        $fpdf->set_user($user);
        $fpdf->setParam_EDI_CLR($Param_EDI_CLR);
        $fpdf->set_titre($titre);
        $fpdf->set_beneficiaire($beneficiaire);
        $fpdf->AddPage($orientation);
        $fpdf->SetAutoPageBreak(false);


        $depX=10;$depY=70;
        $fpdf->SetXY($depX,$depY);
        $fpdf->SetFont('Arial','B',9);
        $fpdf->ln();
        $l=30;$h=7;$nb=0;
        $w=[20,20,20,70,45,10];
        $fpdf->SetFillColor(153 , 204, 255);
        $fpdf->Cell($w[0],$h,utf8_decode("N°"),1,0,'C',1);
        $fpdf->Cell($w[1],$h,"Montant",1,0,'C',1);
        $fpdf->Cell($w[2],$h,"Date",1,0,'C',1);
        $fpdf->Cell($w[3],$h,"Banque",1,0,'C',1);
        $fpdf->Cell($w[4],$h,"Compte",1,0,'C',1);
        //$fpdf->Cell($w[5],$h,"Type",1,0,'C',1);
        $fpdf->ln();
        $fpdf->SetFont('Arial','',8);
        foreach($versements as $versement) {
            $fpdf->Cell($w[0],$h,$versement->id,1,0,'C',"");
            $fpdf->Cell($w[1],$h,number_format($versement->montant,0,","," ") ,1,0,'C',"");
            $fpdf->Cell($w[2],$h,$versement->date,1,0,'C',"");
            $fpdf->Cell($w[3],$h,$versement->banque_nom,1,0,'L',"");
            $fpdf->Cell($w[4],$h,$versement->compte,1,0,'L',"");
            //$fpdf->Cell($w[5],$h,$versement->type,1,0,'R',"");
            $fpdf->ln();
            $nb++;
            if( (($nb>15)&&($orientation=='L')) || (($nb>25)&&($orientation!='L')) ) {
                $fpdf->AddPage($orientation);
                $fpdf->SetY(65);
                $fpdf->Cell(65,$h,utf8_decode("(suite)"),0,1,'L');
                $fpdf->ln(); 
                $nb=0;
            }
        }

        $fpdf->ln(10);
        $fpdf->SetFont('Arial','',9);
        $fpdf->SetX($depX);
        $fpdf->Cell(190,$h,utf8_decode("Fait à Mata-Utu, le ").date('d/m/Y'),"",0,'R');

        
        
        $nom_fichier="feuille_liquidation_".$beneficiaire_id.".pdf";
        $fpdf->Output($nom_fichier.".pdf","I");
        exit();
    }



}



