<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\Models\Beneficiaire;
use App\Models\User;
use App\Models\Role2;
use App\Models\Parametre;
use App\Models\Cotisation;
use App\Models\Employeur;
use App\Models\Salaire;

use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use Codedge\Fpdf\Fpdf\Fpdf;


class EditionsCotisationsAtt extends Controller {
 
 
    /**
     * Impressions des documents cotisations
     */
    public function attestation($employeur_id,$mode="")
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $employeur = Employeur::find($employeur_id);
        if(!$employeur) exit();
        $nom_directeur=Parametre::where('ref','=','EDI_NOM_DIRECTEUR')->first()->value;
        $civilite_directeur=Parametre::where('ref','=','EDI_CIVILITE_DIRECTEUR')->first()->value;

        //Paramètres
        $param_EDI_LIEU=Parametre::where('ref','=','EDI_LIEU')->first()->value;
        $param_EDI_SIGNATAIRE=Parametre::where('ref','=','EDI_SIGNATAIRE')->first()->value;
        $param_EDI_CLR=Parametre::where('ref','=','EDI_CLR')->first()->value;

        $date=date('d/m/Y');
        $titre="SERVICE DE RECOUVREMENT";
        $titre_doc="ATTESTATION";
        $nom_fichier="Attestation cotisation simple N°".$employeur_id.".pdf";
        $ref_modele="EDI_CORPS_COTIS_ATT";

        $corps=Parametre::where('ref','=',$ref_modele)->first()->value;
        $corps=str_replace("{CIVILITE_DIRECTEUR}",$civilite_directeur,$corps);
        $corps=str_replace("{NOM_DIRECTEUR}",$nom_directeur,$corps);
        $corps=str_replace("{NUM_EMPLOYEUR}",$employeur->id,$corps);
        $corps=str_replace("{NOM_EMPLOYEUR}",$employeur->nom,$corps);
        
        $cadre=0;

        //Création de la page
        $fpdf = new Fpdf();
        $fpdf->AddPage();


        //Zone Entete adresse
        $fpdf->SetFont('Times','',10);
        $h=4;
        $cadre=0;
        $depX=10;
        $depY=10;
        $fpdf->SetXY($depX,$depY);
        $fpdf->MultiCell(82,$h,$param_EDI_CLR,'','L');
        //Titre Service
        $depX=130;
        $fpdf->SetX($depX);
        $fpdf->SetFont('Times','',11);
        $fpdf->MultiCell(50,$h,$titre,'0','C');
        //Cadre
        $y=$fpdf->GetY()-$depY;$h=12;
        $x=$depX;$l=50;
        $fpdf->Rect($x,$y,$l,$h);
        //Titre
        $fpdf->SetFont('Times','',14);
        $fpdf->ln(20);
        $fpdf->SetX(55);
        $fpdf->SetFillColor(255, 102, 153);
        $fpdf->Cell(110,$h,$titre_doc,$cadre,"",'C',"1");
        $fpdf->SetFillColor(255,255,255);

        //Corps
        $h=7;
        $fpdf->ln(25);
        $depX=20;$fpdf->SetX($depX);
        $fpdf->SetFont('Times','',12);
        $fpdf->MultiCell(0,7,"     ".utf8_decode($corps),'','L');      

        $fpdf->SetX($depX);
        $txt=utf8_decode("     l'Entreprise ".$employeur->nom.", inscrite sous le N°".$employeur->id);  
        $txt2=" est homologuée dans nos services suivant les informations ci-dessous :";
        $txt.=utf8_decode($txt2);

        $fpdf->ln(10);
        $fpdf->SetX($depX);
        $fpdf->SetFont('Times','BU',12);
        $txt=utf8_decode("Cotisations Antérieures :");
        $fpdf->Cell(100,$h,$txt,$cadre,"1",'L',"1");

        $fpdf->SetFont('Times','',12);
        $fpdf->SetX($depX+10);
        $txt=utf8_decode("- L'entreprise est à jour sur ses cotisations antérieures.");
        $fpdf->Cell(100,$h,$txt,$cadre,"2",'L',"1");
        $txt=utf8_decode("- L'entreprise n'est pas à jour de ses cotisations antérieures et doit un montant de ");
        $fpdf->Cell(100,$h,$txt,$cadre,"1",'L',"1");     

        $fpdf->ln(1);
        $fpdf->SetX($depX);
        $fpdf->SetFont('Times','BU',12);
        $txt=utf8_decode("Déclaration des Employés :");
        $fpdf->Cell(100,$h,$txt,$cadre,"1",'L',"1");

        $fpdf->SetFont('Times','',12);
        $fpdf->SetX($depX+10);
        $txt=utf8_decode("- L'entreprise ne déclare pas tous ses salariés (Ref : Contrôle N°............du .......................)");
        $fpdf->Cell(100,$h,$txt,$cadre,"2",'L',"1");
        $txt=utf8_decode("- L'entreprise déclare tous ses salariés");
        $fpdf->Cell(100,$h,$txt,$cadre,"1",'L',"1"); 


        //Titre Service
        $formule_finale=utf8_decode("En foi de quoi la présente attestation lui est délivrée, pour servir et valoir ce que de droit.");
        $fpdf->ln(10);
        $depX=20;$fpdf->SetX($depX);
        $fpdf->Cell(200,$h,$formule_finale,$cadre,0,'L');

        //Lieu
        $fpdf->ln(20);
        $depX=20;$fpdf->SetX($depX);
        $fpdf->Cell(70,$h,$param_EDI_LIEU." le ".$date,$cadre,0,'L');
        $fpdf->Cell(70,$h,$param_EDI_SIGNATAIRE,$cadre,0,'R');

        $fpdf->Output($nom_fichier,"I");
        exit();
    }


    public function attestation_normale($employeur_id)
    {
        return $this->attestation($employeur_id);
    }


}