<?php namespace App\Http\Controllers\Editions;

use App\Http\Controllers\Controller;
use App\Models\Beneficiaire;
use App\Models\User;
use App\Models\Role2;
use App\Models\Parametre;
use App\Models\Cotisation;
use App\Models\Employeur;
use App\Models\Salaire;

use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use Codedge\Fpdf\Fpdf\Fpdf;


class EditionsCotisationsAttCotis extends Controller {
 
  
    public function attestation_situation($employeur_id)
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $employeur = Employeur::find($employeur_id);
        if(!$employeur) exit();
        $nom_directeur=Parametre::where('ref','=','EDI_NOM_DIRECTEUR')->first()->value;
        $civilite_directeur=Parametre::where('ref','=','EDI_CIVILITE_DIRECTEUR')->first()->value;

        //Paramètres
        $param_EDI_LIEU=Parametre::where('ref','=','EDI_LIEU')->first()->value;
        $param_EDI_SIGNATAIRE=Parametre::where('ref','=','EDI_SIGNATAIRE')->first()->value;
        $param_EDI_CLR=Parametre::where('ref','=','EDI_CLR')->first()->value;

        $date=date('d/m/Y');
        $titre="SERVICE DE RECOUVREMENT";
        $titre_doc="ATTESTATION";
        $nom_fichier="Attestation cotisation simple N°".$employeur_id.".pdf";
        $ref_modele="EDI_CORPS_COTIS_ATT";
        
        $corps="Présente la situation suivante vis à vis de la caisse";
        
        $cadre=0;

        //Création de la page
        $fpdf = new Fpdf();
        $fpdf->AddPage();

        //Zone Entete adresse
        $fpdf->SetFont('Times','',10);
        $h=4;
        $cadre=0;
        $depX=10;
        $depY=10;
        $fpdf->SetXY($depX,$depY);
        $fpdf->MultiCell(82,$h,$param_EDI_CLR,'','L');
        //Titre Service
        $depX=130;
        $fpdf->SetX($depX);
        $fpdf->SetFont('Times','',11);
        $fpdf->MultiCell(50,$h,$titre,'0','C');
        //Cadre
        $y=$fpdf->GetY()-$depY;$h=12;
        $x=$depX;$l=50;
        $fpdf->Rect($x,$y,$l,$h);
        //Titre
        $fpdf->SetFont('Times','',14);
        $fpdf->ln(10);
        $fpdf->SetX(55);
        $fpdf->SetFillColor(255, 102, 153);
        $fpdf->Cell(110,$h,$titre_doc,$cadre,"",'C',"1");
        $fpdf->SetFillColor(255,255,255);

        //Corps
        $h=7;
        $fpdf->ln(15);

        $depX=10;
        $fpdf->SetX($depX);
        $fpdf->SetFont('Times','B',14);
        $fpdf->Cell(200,$h,utf8_decode("l'Entreprise ".$employeur->nom),0,0,'C',"1");
        $fpdf->ln(10);
        $fpdf->SetFont('Times','',12);
        $txt="Inscrite comme employeur sous le numéro : ".$employeur->id;
        $txt.="\ndomiciliée à : \n".trim($employeur->adresse)."\n";
        $txt.=($employeur->ile=="F")?"98600 FUTUNA":"98600 WALLIS";
        $txt=utf8_decode($txt);
        $fpdf->MultiCell(200,$h,$txt,0,'C');

        $fpdf->ln(10);
        $fpdf->Cell(200,$h,utf8_decode("Présente la situation suivante vis-à-vis de la Caisse"),0,"",'C');
            

        $fpdf->ln(15);
        $fpdf->SetX($depX);
        $fpdf->SetFont('Times','BU',12);
        $txt=utf8_decode("1) Pour le trimestre exigible :");
        $fpdf->Cell(100,$h,$txt,$cadre,"1",'L',"1");
        $fpdf->ln(5);

            //Liste des Paiements
            $depX=20;$fpdf->SetX($depX);
            $h=7;
            $fpdf->SetFont('Times','B',12);
            $w=array(30,30,60,60);
            $col_def=array('Période'=> $w[0],'Nbre de salariés' => $w[1],'Cotisations dues en F CFP' => $w[2]
                    ,"Cotisations réglées en F CFP" =>$w[3]);

            foreach($col_def as $name=>$l) $fpdf->Cell($l,$h,utf8_decode($name),"LRTB",0,'C');
            $k=0;            
            $fpdf->SetFont('Times','',10);

            //1et trimestre de l'année
            $date=date('Y-m-d');
            $annee=date('Y');
            $mois=date('m');
            $trimestre_encours=ceil($mois/3);
            $trimestre_exigible=($trimestre_encours==1)?"4":($trimestre_encours-1);
            $annee_exigible=($trimestre_encours==1)?($annee-1):$annee;
            $moisjour="";
            if($trimestre_exigible==1) $moisjour="-01-01";
            if($trimestre_exigible==2) $moisjour="-04-01";
            if($trimestre_exigible==3) $moisjour="-07-01";
            if($trimestre_exigible==4) $moisjour="-10-01";
            $periode_deb=$annee_exigible.$moisjour;

            $cotiss=Cotisation::where('sonum','=',$employeur->id)
                ->select('date','nbsal','debit','credit')
                ->where('date','>=',$periode_deb)
                ->distinct('date','>=',$periode_deb)
                ->orderby('date','DESC')->get();

            foreach($cotiss as $cotis) {
                $fpdf->ln(7);
                $k++;$i=0;
                $depX=20;$fpdf->SetX($depX);
                $bordure="BLRT";
                $periode=$trimestre_exigible.(($trimestre_exigible==1)?'er':'e')." trimestre ".$annee_exigible;
                $fpdf->Cell($w[$i++],$h,$periode,$bordure,0,'C');
                $fpdf->Cell($w[$i++],$h,$cotis->nbsal,$bordure,0,'C');
                $fpdf->Cell($w[$i++],$h,number_format($cotis->debit,0,","," "),$bordure,0,'C');
                $fpdf->Cell($w[$i++],$h,number_format($cotis->credit,0,","," "),$bordure,0,'C');
            }
            $fpdf->SetFont('Times','',12);
            $fpdf->ln(5);


        $depX=10;
        $fpdf->ln(10);
        $fpdf->SetX($depX);
        $fpdf->SetFont('Times','BU',12);
        $txt=utf8_decode("2) Tableau récapitulatif des 4 trimestres précédents :");
        $fpdf->Cell(100,$h,$txt,$cadre,"1",'L');


        $fpdf->SetFont('Times','B',12);
        $fpdf->SetX($depX);
        $w=array(40,30,45,45,30);
        $col_def=array('Période'=> $w[0],'Nbre de Mois' => $w[1],'Cotisations dues' => $w[2]
                ,"Cotisations réglées" =>$w[3],"Nbre de salariés" =>$w[4]);
        foreach($col_def as $name=>$l) $fpdf->Cell($l,$h,utf8_decode($name),"LRTB",0,'C');
        $k=0;            
        $fpdf->SetFont('Times','',10);

        $periode_fin=$periode_deb;
        $periode_deb=($annee_exigible-1).$moisjour;
        $cotiss=Cotisation::where('sonum','=',$employeur->id)
            ->select('mois','nbsal','nbmois',
                DB::raw('SUM(debit) as debit'),
                DB::raw('SUM(debit) as credit')
                )
            //->where('date','<=',$periode_fin)
            ->where('date','>=',$periode_deb)
            ->groupby('mois')
            ->orderby('mois','DESC')
            ->get();
//dd($periode_fin);
        foreach($cotiss as $cotis) {
            $fpdf->ln(7);
            $k++;$i=0;
            $depX=10;$fpdf->SetX($depX);
            $bordure="BLRT";
            $date=$cotis->mois;
            $annee=substr($date,6,4);
            $mois=substr($date,3,2);
            $trimestre=ceil($mois/3);
            $periode=$trimestre.(($trimestre==1)?'er':'e')." trimestre ".$annee;
            $fpdf->Cell($w[$i++],$h,$periode,$bordure,0,'C');
            $fpdf->Cell($w[$i++],$h,$cotis->nbmois,$bordure,0,'C');
            $fpdf->Cell($w[$i++],$h,number_format($cotis->debit,0,","," "),$bordure,0,'C');
            $fpdf->Cell($w[$i++],$h,number_format($cotis->credit,0,","," "),$bordure,0,'C');
            $fpdf->Cell($w[$i++],$h,$cotis->nbsal,$bordure,0,'C');
        }

        //Lieu
        $fpdf->ln(30);
         $fpdf->SetFont('Times','',12);
        $depX=20;$fpdf->SetX($depX);
        $fpdf->Cell(70,$h,utf8_decode("Fait à ".$param_EDI_LIEU." le ".$date),$cadre,0,'L');
        $fpdf->Cell(70,$h,$param_EDI_SIGNATAIRE,$cadre,0,'R');

        $fpdf->Output($nom_fichier,"I");
        exit();
    }




    public function recu($cotisation_id)
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $cotisation=Cotisation::find($cotisation_id);
        if(!$cotisation_id) exit();
        $employeur=Employeur::find($cotisation->sonum);
        $date=date('d/m/Y');
        $police="Arial";
 
        //Paramètres
        $param_EDI_LIEU=Parametre::where('ref','=','EDI_LIEU')->first()->value;
        $param_EDI_SIGNATAIRE=Parametre::where('ref','=','EDI_SIGNATAIRE')->first()->value;
        $param_EDI_CLR=Parametre::where('ref','=','EDI_CLR')->first()->value;

        $nom=$employeur->nom;
        $adresse=$employeur->adresse;
        $cp=$employeur->cp." ".$employeur->ile;

        $titre_doc="Cotisation CPSWF";
        $nom_fichier="Reçu cotisation N°".$cotisation_id.".pdf";
        
        $cadre=0;

        //Création de la page
        $fpdf = new Fpdf();
        $fpdf->AddPage();

        //Zone Entete adresse
        $fpdf->SetFont($police,'',10);
        $h=4;
        $cadre=0;
        $depX=10;$depY=10;
        $fpdf->SetXY($depX,$depY);
        $fpdf->MultiCell(82,$h,$param_EDI_CLR,'','L');

        //Titre Service
        $depX=130;
        $h=7;
        $fpdf->SetX($depX);
        $fpdf->SetFont($police,'B',12);
        $fpdf->Cell(65,$h+5,$date,"",2,'C');
        
        $fpdf->SetFont($police,'',11);
        $fpdf->Cell(50,$h,utf8_decode("Edité par : ".$user->nom),'',"2",'C');


        //Titre
        $h=7;
        $fpdf->SetFont($police,'',14);
        $fpdf->ln(20);
        $fpdf->SetX(55);
        $fpdf->Cell(110,$h,$titre_doc,"","",'C',"");


        //Cadre
        $y=$fpdf->GetY();$h=100;
        $x=10;$l=190;
        $fpdf->Rect($x,$y+15,$l,$h);

        //Recu N°
        $h=7;$posx=20;
        $fpdf->SetFont($police,'',14);
        $fpdf->ln(20);
        $fpdf->SetX(55);
        $fpdf->SetFillColor(204, 230, 255);
        $fpdf->Cell(110,$h,utf8_decode("Reçu N° :".$cotisation->id." du ".$cotisation->date),"1","",'C',"1");
        $fpdf->SetFillColor(255, 255, 255);

        //Employeur
        $fpdf->ln(20);
        $fpdf->SetFont($police,'UB',10);
        $depX=$posx;$fpdf->SetX($depX);
        $fpdf->Cell(65,$h,utf8_decode("N°Employeur / Société : "),0,0,'L');
        $fpdf->ln(10);
        $fpdf->SetFont($police,'',10);
        $depX=$posx+40;$fpdf->SetX($depX);
        $fpdf->Cell(65,$h,utf8_decode($employeur->nom),0,2,'L');
        $fpdf->Cell(65,$h,utf8_decode($employeur->adresse),0,2,'L');
        $fpdf->Cell(65,$h,utf8_decode($employeur->cp." ".$employeur->ile),0,1,'L');


        //Montant
        $fpdf->ln(10);
        $fpdf->SetFont($police,'UB',10);
        $depX=$posx;$fpdf->SetX($depX);
        $fpdf->Cell(25,$h,utf8_decode("Montant : "),0,0,'L');
        $fpdf->SetFont($police,'',10);
        $fpdf->Cell(35,$h,number_format($cotisation->credit,0,","," ")." CFP",0,2,'L');

        $fpdf->ln(2);
        $fpdf->SetFont($police,'IB',10);
        $depX=$posx;$fpdf->SetX($depX);
        $fpdf->Cell(25,$h,utf8_decode("Règlement par ".$cotisation->ModeReglementLibelle),0,0,'L');

        $fpdf->ln(15);
        $fpdf->SetFont($police,'UB',10);
        $depX=$posx;$fpdf->SetX($depX);
        $fpdf->Cell(25,$h,utf8_decode("Pour le ").$cotisation->mois." sur ".$cotisation->nbmois." mois",0,0,'L');
    

        //Detail
        $fpdf->ln(20);
        $fpdf->SetFont($police,'UB',10);
        $depX=$posx;$fpdf->SetX($depX);
        $fpdf->Cell(65,$h,utf8_decode("Détail de la cotisation : "),"",2,'L');
        $fpdf->ln(7);
        $depX=$posx;$fpdf->SetX($depX);
        $fpdf->SetFont($police,'',10);
        $fpdf->Cell(65,$h,utf8_decode("Exercice : ").$cotisation->exercice,0,2,'L');
        $fpdf->Cell(65,$h,utf8_decode("Compte : ").$cotisation->compte,0,2,'L');
        $fpdf->Cell(65,$h,utf8_decode("Bordereau : ").$cotisation->bdx,0,2,'L');
        $fpdf->MultiCell(65,$h,utf8_decode("Observations : ".$cotisation->observation),0,'L');


        //Date
        $fpdf->ln(20);
        $fpdf->SetFont($police,'B',10);
        $depX=$posx;$fpdf->SetX($depX);
        $fpdf->Cell(65,$h,utf8_decode("Date : ").$date,"",2,'L');
        


        $fpdf->Output($nom_fichier,"I");
        exit();
    }
}