<?php namespace App\Http\Controllers\Editions;

use App\Http\Controllers\Controller;
use App\Models\Beneficiaire;
use App\Models\User;
use App\Models\Role2;
use App\Models\Parametre;
use App\Models\Cotisation;
use App\Models\Employeur;
use App\Models\Salaire;

use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use Codedge\Fpdf\Fpdf\Fpdf;
use App\library\Numbers_Words_fr;


class PDF_AttPmtEch extends FPDF
{
    var $Titre="";
    var $Service="";
    var $param_EDI_CLR="";
    var $user="";

    function setParam_EDI_CLR($param_EDI_CLR) { $this->param_EDI_CLR=$param_EDI_CLR;}
    function set_titre($titre) { $this->Titre=$titre;}
    function set_service($Service) { $this->Service=$Service;}
    function set_user($user) { $this->user=$user;}

    public function setParametres()
    {
        
        
    }


    function Footer()
    {
        $this->SetFont("Arial",'',7);
        $this->SetY(285);
        $this->SetX(2);
        $this->Cell(60,7,utf8_decode("Edité par ".$this->user->nom),"T",0,'L');
        $this->Cell(100,7,"CPSWF - BP 125 MATA UTU - 98600 WALLIS - TEL : 72.01.20","T",0,'C');
        $this->Cell(40,7,$this->PageNo(),"T",0,'R');        
    }



    function Header()
    {
        $depX=10;
        $this->SetX($depX);
        $img_x=10;
        $img_y=10;
        $this->Image(url('img/logo_cpswf_imp.png'),$img_x,$img_y,40);

        $depX=10;$depY=25;$l=60;$h=4;
        $this->SetFont('Arial','',9);
        
        $this->SetXY($depX,$depY);
        $this->MultiCell($l,$h,utf8_decode($this->param_EDI_CLR),"",'L');  
        $depY=$this->GetY();
        $this->SetXY($depX,$depY);

        //Titre Service
        $depX=130;
        $this->SetX($depX);
        $this->SetFont('Arial','',11);
        $this->MultiCell(50,$h,$this->Service,'0','C');
        $img_x=$depX;
        $img_y=$this->GetY()-3*$h+1.5;
        $this->Image(url('img/bloc_adresse2.png'),$img_x,$img_y,50,13);

        //Titre
        $this->SetFont('Arial','',14);
        $this->ln(20);
        $this->SetX(55);
        $this->SetFillColor(255, 102, 153);
        $this->Cell(110,$h*2,$this->Titre,"","",'C',"1");
        $this->SetFillColor(255,255,255);

    }  
}


class EditionsCotisationsAttPmtEch extends Controller {
 
 
    /**
     * Impressions des documents cotisations
     */
    public function attestation($employeur_id,$mode="")
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $employeur = Employeur::find($employeur_id);
        if(!$employeur) exit();
        $nom_directeur=Parametre::where('ref','=','EDI_NOM_DIRECTEUR')->first()->value;
        $civilite_directeur=Parametre::where('ref','=','EDI_CIVILITE_DIRECTEUR')->first()->value;

        //Paramètres
        $param_EDI_LIEU=Parametre::where('ref','=','EDI_LIEU')->first()->value;
        $param_EDI_SIGNATAIRE=Parametre::where('ref','=','EDI_SIGNATAIRE')->first()->value;
        $param_EDI_CLR=Parametre::where('ref','=','EDI_CLR')->first()->value;

        $date=date('d/m/Y');
        $service="SERVICE DE RECOUVREMENT";
        $titre="ATTESTATION DE PAIEMENT ECHELONNE";
        $nom_fichier="ATT_PMT_ECH N°".$employeur_id.".pdf";
        $ref_modele="EDI_CORPS_COTIS_ATT";

        $corps=Parametre::where('ref','=',$ref_modele)->first()->value;
        $corps=str_replace("{CIVILITE_DIRECTEUR}",$civilite_directeur,$corps);
        $corps=str_replace("{NOM_DIRECTEUR}",$nom_directeur,$corps);
        $corps=str_replace("{NUM_EMPLOYEUR}",$employeur->id,$corps);
        $corps=str_replace("{NOM_EMPLOYEUR}",$employeur->nom,$corps);
        
        //Création de la page
        $fpdf = new PDF_AttPmtEch();
        $fpdf->SetParametres();
        $fpdf->setParam_EDI_CLR($param_EDI_CLR);
        $fpdf->set_titre($titre);
        $fpdf->set_service($service);
        $fpdf->set_user($user);
        $fpdf->AddPage();


        //Corps
        $h=7;
        $fpdf->ln(25);
        $depX=20;$fpdf->SetX($depX);
        $fpdf->SetFont('Arial','',14);
        $fpdf->MultiCell(0,7,"     ".utf8_decode($corps),'','L');


        
        $txt=utf8_decode("- l'Entreprise ".$employeur->nom.", inscrite sous le N°".$employeur->id);  
        $txt.=utf8_decode(" a effectué le plan de paiement échelonné suivant : ");
    

        $fpdf->ln(5);
        $fpdf->SetX($depX+10);
        $fpdf->SetFont('Arial','',14);
        $fpdf->MultiCell(0,$h,$txt,0,'L');
        $fpdf->ln(10);


        //Liste des Paiements
        $depX=30;
        $fpdf->SetX($depX);
        $h=7;
        $fpdf->SetFont('Arial','B',14);
        $w=array(40,40,40,40);
        $col_def=array('Trimestre'=> $w[0],'N°Chèque' => $w[1],'Montant' => $w[2],'Dates échéances' => $w[3]);

        foreach($col_def as $name=>$l) $fpdf->Cell($l,$h,utf8_decode($name),"LRTB",0,'C');
        $k=0;            
        $fpdf->SetFont('Arial','',14);
        $nb_cotis=5;
        $cotiss=Cotisation::where('sonum','=',$employeur->id)
            ->whereNotNull('date_depot')
            ->where('date_depot','>=',date('Y-m-d'))
            ->orderby('date','DESC')
            ->limit($nb_cotis)
            ->get();

        $montant=0;
        foreach($cotiss as $cotis) {

            $fpdf->ln(7);
            $k++;$i=0;
            $fpdf->SetX($depX);

            $date=$cotis->mois;
            $annee=substr($date,6,4);
            $mois=substr($date,3,2);
            $trimestre=ceil($mois/3);
            $periode=$trimestre.(($trimestre==1)?'er':'e')." trimestre ".$annee;

            $fpdf->Cell($w[$i++],$h,$periode,"BLR",0,'C');
            $fpdf->Cell($w[$i++],$h,$cotis->observation,"BLR",0,'C');
            $fpdf->Cell($w[$i++],$h,number_format($cotis->credit,0,","," ")." CFP","BLR",0,'C');
            $fpdf->Cell($w[$i++],$h,$cotis->date_depot,"BLR",0,'C');
            $montant+=$cotis->credit;
        }
        $fpdf->SetFont('Arial','',12);
        $fpdf->ln(5);


        //Total en lettre
        $nw = new Numbers_Words_fr();
        $montant_lettre=ucfirst($nw->toWordsDec($montant,"CFP"));

        //Titre Service
        $txt="A ce jour, ".$employeur->nom.", nous reste redevable de ses cotisations sociales pour un montant de ";
        $txt.=number_format($montant,0,","," ")." Francs CFP, soit ".$montant_lettre.".";
        $formule_finale=utf8_decode($txt);
        $fpdf->ln(10);
        $depX=20;$fpdf->SetX($depX);
        $fpdf->MultiCell(0,$h,$formule_finale,0,'L');

        //Lieu
        $fpdf->ln(20);
        $depX=20;$fpdf->SetX($depX);
        $fpdf->Cell(100,$h,utf8_decode("Fait à ".$param_EDI_LIEU." le ".$date),0,0,'L');
        $fpdf->Cell(50,$h,$param_EDI_SIGNATAIRE,0,0,'C');
        $fpdf->ln(30);
        $depX=110;$fpdf->SetX($depX);
        $fpdf->Cell(70,$h,$nom_directeur,0,0,'C');
        $fpdf->Output($nom_fichier,"I");
        exit();
    }


    public function attestation_pmtech($employeur_id)
    {
        return $this->attestation($employeur_id,"PECH");
    }

}