<?php namespace App\Http\Controllers\Editions;

use App\Http\Controllers\Controller;
use App\Models\Beneficiaire;
use App\Models\User;
use App\Models\Role2;
use App\Models\Parametre;
use App\Models\Cotisation;
use App\Models\Employeur;
use App\Models\Salaire;

use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use Codedge\Fpdf\Fpdf\Fpdf;




class PDF_AttSimple extends FPDF
{
    var $Titre="";
    var $Service="";
    var $param_EDI_CLR="";
    var $user="";

    function setParam_EDI_CLR($param_EDI_CLR) { $this->param_EDI_CLR=$param_EDI_CLR;}
    function set_titre($titre) { $this->Titre=$titre;}
    function set_service($Service) { $this->Service=$Service;}
    function set_user($user) { $this->user=$user;}

    public function setParametres()
    {
        
        
    }


    function Footer()
    {
        $this->SetFont("Arial",'',7);
        $this->SetY(285);
        $this->SetX(2);
        $this->Cell(60,7,utf8_decode("Edité par ".$this->user->nom),"T",0,'L');
        $this->Cell(100,7,"CPSWF - BP 125 MATA UTU - 98600 WALLIS - TEL : 72.01.20","T",0,'C');
        $this->Cell(40,7,$this->PageNo(),"T",0,'R');        
    }



    function Header()
    {
        $depX=10;
        $this->SetX($depX);
        $img_x=10;
        $img_y=10;
        $this->Image(url('img/logo_cpswf_imp.png'),$img_x,$img_y,40);

        $depX=10;$depY=25;$l=60;$h=4;
        $this->SetFont('Arial','',9);
        
        $this->SetXY($depX,$depY);
        $this->MultiCell($l,$h,utf8_decode($this->param_EDI_CLR),"",'L');  
        $depY=$this->GetY();
        $this->SetXY($depX,$depY);

        //Titre Service
        $depX=130;
        $this->SetX($depX);
        $this->SetFont('Times','',11);
        $this->MultiCell(50,$h,$this->Service,'0','C');
        $img_x=$depX;
        $img_y=$this->GetY()-3*$h+1.5;
        $this->Image(url('img/bloc_adresse2.png'),$img_x,$img_y,50,13);

        //Titre
        $this->SetFont('Times','',14);
        $this->ln(30);
        $this->SetX(55);
        $this->SetFillColor(255, 102, 153);
        $this->Cell(110,$h*2,$this->Titre,"","",'C',"1");
        $this->SetFillColor(255,255,255);

    }  
}



class EditionsCotisationsAttSimple extends Controller {
 
 

    /**
     * Impressions des documents cotisations
     */
    public function attestation($employeur_id,$mode="")
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $employeur = Employeur::find($employeur_id);
        if(!$employeur) exit();
        $nom_directeur=Parametre::where('ref','=','EDI_NOM_DIRECTEUR')->first()->value;
        $civilite_directeur=Parametre::where('ref','=','EDI_CIVILITE_DIRECTEUR')->first()->value;

        //Paramètres
        $param_EDI_LIEU=Parametre::where('ref','=','EDI_LIEU')->first()->value;
        $param_EDI_SIGNATAIRE=Parametre::where('ref','=','EDI_SIGNATAIRE')->first()->value;
        $param_EDI_CLR=Parametre::where('ref','=','EDI_CLR')->first()->value;

        $date=date('d/m/Y');
        $service="SERVICE DE RECOUVREMENT";
        $titre="ATTESTATION";
        $nom_fichier="Attestation cotisation simple N°".$employeur_id.".pdf";
        $ref_modele="EDI_CORPS_COTIS_ATT";

        $corps=Parametre::where('ref','=',$ref_modele)->first()->value;
        $corps=str_replace("{CIVILITE_DIRECTEUR}",$civilite_directeur,$corps);
        $corps=str_replace("{NOM_DIRECTEUR}",$nom_directeur,$corps);
        $corps=str_replace("{NUM_EMPLOYEUR}",$employeur->id,$corps);
        $corps=str_replace("{NOM_EMPLOYEUR}",$employeur->nom,$corps);
        
 
        //Création de la page
        $fpdf = new PDF_AttSimple();
        $fpdf->SetParametres();
        $fpdf->setParam_EDI_CLR($param_EDI_CLR);
        $fpdf->set_titre($titre);
        $fpdf->set_service($service);
        $fpdf->set_user($user);
        $fpdf->AddPage();

        //Corps
        $h=5;
        $fpdf->ln(20);
        $depY=$fpdf->GetX();
        $depX=20;
        $fpdf->SetX($depX);
        $fpdf->SetFont('Times','',12);
        $fpdf->MultiCell(0,7,"     ".utf8_decode($corps),'','L');

        $fpdf->SetX($depX);
        $txt=utf8_decode("l'Entreprise ".$employeur->nom.", inscrite sous le N°".$employeur->id." :");
        $fpdf->Cell(100,$h,$txt,0,"1",'L');
        $fpdf->ln();
        $fpdf->SetX($depX+20);
        $txt=utf8_decode("- est à jour de ses cotisations");
        $fpdf->Cell(100,$h,$txt,0,"1",'L');
        $fpdf->ln();
        $fpdf->SetX($depX+20);
        $txt=utf8_decode("- n'est pas à jour de ses cotisations");
        $fpdf->Cell(100,$h,$txt,0,"1",'L');

        //Titre Service
        $formule_finale=utf8_decode("En foi de quoi la présente attestation lui est délivrée, pour servir et valoir ce que de droit.");
        $fpdf->ln(10);
        $depX=20;$fpdf->SetX($depX);
        $fpdf->Cell(200,$h,$formule_finale,0,0,'L');

        //Lieu
        $fpdf->ln(20);
        $depX=20;$fpdf->SetX($depX);
        $fpdf->Cell(70,$h,$param_EDI_LIEU." le ".$date,0,0,'L');
        $fpdf->Cell(70,$h,$param_EDI_SIGNATAIRE,0,0,'R');

        $fpdf->Output($nom_fichier,"I");
        exit();
    }



      public function attestation_simple($employeur_id)
    {
        return $this->attestation($employeur_id,"S");
    }
    
}