<?php namespace App\Http\Controllers\Editions;

use App\Http\Controllers\Controller;
use App\Models\Beneficiaire;
use App\Models\User;
use App\Models\Role2;
use App\Models\Parametre;
use App\Models\Cotisation;
use App\Models\Employeur;
use App\Models\Salaire;

use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use Codedge\Fpdf\Fpdf\Fpdf;


class EditionsCotisationsBordereau extends Controller {
    public function bordereau($employeur_id,$annee,$trimestre="",$periode="",$dest="")
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $employeur = Employeur::find($employeur_id);
        $date=date('d/m/Y');
        $periode=str_replace('_','/',$periode);
        $police="Arial";
        if(!$employeur) exit();

        //Trimestres
        $libelle_trimestre="";
        $date_limite="";
        if(($trimestre=="-")||($trimestre=="0")) $trimestre="";
        $date_trim=[
            ""=>"9999-12-31",
            "T1"=>$annee."-04-01",
            "T2"=>$annee."-07-01",
            "T3"=>$annee."-10-01",
            "T4"=>$annee."-12-31"
        ];

        $date_limite=$date_trim[$trimestre];

        if($trimestre=="T1") $libelle_trimestre="1er Trimestre ".$annee;
        if($trimestre=="T2") $libelle_trimestre="2e Trimestre ".$annee;
        if($trimestre=="T3") $libelle_trimestre="3e Trimestre ".$annee;
        if($trimestre=="T4") $libelle_trimestre="4e Trimestre ".$annee;

        //Paramètres
        $param_EDI_LIEU=Parametre::where('ref','=','EDI_LIEU')->first()->value;
        $param_EDI_SIGNATAIRE=Parametre::where('ref','=','EDI_SIGNATAIRE')->first()->value;
        $param_EDI_CLR=Parametre::where('ref','=','EDI_CLR')->first()->value;

        $nom=$employeur->nom;
        $adresse=$employeur->adresse;
        $cp=$employeur->cp." ".$employeur->district;
        $cp.=" ".$employeur->nom_ile;

        $titre_doc="BORDEREAU DE COTISATION";
        $cadre=0;

        //Création de la page
        $fpdf = new Fpdf();
        $fpdf->AddPage();

        $depX=10;
        $fpdf->SetX($depX);
        $img_x=10;
        $img_y=10;
        $fpdf->Image(url('img/logo_cpswf_imp.png'),$img_x,$img_y,40);
        $fpdf->SetFont('Arial','',10);

        //Zone Entete adresse
        $fpdf->SetFont($police,'',10);
        $h=4;
        $cadre=0;
        $fpdf->ln();
        $depX=10;$depY=25;
        $fpdf->SetXY($depX,$depY);
        $fpdf->MultiCell(82,$h,$param_EDI_CLR,'','L');

        //Titre Service
        $depX=130;$depY=30;
        $h=7;
        $fpdf->SetXY($depX,$depY);
        $fpdf->SetFont($police,'',11);
        $fpdf->Cell(50,$h,$nom,'',"2",'C');
        $fpdf->MultiCell(50,$h,utf8_decode(trim($adresse)),$cadre,'C');
        $fpdf->SetX($depX);
        $fpdf->Cell(50,$h,$cp,$cadre,"1",'C');

        //Cadre
        /*
        $y=$fpdf->GetY()-24;$h=30;
        $x=$depX;$l=50;
        $fpdf->Rect($x,$y,$l,$h);
        */

        //Titre
        $h=7;
        $fpdf->SetFont($police,'',14);
        $fpdf->ln(20);
        $fpdf->SetX(55);
        $fpdf->SetFillColor(255, 102, 153);
        $fpdf->Cell(110,$h,$titre_doc,$cadre,"2",'C',"1");
        $fpdf->Cell(110,$h,utf8_decode($libelle_trimestre),0,"",'C',"");
        $fpdf->SetFillColor(255,255,255);


        //Appel
        $fpdf->ln(10);
        $fpdf->SetFont($police,'',12);
        $depX=20;$fpdf->SetX($depX);
        $fpdf->Cell(64,$h,utf8_decode("Appel de cotisation trimestriel : "),"",0,'L');
        $fpdf->SetFont($police,'BI',12);
        $fpdf->Cell(25,$h,utf8_decode($periode),0,0,'L');
       
        //Appel
        $fpdf->ln(10);
        $fpdf->SetFont($police,'UB',10);
        $depX=20;$fpdf->SetX($depX);
        $fpdf->Cell(65,$h,utf8_decode("N°Employeur : ").$employeur->id,0,0,'L');

        //Corps
        $fpdf->ln(10);

        //Liste des Paiements
        $depX=20;$fpdf->SetX($depX);
        $h=7;
        $fpdf->SetFont($police,'B',8);
        $w=array(15,35,35,20,20,20,35);
        $col_def=array('N°BENEF'=> $w[0],'NOM' => $w[1],'PRENOM' => $w[2]
                ,'DATENAISS' => $w[3],"DATE_ENT" => $w[4],"DATE_SOR" =>$w[5]
                ,"SALAIRE à déclarer" =>$w[6]);

        
        $fpdf->SetFillColor(102, 204, 255);
        foreach($col_def as $name=>$l) $fpdf->Cell($l,$h,utf8_decode($name),"LRTB",0,'C',1);
        $fpdf->SetFillColor(255,255,255);
        $k=0;            
        $fpdf->SetFont($police,'',8);
        $t_annees[]=[$annee];

        //Recherche si il y a des salaires dans l'année en cours
        $nb_salaires=Salaire::select('benum','date_sor')
            ->where('salaire.sonum','=',$employeur_id)
            ->where('annee','=',$annee)
            ->count();


        //Recherche les benef du dernier salaire
        if($nb_salaires>0) {
        $salaires=Salaire::select('benum','date_sor')
            ->where('salaire.sonum','=',$employeur_id)
            ->where('annee','=',$annee)
            ->where(function($query) use ($date_limite) {
                $query->where('date_sor', '>', $date_limite)
                ->orwhereNull('date_sor');
            })
            ->get();
        } else {
            $t_annees=[$annee-1];
             $salaires=Salaire::select('benum','date_sor')
                ->where('salaire.sonum','=',$employeur_id)
                ->where('annee','=',$annee-1)
                ->where(function($query) use ($date_limite) {
                    $query->where('date_sor', '>', $date_limite)
                    ->orwhereNull('date_sor');
                })
                ->get();   
        }

        $lst_employes=array();
        foreach($salaires as $salaire) {
            $lst_employes[]=$salaire->benum;
        }

        //SYSINFO : Correction 06/2020 ajout de 'select('salaire.id')->'
        $salaires=Salaire::select('salaire.id')->where('salaire.sonum','=',$employeur_id)
            ->join('beneficiaires','beneficiaires.id','=','salaire.benum')
            ->orderby('beneficiaires.nom')
            ->orderby('beneficiaires.prenom')
            ->whereIn('annee',$t_annees)
            ->wherein('benum',$lst_employes)
            ->get();

        $max_par_page=18;
        $new_page=false;
        $depX=20;
        $nb=0; $nbpage=0;
        $nb_total=count($salaires);

        foreach($salaires as $sal_id) {
            $salaire=Salaire::find($sal_id->id); //SYSINFO : Correction 06/2020
            $beneficiaire=Beneficiaire::find($salaire->benum);
            $fpdf->ln(7);
            $k++;$i=0;$nb++;
            $fpdf->SetX($depX);
            $bordure="BLR";
            if($new_page) {$bordure.="T";$new_page=false;}
            $fpdf->Cell($w[$i++],$h,$beneficiaire->id,$bordure,0,'C');
            $fpdf->Cell($w[$i++],$h,utf8_decode($beneficiaire->nom_reduit),$bordure,0,'L');
            $fpdf->Cell($w[$i++],$h,utf8_decode($beneficiaire->prenom),$bordure,0,'L');
            $fpdf->Cell($w[$i++],$h,$beneficiaire->datenaiss,$bordure,0,'C');
            $fpdf->Cell($w[$i++],$h,(($salaire->DatEnt!="")?$salaire->DatEnt:"__/__/___"),$bordure,0,'C');
            $fpdf->Cell($w[$i++],$h,(($salaire->DateSor!="")?$salaire->DateSor:"__/__/___"),$bordure,0,'C');

            //$fpdf->Cell($w[$i++],$h,(($beneficiaire->SalaireDateEntree!="")?$beneficiaire->SalaireDateEntree:"__/__/___"),$bordure,0,'C');
            //$fpdf->Cell($w[$i++],$h,(($salaire->DateSor!="")?$salaire->DateSor:"__/__/___"),$bordure,0,'C');
            //if($beneficiaire->id==16424) dd($salaire->dat_ent);
            $fpdf->Cell($w[$i++],$h,"",$bordure,0,'C');
            if(($k>$max_par_page)&&($nb<$nb_total)) {
                $fpdf->AddPage();
                $nbpage++;
                $new_page=true;
                $fpdf->SetX($depX);
                $fpdf->Cell(15,$h,"../..",'',2,'L');
                $fpdf->SetFillColor(102, 204, 255);
                foreach($col_def as $name=>$l) $fpdf->Cell($l,$h,utf8_decode($name),"LRTB",0,'C',1);
                $fpdf->SetFillColor(255,255,255);
                $k=0;
            }
        }

        //Lignes vides
        $bordure="BLR";
        for($j=0;$j<3;$j++) {
            $depX=20;$fpdf->ln(7);$k++;
            $fpdf->SetX($depX);
            $i=0;
            $fpdf->Cell($w[$i++],$h,"",$bordure,0,'C');
            $fpdf->Cell($w[$i++],$h,"",$bordure,0,'C');
            $fpdf->Cell($w[$i++],$h,"",$bordure,0,'C');
            $fpdf->Cell($w[$i++],$h,"",$bordure,0,'C');
            $fpdf->Cell($w[$i++],$h,"",$bordure,0,'C');
            $fpdf->Cell($w[$i++],$h,"",$bordure,0,'C');
            $fpdf->Cell($w[$i++],$h,"",$bordure,0,'C');
        }


        //Appel
        $fpdf->ln(10);
        $fpdf->SetFont($police,'UB',10);
        $depX=20;$fpdf->SetX($depX);
        $fpdf->Cell(65,$h,utf8_decode("Nombre de salariés : ").$nb,0,0,'L');

        if((($nbpage==0)&&($k>5))||(($nbpage>0)&&($k>10)) ) {
            $fpdf->AddPage();
            $fpdf->SetX($depX);
            $fpdf->Cell(15,$h,"../..",'',2,'L');
        }

        $fpdf->ln(13);
        $fpdf->SetX($depX);
        $fpdf->SetFont($police,'BU',12);
        $txt=utf8_decode("Derniers Paiements effectués :");
        $fpdf->Cell(100,$h,$txt,$cadre,"1",'L',"1");
        $fpdf->ln(1);
        //Liste des Paiements
        $depX=20;$fpdf->SetX($depX);
        $h=5;
        $fpdf->SetFont($police,'B',10);
        $w=array(20,30,30,30,30,30);
        $col_def=array('Date'=> $w[0],'Mois de début' => $w[1],'Nbre de mois' => $w[2]
                ,'Montant CFP' => $w[3],"Date d'encaiss." => $w[4],"Nbre de salariés" =>$w[5]);

        foreach($col_def as $name=>$l) $fpdf->Cell($l,$h,utf8_decode($name),"LRTB",0,'C');
        $k=0;            
        $fpdf->SetFont($police,'',10);
        $nb_cotis=5;
        $cotiss=Cotisation::where('sonum','=',$employeur->id)->orderby('date','DESC')->limit($nb_cotis)->get();
        foreach($cotiss as $cotis) {
            $fpdf->ln($h);
            $k++;$i=0;
            $depX=20;$fpdf->SetX($depX);
            if($nb_cotis==$k) $bordure="BLR";
            else $bordure="LR";
            $fpdf->Cell($w[$i++],$h,$cotis->date,$bordure,0,'C');
            $fpdf->Cell($w[$i++],$h,$cotis->mois,$bordure,0,'C');
            $fpdf->Cell($w[$i++],$h,$cotis->nbmois,$bordure,0,'C');
            $fpdf->Cell($w[$i++],$h,number_format($cotis->debit,0,","," "),$bordure,0,'C');
            $fpdf->Cell($w[$i++],$h,$cotis->encais_date,$bordure,0,'C');
            $fpdf->Cell($w[$i++],$h,$cotis->nbsal,$bordure,0,'C');
        }
    
        //Resta à payer
        $fpdf->ln(10);
        $fpdf->SetX($depX);
        $fpdf->SetFont($police,'BU',11);
        $reste_apayer=$employeur->ResteAPayer;

        $txt=utf8_decode(($reste_apayer<0)?"Trop perçu : ":"Reste à payer :  ");
        $fpdf->Cell(100,$h,$txt.number_format(abs($reste_apayer),0,","," ")." CFP",$cadre,"1",'L',"1");

        //Resta à payer
        $taux_CLR=Parametre::where('ref','=','TAUX_CLR_CCPF')->first()->getTauxCLRAttribute();
        $taux_CCPF=Parametre::where('ref','=','TAUX_CLR_CCPF')->first()->getTauxCCPFAttribute();


        $fpdf->ln(5);$h=9;
        $ligne="_____________________";
        $ligne="........................................";
        $fpdf->SetX($depX);
        $fpdf->SetFont($police,'',10);
        $fpdf->Cell(30,$h,"  Assiette :","TL","0",'L',"1");
        $fpdf->Cell(60,$h,$ligne,"TR","1",'L',"1");
        $fpdf->SetX($depX);
        $fpdf->Cell(30,$h,"  Cotisation :","L","0",'L',"1");
        $fpdf->Cell(60,$h,$ligne,"R","0",'L',"1");
        $fpdf->SetX($depX+95);
        $fpdf->Cell(55,$h,utf8_decode("Certifié exact à"),0,0,'L');
        $fpdf->Cell(10,$h,"le",0,1,'L');

        $fpdf->SetX($depX);
        $fpdf->Cell(30,$h,"  CLR ".$taux_CLR[$annee]."% :","L","0",'L',"1");
        $fpdf->Cell(60,$h,$ligne,"R","1",'L',"1");
        $fpdf->SetX($depX);
        $fpdf->Cell(30,$h,"  CCPF ".$taux_CCPF[$annee]."% :","L","0",'L',"1");
        $fpdf->Cell(60,$h,$ligne,"R","0",'L',"1");
        $fpdf->SetX($depX+95);
        $fpdf->Cell(80,$h,utf8_decode("Signature :"),0,1,'L');

        $fpdf->SetX($depX);
        $fpdf->Cell(90,$h,"_______________________________________","LR","2",'L',"1");
        $fpdf->Cell(30,$h,utf8_decode("  Total à payer : "),"L","0",'L',"1");
        $fpdf->Cell(60,$h,$ligne,"R","1",'L',"1");
        $fpdf->SetX($depX);
        $fpdf->Cell(90,3," ","LRB","1",'L',"1");


        if($dest=="F") {
            $nom_fichier="COTIS_BORD_".$employeur_id."_".date('Ymd-His').".pdf";
            $path="/upload/recouvrement/bordereau/";
            
            //création du dossier
            if(!file_exists(public_path().$path)) {
                mkdir(public_path().$path,0777,true);
                chmod(public_path().$path, 0777);
            }
            if(file_exists(public_path().$path)) {
                $path_nom_file=public_path().$path.$nom_fichier;

                $fpdf->Output($path_nom_file,"F");
                $t=[$path_nom_file,$nom_fichier];
                return $t;
            } else {
                return false;
            }
        } else {
            $nom_fichier="COTIS_BORD_".$employeur_id.".pdf";
            $fpdf->Output($nom_fichier,"I");
        }
        exit();
    }



}