<?php namespace App\Http\Controllers\Editions;

use App\Http\Controllers\Controller;
use Auth\AuthController;
use App\Models\Mandat;
use App\Models\Creancier;
use App\Models\Imputation;
use App\Models\Banque;
use App\Models\User;
use App\Models\Role2;
use App\Models\Parametre;
use App\library\Numbers_Words_fr;

use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use Codedge\Fpdf\Fpdf\Fpdf;



class PDF_bdxrglmt extends FPDF
{
  var $Titre="";
    var $user_nom="";
    var $banque_nom="";
    var $num_bordereau="";
    var $suite="";
    var $param_EDI_CLR="";
    var $param_EDI_LIEU="";
    var $param_EDI_SIGNATAIRE="";
    var $nom_directeur="";
    var $civilite_directeur=""; 
    var $modele="";
    var $exercice="";
     var $compte_CLR="";

    function setModele($modele) { $this->modele=$modele;}
    function setCompte_CLR($compte_CLR) { $this->compte_CLR=$compte_CLR;}
    function setExercice($exercice) { $this->exercice=$exercice;}
    function setTitre($titre) { $this->Titre=$titre;}
    function setIdentifiant($identifiant) { $this->identifiant=$identifiant;}
    function setUserNom($user_nom) { $this->user_nom=$user_nom;}
    function setBanqueNom($banque_nom) { $this->banque_nom=$banque_nom;}
    function setNumBordereau($num_bordereau) { $this->num_bordereau=$num_bordereau;}
    function setSuite($suite) { $this->suite=$suite;}
    function setParam_EDI_CLR($param_EDI_CLR) { $this->param_EDI_CLR=$param_EDI_CLR;}
    function setParam_EDI_LIEU($param_EDI_LIEU) { $this->param_EDI_LIEU=$param_EDI_LIEU;}
    function setParam_EDI_SIGNATAIRE($param_EDI_SIGNATAIRE) { $this->param_EDI_SIGNATAIRE=$param_EDI_SIGNATAIRE;}
    function setNom_directeur($nom_directeur) { $this->nom_directeur=$nom_directeur;}
    function setCivilite_directeur($civilite_directeur) { $this->civilite_directeur=$civilite_directeur;}


    public function setParametres()
    {
        //Paramètres
        $user=User::where('id','=',Session::get('id'))->first();
        $this->setUserNom($user->FullName);
        $this->setNom_directeur(Parametre::where('ref','=','EDI_NOM_DIRECTEUR')->value('value'));
        $this->setCivilite_directeur(Parametre::where('ref','=','EDI_CIVILITE_DIRECTEUR')->value('value'));
        $this->setParam_EDI_LIEU(Parametre::where('ref','=','EDI_LIEU')->value('value'));
        $this->setParam_EDI_SIGNATAIRE(Parametre::where('ref','=','EDI_SIGNATAIRE')->value('value'));
        $this->setParam_EDI_CLR(Parametre::where('ref','=','EDI_CLR')->value('value'));
    }


    function Footer()
    {
        //Titre
        $this->SetFont("Arial",'',7);
        $this->SetY(285);
        $this->SetX(2);
        //$fpdf->Line(1,100,1,180);
        $this->Cell(60,7,utf8_decode("Edité par ".$this->user_nom),"T",0,'L');
        $this->Cell(100,7,"CPSWF - BP 125 MATA UTU - 98600 WALLIS - TEL : 72.01.20","T",0,'C');
        $this->Cell(40,7,$this->PageNo(),"T",0,'R');      
    }


    function Adress()
    {
        //Zone Entete adresse
        if($this->modele=="") {
            $this->SetFont('Arial','',10);
            $depX=10;$depY=10;
            $this->SetXY($depX,$depY);
            $this->MultiCell(82,4,utf8_decode($this->param_EDI_CLR),'','L');
            $this->SetXY(20,20);
        }
        if($this->modele=="mandat_ordre_pmt_imp") {

        }

    }

    function Identifiant()
    {
        //Zone Entete adresse
        $this->SetFont('Arial','B',13);
        $depX=150;$depY=30;
        $this->SetXY($depX,$depY);
        $this->Cell(45,10,utf8_decode($this->identifiant),'1','0','C');
    }


    function Header()
    {
        $this->SetFont('Arial','B',9);
        $depX=7;$depY=7;$l=43;$h=5;
        $this->SetXY($depX,$depY);
        //$this->MultiCell($l,$h,utf8_decode($this->param_EDI_CLR),'','2','C');
        $this->Cell($l,$h,utf8_decode("Comptable"),"LRT",2,'L');
        $this->Cell($l,$h,utf8_decode("Paierie de Mata-utu"),"LR",2,'L');
        $this->Cell($l,$h,utf8_decode("Wallis"),"BLR",2,'L');
        $this->Cell($l,$h,utf8_decode("CCP PARIS"),"LR",2,'L');
        $this->Cell($l,$h,utf8_decode("9000 34D           1.63"),"RL",2,'L');
        $posY=$this->GetY();
        $this->Line($depX+15,$posY,48,$posY);
        $this->SetFont('Arial','',7);
        $this->Cell($l,$h,utf8_decode("                0.00"),"LRB",0,'C');
        /* ********** */
        $depX=$this->GetX();$depY=7;$l=114;$h=4;
        $this->SetXY($depX,$depY);
        $this->SetFont('Arial','B',10);
        $this->Cell($l,$h,utf8_decode($this->Titre),"TLR",2,'C');
        $this->SetFont('Arial','',9);
        $this->Cell($l,$h+2,"","LR",2,'C');
        $this->Cell($l,$h,utf8_decode("                    Virements postaux"),"LR",2,'L');
        $this->Cell($l,$h,utf8_decode("                    Virements bancaires"),"LR",2,'L');
        $this->Cell($l,$h,utf8_decode("                    Virements chez un comptable du trésor"),"LR",2,'L');
        $this->Cell($l,$h,utf8_decode("                    chèques sur le trésor"),"LR",2,'L');
        $this->Cell($l,$h,utf8_decode("                    ordres de paiement"),"BLR",0,'L');
        /* ********** */
        $depX=$this->GetX();$depY=7;$l=18;$l2=25;$h=4;
        $this->SetXY($depX,$depY);
        $this->SetFont('Arial','',7);
        $this->Cell($l,$h,"","TLR",0,'C');
        $this->Cell($l2,$h,utf8_decode("N°du Bordereau"),"TLR",2,'C');
        $this->SetXY($depX,$depY);
        $this->Cell($l,$h*4,"","TLR",0,'C');
        $this->Cell($l2,$h*4,"","TLRB",2,'C');
        $this->SetX($depX);
        $this->Cell($l,$h*4-2,"","TLRB",0,'C');
        $this->Cell($l2,$h*4-2,utf8_decode("N°du Feuillet"),"TLRB",2,'C');
        /* ***** */
        $this->SetFont('Arial','',9);
        $depX=7;$l=43;$h=5;$depY=$h*8-3;
        $h=4;
        $w=[17,70,45,25,18,25];
        $this->SetXY($depX,$depY);
        //$this->MultiCell($l,$h,utf8_decode($this->param_EDI_CLR),'','2','C');
        $this->Cell($w[0],$h,utf8_decode("NUMERO"),"LR",0,'L');
        $this->Cell($w[1],$h,utf8_decode("DESIGNATION DES CREANCIERS"),"LR",0,'L');
        $this->Cell($w[2],$h,utf8_decode("SOMME NETTE LIQUIDEE"),"LR",0,'L');
        $this->Cell($w[3],$h,utf8_decode("RETENUES"),"LR",0,'L');
        $this->Cell($w[4],$h,utf8_decode("NET"),"LR",0,'L');
        $this->Cell($w[5],$h,utf8_decode("Observations"),"LR",2,'L');
        /* lg */
        $this->SetXY($depX,$depY+$h);
        $this->SetFont('Arial','',8);
        $this->Cell($w[0],$h,"","LR",0,'L');
        $this->Cell($w[1],$h,utf8_decode("        Comptes à créditer"),"LR",0,'L');
        $this->Cell($w[2],$h,utf8_decode("au profit de chaque créancier"),"LR",0,'L');
        $this->Cell($w[3],$h,utf8_decode("faites par le"),"LR",0,'L');
        $this->Cell($w[4],$h,utf8_decode("à payer"),"LR",0,'L');
        $this->Cell($w[5],$h,"","LR",2,'L');
        /* lg */
        $this->SetXY($depX,$depY+2*$h);
        $this->SetFont('Arial','',8);
        $this->Cell($w[0],$h,"","LRB",0,'L');
        $this->Cell($w[1],$h,"","LRB",0,'L');
        $this->Cell($w[2],$h,"","LRB",0,'L');
        $this->Cell($w[3],$h,utf8_decode("comptable"),"LRB",0,'L');
        $this->Cell($w[4],$h,"","LRB",0,'L');
        $this->Cell($w[5],$h,"","LRB",2,'L');        
    }  


}


/* ************* Editions *************** */
class EditionsMandatsBordereauRglmt extends Controller {


    public function mandat_bordereau_rglmt($creancier_id,$multi=true)
    {
        $user=User::where('id','=',Session::get('id'))->first(); 
        $date=date('d/m/Y');     

        $creancier=Creancier::find($creancier_id); 
        $creanciers=array();
        if($multi) {
            $bqcle_creancier=$creancier->bqcle_creancier;
            $idimp_mdt=$creancier->idimp_mdt;
            $creanciers=Creancier::where('idimp_mdt','=',$idimp_mdt)
                ->where('bqcle_creancier','=',$bqcle_creancier)
                ->get();
        }

        $mandat=Mandat::find($creancier->idmandat);
        $imputations=Imputation::where('id','=',$creancier->idimp_mdt)->get();

        $font="Arial";
        //Document
        $titre="BORDEREAU DES REGLEMENTS A EFFECTUER";
        $Param_EDI_CLR="CAISSE DE PRESTATIONS FAMILIALES";
        $compte_CLR="C.1 000 006/64";

        //Création de la page
        $fpdf = new PDF_bdxrglmt();
        
        //Zone Entete adresse
        $fpdf->SetParametres();
        $fpdf->setModele("mandat_bordereau_rglmt");
        $fpdf->setExercice($mandat->exercice);
        //$fpdf->setIdentifiant($identifiant);
        $fpdf->setParam_EDI_CLR($Param_EDI_CLR);
        $fpdf->setCompte_CLR($compte_CLR);
        $fpdf->setTitre($titre);
        $fpdf->AddPage();
        $fpdf->setAutoPageBreak(false,5);


        /* Corps */
        /* ***** */
        /* Numero bordereau */
        $fpdf->SetXY(185,10);
        $fpdf->Cell(20,7,$mandat->id,"",0,'L');

        $fpdf->SetFont('Arial','',9);
        $depX=7;$l=43;$depY=49;$h=10;
        $w=[17,70,45,25,18,25];
        $fpdf->SetXY($depX,$depY);
        /* lg */
        $fpdf->SetFont('Arial','',8);
        $fpdf->Cell($w[0],$h,"","LR",0,'L');
        $fpdf->Cell($w[1],$h,"","LR",0,'L');
        $fpdf->Cell($w[2],$h,"","LR",0,'L');
        $fpdf->Cell($w[3],$h,"","LR",0,'L');
        $fpdf->Cell($w[4],$h,"","LR",0,'L');
        $fpdf->Cell($w[5],$h,"","LR",2,'L');
        //Banque
        $fpdf->SetX($depX);
        $fpdf->SetFont('Arial','BU',11);
        $fpdf->Cell($w[0],$h,"","LR",0,'L');
        $fpdf->Cell($w[1],$h,utf8_decode($creancier->banque),"LR",0,'L');
        $fpdf->Cell($w[2],$h,"","LR",0,'L');
        $fpdf->Cell($w[3],$h,"","LR",0,'L');
        $fpdf->Cell($w[4],$h,"","LR",0,'L');
        $fpdf->Cell($w[5],$h,"","LR",1,'L');

        //Creancier
        $k=0;$montant=0;$montant_euro=0;
        foreach($creanciers as $creancier) {
            $fpdf->SetX($depX);
            $fpdf->SetFont('Arial','',9);
            $fpdf->Cell($w[0],$h,"","L",0,'C');
            $fpdf->Cell($w[1],$h,utf8_decode($creancier->nom_complet),"L",0,"L");
            //$fpdf->SetX($depX+$w[0]+$w[1]);
            $fpdf->Cell($w[2],$h,number_format($creancier->montant,0,","," "),"L",0,'C');
            $fpdf->Cell($w[3],$h,"","L",0,'L');
            $fpdf->Cell($w[4],$h,"","L",0,'L');
            $fpdf->Cell($w[5],$h,"","LR",1,'L');
            
            //Compte
            $depY=$fpdf->GetY()-5;
            $fpdf->SetXY($depX,$depY);
            $fpdf->SetFont('Arial','B',8);
            $fpdf->Cell($w[0],$h,"","L",0,'C');
            $fpdf->Cell($w[1],$h,utf8_decode($creancier->compte),"L",0,'L');
            $fpdf->Cell($w[2],$h,"","L",0,'C');
            $fpdf->Cell($w[3],$h,"","L",0,'L');
            $fpdf->Cell($w[4],$h,"","L",0,'L');
            $fpdf->Cell($w[5],$h,"","LR",2,'L');
            $k++;
            $montant+=$creancier->montant;
            $montant_euro+=$creancier->MontantEuro;
            if($k>10) {
                $depY=$fpdf->GetY();
                $fpdf->SetXY($depX,$depY);
                $fpdf->Cell($w[0],$h,"","T",0);
                $fpdf->Cell($w[1],$h,"","T",0);
                $fpdf->Cell($w[2],$h,"","T",0);
                $fpdf->Cell($w[3],$h,"","T",0);
                $fpdf->Cell($w[4],$h,"","T",0);
                $fpdf->Cell($w[5],$h,"../..","T",2,'C');
                $k=0;
                $fpdf->AddPage();
                $fpdf->SetX($depX);
                $fpdf->Cell($w[0],$h,"../..","L",0,"C");
                $fpdf->Cell($w[1],$h,"","L",0);
                $fpdf->Cell($w[2],$h,"","L",0);
                $fpdf->Cell($w[3],$h,"","L",0);
                $fpdf->Cell($w[4],$h,"","L",0);
                $fpdf->Cell($w[5],$h,"","LR",2,'C');
            }
        }

        for($j=$k;$j<10;$j++) {
            $fpdf->SetFont('Arial','B',9);
            $fpdf->SetX($depX);
            $fpdf->Cell($w[0],$h,"","LR",0,'L');
            $fpdf->Cell($w[1],$h,"","LR",0,'L');
            $fpdf->Cell($w[2],$h,"","LR",0,'C');
            $fpdf->Cell($w[3],$h,"","LR",0,'L');
            $fpdf->Cell($w[4],$h,"","LR",0,'L');
            $fpdf->Cell($w[5],$h,"","LR",1,'L');
            
            $depY=$fpdf->GetY()-5;
            $fpdf->SetXY($depX,$depY);
            $fpdf->SetFont('Arial','B',8);
            $fpdf->Cell($w[0],$h,"","L",0,'C');
            $fpdf->Cell($w[1],$h,"","L",0,'L');
            $fpdf->Cell($w[2],$h,"","L",0,'C');
            $fpdf->Cell($w[3],$h,"","L",0,'L');
            $fpdf->Cell($w[4],$h,"","L",0,'L');
            $fpdf->Cell($w[5],$h,"","LR",2,'L');
        }
        $h=7;
        $fpdf->SetX($depX);
        $fpdf->Cell($w[0],$h,"","TLR",0,'L');
        $fpdf->SetFont('Arial','B',9);
        $fpdf->Cell($w[1],$h,"TOTAL CFP","T",0,'R');
        $fpdf->SetFont('Arial','',9);
        $fpdf->Cell($w[2],$h,number_format($montant,0,","," "),"TLR",0,'C');
        $fpdf->Cell($w[3],$h,"","TLR",0,'L');
        $fpdf->Cell($w[4],$h,"","TLR",0,'L');
        $fpdf->Cell($w[5],$h,"","TLR",2,'L');



        /* Fin Créancier */

        
        $fpdf->SetX($depX);
        $fpdf->Cell($w[0],$h,"","BLR",0,'L');
        $fpdf->SetFont('Arial','B',9);
        $fpdf->Cell($w[1],$h,"TOTAL EURO","B",0,'R');
        $fpdf->SetFont('Arial','',9);
        $fpdf->Cell($w[2],$h,number_format($montant_euro,2,","," "),"BLR",0,'C');
        $fpdf->Cell($w[3],$h,"","BLR",0,'L');
        $fpdf->Cell($w[4],$h,"","BLR",0,'L');
        $fpdf->Cell($w[5],$h,"","BLR",2,'L');

        $h=5;$depX+=15;
        $txt="Le destinataire du présent bordereau est invité à prendre les dispositions nécessaires pour l'exécution des";
        $fpdf->SetX($depX);
        $fpdf->Cell(190,$h,utf8_decode($txt),"",2,'L');

        $txt="virements ci-dessous dont le montant total est indiqué colonne 5.";
        $fpdf->SetX($depX);
        $fpdf->Cell(190,$h,utf8_decode($txt),"",2,'L');

        $txt="Centre des chèques postaux de ..............chèque n° joint.";
        $fpdf->ln();
        $fpdf->SetX($depX);
        $fpdf->Cell(190,$h,utf8_decode($txt),"",2,'L');
        
        $txt="Destin.Banque de ..............................succursale";
        $fpdf->SetX($depX);
        $fpdf->Cell(150,$h,utf8_decode($txt),"",0,'L');
         $fpdf->Cell(10,$h,"Le","",2,'R');
        
        $txt="Trésorerie Générale de ....................................................................";
        $fpdf->SetX($depX);
        $fpdf->Cell(190,$h,utf8_decode($txt),"",2,'L');
        
        $txt="12 130 N°6";
        $fpdf->ln();
        $fpdf->SetX($depX);
        $fpdf->SetFont('Arial','BI',11);
        $fpdf->Cell(50,$h,utf8_decode($txt),"",2,'C');
        



        $fpdf->Output("mandat_bordereau_rglmt_".$mandat->id.".pdf","I");
        exit();
    }




}



