<?php namespace App\Http\Controllers\Editions;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Role2;
use App\Models\Parametre;
use App\Models\Employeur;
use App\Models\Med;

use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use Codedge\Fpdf\Fpdf\Fpdf;
use App\library\Numbers_Words_fr;


class PDF_AttPmtEch extends FPDF
{
    var $Titre="";
    var $Service="";
    var $param_EDI_CLR="";
    var $user="";

    function setParam_EDI_CLR($param_EDI_CLR) { $this->param_EDI_CLR=$param_EDI_CLR;}
    function set_titre($titre) { $this->Titre=$titre;}
    function set_service($Service) { $this->Service=$Service;}
    function set_user($user) { $this->user=$user;}

    public function setParametres()
    {
        
        
    }


    function Footer()
    {
        $this->SetFont("Arial",'',7);
        $this->SetY(285);
        $this->SetX(2);
        $this->Cell(60,7,utf8_decode("Edité par ".$this->user->nom),"T",0,'L');
        $this->Cell(100,7,"CPSWF - BP 125 MATA UTU - 98600 WALLIS - TEL : 72.01.20","T",0,'C');
        $this->Cell(40,7,$this->PageNo(),"T",0,'R');        
    }



    function Header()
    {
        $depX=10;
        $this->SetX($depX);
        $img_x=10;
        $img_y=10;
        $this->Image(url('img/logo_cpswf_imp.png'),$img_x,$img_y,40);

        $depX=10;$depY=25;$l=60;$h=4;
        $this->SetFont('Arial','',9);
        
        $this->SetXY($depX,$depY);
        $this->MultiCell($l,$h,utf8_decode($this->param_EDI_CLR),"",'L');  
        $depY=$this->GetY();
        $this->SetXY($depX,$depY);

        //Titre Service
        /*
        $depX=130;
        $this->SetX($depX);
        $this->SetFont('Arial','',11);
        $this->MultiCell(50,$h,$this->Service,'0','C');
        $img_x=$depX;
        $img_y=$this->GetY()-3*$h+1.5;
        $this->Image(url('img/bloc_adresse2.png'),$img_x,$img_y,50,13);
        */


        //Titre
        $this->SetFont('Arial','',14);
        $this->ln(10);
        $this->SetX(60);
        $this->SetFillColor(135,206,235);
        $this->Cell(80,$h*2,$this->Titre,"","",'C',"1");
        $this->SetFillColor(255,255,255);

        //Titre Service
        $depX=145;
        $this->ln(2);
        $this->SetX($depX);
        $this->SetFont('Arial','',11);
        $this->MultiCell(50,$h,utf8_decode("Recommandé avec A/R"),'0','C','1');
        $img_x=$depX;
        $img_y=$this->GetY()-3*$h+3.2;
        $this->Image(url('img/bloc_adresse2.png'),$img_x,$img_y,50,13);
    }  
}


class EditionsRecouvrementMED extends Controller {
 
 
    /**
     * Impressions des documents cotisations
     */
    public function impression_med($med_id)
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $med = Med::find($med_id);
        if(!$med) exit();
        $employeur = Employeur::find($med->sonum);
        if(!$employeur) exit();

        $police="Arial";
        $nom_directeur=Parametre::where('ref','=','EDI_NOM_DIRECTEUR')->first()->value;
        $civilite_directeur=Parametre::where('ref','=','EDI_CIVILITE_DIRECTEUR')->first()->value;

        //Paramètres
        $param_EDI_LIEU=Parametre::where('ref','=','EDI_LIEU')->first()->value;
        $param_EDI_SIGNATAIRE=Parametre::where('ref','=','EDI_SIGNATAIRE')->first()->value;
        $param_EDI_CLR=Parametre::where('ref','=','EDI_CLR')->first()->value;

        $date=date('d/m/Y');
        $service="SERVICE DE RECOUVREMENT";
        $titre="MISE EN DEMEURE";
        $nom_fichier="MED N°".$med->id.".pdf";
        $ref_modele="EDI_CORPS_COTIS_ATT";

        $corps=Parametre::where('ref','=',$ref_modele)->first()->value;
        $corps=str_replace("{CIVILITE_DIRECTEUR}",$civilite_directeur,$corps);
        $corps=str_replace("{NOM_DIRECTEUR}",$nom_directeur,$corps);
        $corps=str_replace("{NUM_EMPLOYEUR}",$employeur->id,$corps);
        $corps=str_replace("{NOM_EMPLOYEUR}",$employeur->nom,$corps);
        

        $corps="Conformément aux dispositions de l'arrêté n°2011-377 du 12 octobre 2011, j'ai l'honneur de vous inviter ";
        $corps.=" à régulariser votre situation dans le délais de QUINZE JOURS, en acquittant les sommees ci-dessus selon le ";
        $corps.="mode de paiement qui vous convient.";
        $corps.="Cependant, cet avis n'est pas à considérer, si votre règlement a été transmis entre temps.";
        $corps2="Le présent avis constitue la MISE EN DEMEURE prévue par la législation en vigueur.";


        $nom=$employeur->nom;
        $adresse=$employeur->adresse;
        $cp=$employeur->cp." ".$employeur->district;
        $cp.=" ".$employeur->nom_ile;

        //Création de la page
        $fpdf = new PDF_AttPmtEch();
        $fpdf->SetParametres();
        $fpdf->setParam_EDI_CLR($param_EDI_CLR);
        $fpdf->set_titre($titre);
        $fpdf->set_service($service);
        $fpdf->set_user($user);
        $fpdf->AddPage();


        //Titre Service
        $depX=130;$depY=70;
        $h=7;
        $fpdf->SetXY($depX,$depY);
        $fpdf->SetFont($police,'',11);
        $fpdf->MultiCell(70,$h,trim($nom),"",'L');
        $fpdf->SetX($depX);
        $fpdf->MultiCell(70,$h,trim($adresse),"",'L');
        $fpdf->SetX($depX);
        $fpdf->Cell(50,$h,$cp,"","1",'L');


        //REF
        $h=7;
        $fpdf->ln();
        $depX=20;$fpdf->SetX($depX);
        $fpdf->SetFont('Arial','B',12);
        $fpdf->Cell(70,7,utf8_decode("Référence : ".str_pad($med->numero,4,"0",STR_PAD_LEFT)."/MED/C.P.S.W.F."),'B','L');


        //EMPLOYEUR
        $h=7;
        $fpdf->ln(20);
        $depX=20;$fpdf->SetX($depX);
        $fpdf->SetFont('Arial','',12);
        $fpdf->Cell(30,7,utf8_decode("N°Employeur : "),'LTB','L');
        $fpdf->SetFont('Arial','B',12);
        $fpdf->Cell(40,7,str_pad($med->sonum,4,"0",STR_PAD_LEFT),'TB','L');
        $fpdf->SetFont('Arial','',12);
        $fpdf->Cell(40,7,utf8_decode("Période d'Exigibilité : "),'TB','L');
        $fpdf->SetFont('Arial','B',12);
        $fpdf->Cell(60,7,"du ".$med->periode_deb." au ".$med->periode_fin,'TBR','L');


        //MOTIF
        $h=7;
        $fpdf->ln(10);
        $depX=20;$fpdf->SetX($depX);
        $fpdf->SetFont('Arial','',12);
        $fpdf->Cell(20,7,utf8_decode("Motif : "),'','0','L');
        $fpdf->SetFont('Arial','B',12);
        $fpdf->Cell(50,7,utf8_decode($med->MotifLibelle),'','','L');


        //MOTIF
        $h=7;
        $fpdf->ln(15);
        $depX=20;$fpdf->SetX($depX);
        $fpdf->SetFont('Arial','',12);
        $fpdf->Cell(60,7,utf8_decode("Cotisations"),'','0','L');
        $fpdf->Cell(40,7," : ".$med->cotisations." CFP",'','1','L');

        $fpdf->ln(5);
        $fpdf->SetX($depX);
        $fpdf->Cell(60,7,utf8_decode("Majorations de retards"),'B','L');
        $fpdf->Cell(40,7," : ".$med->majorations." CFP",'B','L');

        $fpdf->ln(10);
        $fpdf->SetX($depX);
        $fpdf->SetFont('Arial','B',12);
        $fpdf->Cell(60,7,utf8_decode("TOTAL DE LA DETTE"),'','L');
        $fpdf->Cell(50,7," : ".($med->majorations+$med->cotisations)." CFP",'','L');


        $y=$fpdf->GetY();
        $fpdf->SetXY(20,$y-25);
        $fpdf->Cell(100,35,"",'TBLR','',1);
        $fpdf->SetY($y);

        //Corps
        $h=7;
        $fpdf->ln(15);
        $depX=20;$fpdf->SetX($depX);
        $fpdf->SetFont('Arial','',10);
        $fpdf->MultiCell(0,7,"     ".utf8_decode($corps),'','L');

        //Corps
        $h=7;
        $fpdf->ln(5);
        $depX=20;$fpdf->SetX($depX);
        $fpdf->MultiCell(0,7,"     ".utf8_decode($corps2),'','L');


        //Lieu
        $fpdf->ln(10);
        $depX=20;$fpdf->SetX($depX);
        $fpdf->Cell(100,$h,utf8_decode("Fait à ".$param_EDI_LIEU." le ".$date),0,0,'L');
        $fpdf->Cell(50,$h,$param_EDI_SIGNATAIRE,0,0,'C');
        $fpdf->ln(20);
        $depX=110;$fpdf->SetX($depX);
        $fpdf->Cell(70,$h,$nom_directeur,0,0,'C');
        $fpdf->Output($nom_fichier,"I");
        exit();
    }




}