<?php namespace App\Http\Controllers\Editions;

use App\Http\Controllers\Controller;
use Auth\AuthController;
use App\Models\Banque;
use App\Models\Beneficiaire;
use App\Models\User;
use App\Models\Role2;
use App\Models\Mandat;
use App\Models\Creancier;
use App\Models\Parametre;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use Mail;



class ExportMandatsController extends Controller {



/* ****************************** */
/* TRESOR PUBLIC */
/* ****************************** */
public function index_export_fichier_TP()
{
    $user=User::where('id','=',Session::get('id'))->first();  
    $mandat_liste="";
    $nbCompteIncorrect=0;
    $mandats=Mandat::where('statut_transfert','=','ATR')->orderby('id','DESC')->get();
    foreach($mandats as $mandat) {
        $mandat_liste.=(($mandat_liste=="")?"":";").$mandat->id;
        $nbCompteIncorrect+=$mandat->NbCompteIncorrect;
    }
    
    return View::make('mandatements.mandats.export_fichier_TP', [ 
        'user'=>$user,
        'mandats'=>$mandats,
        'mandat_liste' => $mandat_liste,
        "nbCompteIncorrect" => $nbCompteIncorrect
    ]);
}


/* Exportation du fichier Tp */
public function export_fichier_TP(Request $request)
    {
        $user=User::where('id','=',Session::get('id'))->first();    

        $designation=$request->designation;
        $compte_cpswf=$request->compte;
        $date=$request->date_export;
        $date=substr($date,0,2).substr($date,3,2).substr($date,8,2);
            
        $mandat_liste="";
        $mandats=Mandat::where('statut_transfert','=','ATR')->orderby('id','DESC')->get();
        foreach($mandats as $mandat) {
            $mandat_liste.=(($mandat_liste=="")?"":";").$mandat->id;
        }

        $nom_file="";
        $nb_lignes=0;
        //Génération du fichier
        $nomfile="CPSWF_mandatement_".substr($date,0,6).".txt";
        $path="./upload/tresor_public/MDT";
        //création du dossier
        if(!file_exists($path)) {
            mkdir($path,'0777',true);
            chmod($path, '0755');
        }
        if(!file_exists($path)) {
            $message_err="Impossible de créer le fichier.";
        } else {
            $path_nom_file=$path."//".$nomfile;
            //ecriture du fichier
            $nb_lignes=$this->ecriture_file_TP($path_nom_file,$mandats,$date,$designation,$compte_cpswf);         
        }

        //Changement du statut des mandats
        foreach($mandats as $mandat) {
            $mandat=Mandat::find($mandat->id);
            $mandat->statut_transfert="TRA";
            $mandat->date_transfert=date('Y-m-j h:i:s');
            $mandat->save();
        }

        $t_email=array();

        return View::make('mandatements.mandats.export_fichier_TP', [ 
            'user'=>$user,
            'nom_file'=>$nomfile,
            'path_nom_file'=>$path_nom_file,
            'nb_lignes'=>$nb_lignes,
            'mandats' => $mandats,
            'mandat_liste' => $mandat_liste,
            't_email' => $t_email,
        ]);
    }


public function ecriture_file_TP($path_nom_file,$mandats,$date,$designation,$compte_cpswf)
{
    $fl="\r\n";
    $fp = @fopen($path_nom_file, 'w');
    if(!$fp) return false;


    //ecriture des lignes
    $j=0;
    $montant_total=0;
    //$nb_lignes_total=count($creanciers);
     
    $line="";$j=1;
    $line=$this->getLigne_debut_TP($date,$designation,$compte_cpswf);
    fwrite($fp, $line.$fl);

    //Pour chaque Mandat
    foreach($mandats as $mandat) {
        $creanciers=Creancier::where('idmandat','=',$mandat->id)->get();
        foreach ($creanciers as $creancier) {
            $montant_total+=$creancier->montant;
            $line=$this->getLigne_TP($creancier,$j,$date,$compte_cpswf); 
            fwrite($fp, $line.$fl);
            $j++;
        }
    }
    $line=$this->getLigne_fin_TP($montant_total,$j,$date,$compte_cpswf).$fl; 
    fwrite($fp, $line);
    fclose($fp);  
    return $j; 
}

public function getLigne_TP($creancier,$i,$date,$compte_cpswf)
{
    if(strlen($compte_cpswf)>11) $compte_cpswf=substr($compte_cpswf,0,11);
    $banque_emet="10071"; //TP emetteur
    $guichet="98700"; //TP emetteur

    $nom=$creancier->nom.(($creancier->prenom=="")?"":$creancier->prenom);
    $nom=$this->str_to_noaccent($nom);
    $nom=utf8_encode($nom);
    if(strlen($nom)>24) $nom=substr($nom,0,24);
    $id_banque=$creancier->bqcle_creancier;
    $banque=Banque::find($id_banque);
    //TP ar défaut
    $compte_cli=$creancier->compte;
    if(strlen($compte_cli)>=21) $compte_cli=substr($compte_cli,0,21);
    $banque_cli=substr($compte_cli,0,5);
    $guichet_cli=substr($compte_cli,5,5);
    $compte_cli=substr($compte_cli,10,11);
  
    $line="";
    $code_enregistrement="04";
    $code_operation="20";
    $libelle=$creancier->obs;
    if(strlen($libelle)>=32) $libelle=substr($libelle,0,32);

    $line.=$code_enregistrement;//Lg:2 Code enregistrement
    $line.=str_pad($i+1, 6, "0", STR_PAD_LEFT);//Lg:6 N°enregistrement
    $line.=$code_operation;//Lg:2 Code opération 20
    $line.=str_pad($date, 6, "0", STR_PAD_LEFT); //Lg:6 Date de règlement
    $line.=str_pad("F", 1, "0", STR_PAD_LEFT);//Lg:1 Code Monnaie
    $line.=str_pad(" ", 4, " ", STR_PAD_LEFT);//Lg:4 inutilisés
    $line.=$banque_emet;//Lg:5 Etablissement emetteur 30001
    $line.=$guichet;//Lg:5 Guichet emetteur 
    $line.=str_pad($compte_cpswf, 11, " ");//Lg:11 compte emetteur 
    //$line.=str_pad("1630", 4, " ");//Lg:4 Id client 1630
    //$line.=str_pad("D", 7, " ");//Lg:7 Code application + divers 
    $line.=str_pad(" ", 24, " ", STR_PAD_LEFT);//Lg:24 Nom donneur ordre
    $line.=str_pad(" ", 6, " ", STR_PAD_LEFT);//Lg:6 inutilisés
    $line.=str_pad(" ", 5, " ", STR_PAD_LEFT);//Lg:5 réservé BDF
    $line.=$banque_cli;//Lg:5 Etablissement destinataire 30001
    $line.=$guichet_cli;//Lg:5 Guichet destinataire 
    $line.=str_pad($compte_cli, 11, "0", STR_PAD_LEFT);//Lg:11 Numéro de compte du destinataire
    $line.=str_pad($nom, 24, " ");//Lg:24 Nom/Raison sociale du destinataire
    $line.=str_pad(" ", 6, " ", STR_PAD_LEFT);//Lg:5 réservé BDF
    $line.=str_pad(" ", 24, " ");//Lg:24 Domiciliation 
    $line.=str_pad($libelle, 32, " ");//Lg:32 Libellé 
    $line.=str_pad("", 32, " ");//Lg:32 Libellé 
    $line.=str_pad(" ", 10, " ", STR_PAD_LEFT);//Lg:10 inutilisés
    $line.=str_pad(" ", 2, " ", STR_PAD_LEFT);//Lg:2 Code flux
    $line.=str_pad($creancier->montant, 12, "0", STR_PAD_LEFT);//Lg:12 Montant 
    return $line;
}


public function getLigne_debut_TP($date,$designation,$compte_cpswf)
{
    //0100000100061119E 3000130001V754T163000DFIP
    if(strlen($compte_cpswf)>11) $compte_cpswf=substr($compte_cpswf,0,11);
    $guichet="10071";
    $banque="30001";
    $nom=$designation;//"CCPF";
    $line="01";//Lg:2 Code enregistrement
    $line.="000001";//Lg:6 N° Enregistrement 
    $line.=str_pad("0", 2, "0", STR_PAD_LEFT); //Lg:2 inutilisés
    $line.=str_pad($date, 6, "0", STR_PAD_LEFT); //Lg:6 Date échange
    $line.=str_pad("F", 1, "0", STR_PAD_LEFT);//Lg:1 Code Monnaie
    $line.=str_pad(" ", 4, " ", STR_PAD_LEFT);//Lg:4 inutilisés
    $line.=$banque;//Lg:5 Etablissement emetteur 30001
    $line.=$banque;//Lg:5 Guichet emetteur 
    $line.=str_pad($compte_cpswf, 11, " ");//Lg:11 compte emetteur 
    $line.=str_pad($designation, 24, " ", STR_PAD_RIGHT);//Lg:24 Nom donneur ordre
    $line.=str_pad(" ", 174, " ");//Lg:174 inutilisés
    return $line; 

}

public function getLigne_fin_TP($montant_total,$i,$date,$compte_cpswf)
{
    if(strlen($compte_cpswf)>11) $compte_cpswf=substr($compte_cpswf,0,11);
    $guichet="10071";
    $banque="30001";
    $line="";
    $line.="09";//Lg:2 Code enregistrement
    $line.=str_pad($i+1, 6, "0", STR_PAD_LEFT);//Lg:6 Numéro de l'enregistrement
    $line.="20";//Lg:2 Code opération
    $line.=str_pad($date, 6, "0", STR_PAD_LEFT); //Lg:6 Date de reglement
    $line.=str_pad("F", 1, "0", STR_PAD_LEFT);//Lg:1 Code Monnaie
    $line.=str_pad(" ", 4, " ", STR_PAD_LEFT);//Lg:4 inutilisés
    $line.=$banque;//Lg:5 Etablissement emetteur 30001
    $line.=$guichet;//Lg:5 Guichet emetteur 
    $line.=str_pad($compte_cpswf, 11, " ");//Lg:11 compte emetteur 
    //$line.=str_pad("1630", 4, " ");//Lg:4 Id client 1630
    //$line.=str_pad("D", 7, " ");//Lg:7 Code application + divers 
    $line.=str_pad(" ", 24, " ");//Lg:24 Nom donneur ordre
    $line.=str_pad(" ", 162, " ");//Lg:174 inutilisés
    $line.=str_pad($montant_total, 12, "0", STR_PAD_LEFT);//Lg:12 Montant

    return $line;
}







/* ****************** */
/* Fonctions communes */
/* ****************** */





function str_to_noaccent($str)
{
    $url = $str;
    $url = preg_replace('#Ç#', 'C', $url);
    $url = preg_replace('#ç#', 'c', $url);
    $url = preg_replace('#è|é|ê|ë#', 'e', $url);
    $url = preg_replace('#È|É|Ê|Ë#', 'E', $url);
    $url = preg_replace('#à|á|â|ã|ä|å#', 'a', $url);
    $url = preg_replace('#@|À|Á|Â|Ã|Ä|Å#', 'A', $url);
    $url = preg_replace('#ì|í|î|ï#', 'i', $url);
    $url = preg_replace('#Ì|Í|Î|Ï#', 'I', $url);
    $url = preg_replace('#ð|ò|ó|ô|õ|ö#', 'o', $url);
    $url = preg_replace('#Ò|Ó|Ô|Õ|Ö#', 'O', $url);
    $url = preg_replace('#ù|ú|û|ü#', 'u', $url);
    $url = preg_replace('#Ù|Ú|Û|Ü#', 'U', $url);
    $url = preg_replace('#ý|ÿ#', 'y', $url);
    $url = preg_replace('#Ý#', 'Y', $url);
     
    return ($url);
}


/*

    public function sendEmailBordereau(Request $request)
    {
        $nomfile=$request->fichier;
        $path_nom_file=$request->path_nom_file;
        
        //echo $nomfile." , ".$path_nom_file;


        $user=User::where('id','=',Session::get('id'))->first();   
        $expediteur="philn@mail.wf";
        $destinataire="pn@mail.wf";
        $destinataire_nom="BWF";
        $nom="toto";
        $sujet='Your Reminder!';
        Mail::send('emails.reminder', ['user' => $user], function ($m) use ($user) {
            $m->from($expediteur, 'Your Application');
            $m->to($destinataire, $destinataire_nom)->subject('Your Reminder!');
        });
    }
*/

}



