<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\Models\Beneficiaire;
use App\Models\Banque;
use App\Models\User;
use App\Models\Role2;
use App\Models\Versement;
use App\Models\Versement_b;
use App\Models\Parametre;
use App\Models\Employeur;

use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use Codedge\Fpdf\Fpdf\Fpdf;



class PDF extends FPDF
{
    var $Titre="";
    var $user_prenom="";
    var $banque_nom="";
    var $num_bordereau="";
    var $suite="";

    function setTitre($titre) { $this->Titre=$titre;}
    function setUserPrenom($user_prenom) { $this->user_prenom=$user_prenom;}
    function setBanqueNom($banque_nom) { $this->banque_nom=$banque_nom;}
    function setNumBordereau($num_bordereau) { $this->num_bordereau=$num_bordereau;}
    function setSuite($suite) { $this->suite;}

    function Footer()
    {
        $this->SetY(-15);
        $this->SetFont('Arial','I',8);
        $this->Cell(15,7,utf8_decode("Edité par ".$this->user_prenom. "le ".date('d/m/Y h:i:s')),"B",0,'L');
        $this->Cell(0,10,'Page '.$this->PageNo(),0,0,'C');

    }


    function Header()
    {
        //Filigranne
        if($this->num_bordereau==0)
        for($d1=25;$d1<200;$d1+=60)
            for($d2=9;$d2<290;$d2+=80)
                $this->Image(url('img/draft.gif'),$d1,$d2,50);


        $depX=20;
        $this->SetX($depX);
        $this->SetFont('Arial','B',14);
        $this->SetFillColor(153 , 204, 255);
        $this->Cell(175,10,$this->Titre." du ".date('d/m/Y').$this->suite,1,1,'C',1);
        $this->Ln(20);

        $depX=10;
        $this->SetX($depX);
        $this->SetFont('Arial','B',9);
        $this->Cell(15,7,"Banque : ","B",0,'L');
        $this->Cell(25,7,$this->banque_nom,0,0,'L');
        $this->SetX($depX+160);
        $this->Cell(18,7,utf8_decode("N°Imprimé :"),"B",0,'R');
        $this->Cell(20,7,$this->num_bordereau,"",0,'L');
        $this->Ln(20);

        $this->suite=" (suite)";
    }  
}

class EditionsBorderauxController extends Controller {
 
    /**
     * Impressions des attestations
     */
    public function imprime_versement($type,$annee_mois,$banque_id=0,$num_bordereau="0",$mode="")
    {
        $draft=($num_bordereau==0);
        $nom_fichier['RET']="VERSEMENT_RETRAITES";
        $nom_fichier['SOC']="VERSEMENT_AIDES_SOCIALES";
        $nom_edition=$nom_fichier[$type];
        $nom_titre=$nom_fichier[$type];
        $user=User::where('id','=',Session::get('id'))->first();

        //
        if($type=='RET') $type_libelle="Retraités";
        if($type=='SOC') $type_libelle="Bénéficiaires";
        if($type=='ALO') $type_libelle="Alocataires";

        //Recherche dans définitifs
        $num_imp = DB::table('versem')->where('date','like',$annee_mois."%")->value('num_imp');
        $versements_obj=null;
        $list_banque_obj=null;
        $table="";

     
        if(isset($num_imp)) {
            $table="versem";
            $list_banque_obj=Versement::select('bqcleunik','banques.nom')
                ->where('num_imp','=',$num_imp)
                ->distinct()
                ->join('banques','banques.id','=','bqcleunik');
            $versements_obj=Versement::where('type','=',$type)
                ->where('num_imp','=',$num_imp)
                ->join('banques','banques.id','=','bqcleunik')
                ->join('beneficiaires','beneficiaires.id','=',$table.'.benum')
                ->orderby('banques.nom')
                ->orderby('beneficiaires.nom')
                ->orderby('beneficiaires.prenom');
        } else {
            $table="versem_b";
            $list_banque_obj=Versement_b::select('bqcleunik','banques.nom')
                ->distinct()->join('banques','banques.id','=','bqcleunik');
            $versements_obj=Versement_b::where('type','=',$type)
                ->join('banques','banques.id','=','bqcleunik')
                ->join('beneficiaires','beneficiaires.id','=',$table.'.benum')
                ->orderby('banques.nom')
                ->orderby('beneficiaires.nom')
                ->orderby('beneficiaires.prenom');
        }
        
        //$list_banque_obj=Versement_b::select('bqcleunik','banques.nom')
        //    ->distinct()->join('banques','banques.id','=','bqcleunik');

        //Ajout condition si pour une seule banque
        if($banque_id<>0) $list_banque_obj=$list_banque_obj->where('banques.id',"=",$banque_id);
        $list_banque=$list_banque_obj->orderby('banques.nom')->pluck('nom','bqcleunik')->toArray(); 
        
        //Création de la page
        $fpdf = new PDF();
        $fpdf->setTitre($nom_titre);
        $fpdf->setUserPrenom($user->prenom);
        $fpdf->setNumBordereau($num_imp);
        $total_gene_cpf=array();
        $total_gene_eur=array();
        $total_gene_numdossier=array();
        $banque_id_old="";
        foreach($list_banque as $banque_id => $banque_nom) {
            if(isset($num_imp)) {
                $versements_b=Versement::where('type','=',$type)
                    ->join('banques','banques.id','=','bqcleunik')
                    ->join('beneficiaires','beneficiaires.id','=',$table.'.benum')
                    ->orderby('banques.nom')
                    ->orderby('beneficiaires.nom')
                    ->orderby('beneficiaires.prenom')
                    ->where('bqcleunik','=',$banque_id)->get();
            } else {
                $versements_b=Versement_b::where('type','=',$type)
                    ->join('banques','banques.id','=','bqcleunik')
                    ->join('beneficiaires','beneficiaires.id','=',$table.'.benum')
                    ->orderby('banques.nom')
                    ->orderby('beneficiaires.nom')
                    ->orderby('beneficiaires.prenom')
                    ->where('bqcleunik','=',$banque_id)->get();
            }
            $fpdf->setBanqueNom($banque_nom);
            $fpdf->setSuite("");
            $fpdf->AddPage();
            //Corps
            $h=7;
            $w=array(13,45,30,16,8,17,17,17,38);
            $fpdf->SetFillColor(153 , 204, 255);
            //$fpdf->ln(20);
            $depX=5;
            $fpdf->SetX($depX);
            $fpdf->SetFont('Arial','B',8);
            $fpdf->Cell($w[0],$h,utf8_decode("N°BENEF"),1,0,'C',1);
            $fpdf->Cell($w[1],$h,"NOM",1,0,'C',1);
            $fpdf->Cell($w[2],$h,"PRENOM",1,0,'C',1);
            $fpdf->Cell($w[3],$h,"NAISS.",1,0,'C',1);
            $fpdf->Cell($w[4],$h,"TYPE",1,0,'C',1);
            $fpdf->Cell($w[5],$h,"RAPPEL",1,0,'C',1);
            $fpdf->Cell($w[6],$h,"MNT CFP",1,0,'C',1);
            $fpdf->Cell($w[7],$h,"MNT EUR",1,0,'C',1);
            $fpdf->Cell($w[8],$h,"COMPTE",1,0,'C',1);
            $fpdf->ln();
            $fpdf->SetFont('Arial','',8);
            $k=0;$total_rappel=0;$total_cfp=0;$total_eur=0;

            foreach ($versements_b as $versement_b) {
                $k++;
                //Cas des retraites sous - totaux
                if($type=="RET") $type_sstot="TOTAL ".$versement_b->ret_type;
                else  $type_sstot="TOTAL";
                $montant_rappel=$versement_b->montant_r;
                $montant_cfp=$montant_rappel+$versement_b->montant_c;
                $montant_eur=round(0.00838*$montant_cfp,2);

                //RAZ Totaus et Sous Totaux
                if(!isset($total_banque_cpf[$type_sstot])) $total_banque_cpf[$type_sstot]=0; 
                if(!isset($total_banque_eur[$type_sstot])) $total_banque_eur[$type_sstot]=0; 
                if(!isset($total_banque_numdossier[$type_sstot])) $total_banque_numdossier[$type_sstot]=0; 
                if(!isset($total_gene_cpf[$type_sstot])) $total_gene_cpf[$type_sstot]=0; 
                if(!isset($total_gene_eur[$type_sstot])) $total_gene_eur[$type_sstot]=0; 
                if(!isset($total_gene_numdossier[$type_sstot])) $total_gene_numdossier[$type_sstot]=0;  
                //RAZ banques
                if($banque_id_old<>$banque_id) {
                    $total_banque_cpf[$type_sstot]=0; 
                    $total_banque_eur[$type_sstot]=0; 
                    $total_banque_numdossier[$type_sstot]=0; 
                }

                $total_gene_cpf[$type_sstot]+=$montant_cfp;
                $total_gene_eur[$type_sstot]+=$montant_eur;
                $total_gene_numdossier[$type_sstot]++;
                $total_rappel+=$montant_rappel;
                $total_cfp+=$montant_cfp;
                $total_eur+=$montant_eur;

                $fpdf->SetX($depX);
                $beneficiaire=Beneficiaire::find($versement_b->benum);
                $fpdf->Cell($w[0],$h,$versement_b->id,1,0,'C');
                $fpdf->Cell($w[1],$h,utf8_decode($beneficiaire->nom),1,0,'L');
                $fpdf->Cell($w[2],$h,utf8_decode($beneficiaire->prenom),1,0,'L');
                $fpdf->Cell($w[3],$h,$versement_b->naissance_beneficiaire ,1,0,'C');
                $fpdf->Cell($w[4],$h,$versement_b->ret_type,1,0,'C');
                $fpdf->Cell($w[5],$h,number_format($montant_rappel,0,","," "),1,0,'R');
                $fpdf->Cell($w[6],$h,number_format($montant_cfp,0,","," "),1,0,'R');
                $fpdf->Cell($w[7],$h,number_format($montant_eur,2,","," ").chr(128),1,0,'R');
                $fpdf->Cell($w[8],$h,$versement_b->compte,1,0,'C');
                $fpdf->ln();
            }
            $depX=5;
            $fpdf->SetX($depX);
            $fpdf->SetFont('Arial','B',7);
            $fpdf->Cell($w[0]+$w[1]+$w[2]+$w[3],$h,utf8_decode("Nombre de ".$type_libelle." :").$k,0,0,'L');
            $fpdf->Cell($w[4],$h,"Totaux",0,0,'R');
            $fpdf->Cell($w[5],$h,number_format($total_rappel,0,","," "),1,0,'C',1);
            $fpdf->Cell($w[6],$h,number_format($total_cfp,2,","," "),1,0,'C',1);
            $fpdf->Cell($w[7],$h,number_format($total_eur,0,","," "),1,0,'C',1);
            $banque_id_old=$banque_id;


            $fpdf->ln(10);$h=7;
            $w1=15;$w2=23;
            $depX=120;
            $fpdf->SetFont('Arial','B',8);
            $fpdf->SetX($depX+$w1);
            //$fpdf->Cell($w1,$h,"",1,0,'C');
            $fpdf->Cell($w2,$h,"CFP",1,0,'C',1);
            $fpdf->Cell($w2,$h,"EUR",1,0,'C',1);
            $fpdf->Cell($w2,$h,"Nbre Dossiers",1,0,'C',1);
            $fpdf->ln();
            $fpdf->SetFont('Arial','',8);
            foreach ($total_gene_cpf as $type_ => $montant) {
                $fpdf->SetX($depX);
                $fpdf->SetFont('Arial','B',8);
                $fpdf->Cell($w1,$h,$type_,1,0,'C',1);
                $fpdf->SetFont('Arial','',8);
                $fpdf->Cell($w2,$h,number_format($total_banque_cpf[$type_],0,","," "),1,0,'R');
                $fpdf->Cell($w2,$h,number_format($total_banque_eur[$type_],2,","," "),1,0,'R');
                $fpdf->Cell($w2,$h,$total_banque_numdossier[$type_],1,0,'C');
                $fpdf->ln();
            }
        }


        $fpdf->ln(15);$h=7;
        $w1=15;$w2=23;
        $depX=120;
        $fpdf->SetFont('Arial','B',8);
        $fpdf->SetX($depX+$w1);
        //$fpdf->Cell($w1,$h,"",1,0,'C');
        $fpdf->Cell($w2,$h,"CFP",1,0,'C',1);
        $fpdf->Cell($w2,$h,"EUR",1,0,'C',1);
        $fpdf->Cell($w2,$h,"Nbre Dossiers",1,0,'C',1);
        $fpdf->ln();
        $fpdf->SetFont('Arial','',8);
        foreach ($total_gene_cpf as $type_ => $montant) {
            $fpdf->SetX($depX);
            $fpdf->SetFont('Arial','B',8);
            $fpdf->Cell($w1,$h,$type_,1,0,'C',1);
            $fpdf->SetFont('Arial','',8);
            $fpdf->Cell($w2,$h,number_format($total_gene_cpf[$type_],0,","," "),1,0,'R');
            $fpdf->Cell($w2,$h,number_format($total_gene_eur[$type_],2,","," "),1,0,'R');
            $fpdf->Cell($w2,$h,$total_gene_numdossier[$type_],1,0,'C');
            $fpdf->ln();
        }
        $fpdf->Output($nom_fichier[$type]." N°".$type.$annee_mois.".pdf","I");
        exit();
    }


    public function setfooter($fpdf,$user)
    {

       // Positionnement à 1,5 cm du bas
        $fpdf->SetY(-15);
        $fpdf->SetFont('Arial','I',8);
        //$fpdf->Cell(15,7,utf8_decode("Edité par ".$user->prenom. "le ".date('d/m/Y h:i:s')),"B",0,'L');
        $fpdf->Cell(0,10,'Page '.$fpdf->PageNo(),0,0,'C');       
        return;
    }


    public function setFiligrane($fpdf)
    {

        //Filigranne
        for($d1=25;$d1<200;$d1+=60)
            for($d2=9;$d2<290;$d2+=80)
                $fpdf->Image(url('img/draft.gif'),$d1,$d2,50);

        return;
    }



}



