<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\Models\Beneficiaire;
use App\Models\User;
use App\Models\Role2;
use App\Models\Enfant;
use App\Models\Versement;
use App\Models\Versement_b;
use App\Models\Parametre;
use App\Models\Cotisation;
use App\Models\Employeur;

use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use Codedge\Fpdf\Fpdf\Fpdf;


class EditionsPrestationsController extends Controller {
  

    public function salaire_liquidation($beneficiaire_id)
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $beneficiaire = Beneficiaire::find($beneficiaire_id);
        return View::make('recouvrement.salaires.liquidations', [ 
            'beneficiaire'=> $beneficiaire,'simulation'=>'false','user'=>$user]);
    }


    public function salaire_simulation_liquidation($beneficiaire_id)
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $beneficiaire = Beneficiaire::find($beneficiaire_id);

        return View::make('recouvrement.salaires.liquidations', [ 
            'beneficiaire'=> $beneficiaire,'simulation'=>'true','user'=>$user]);
    }
    /**
     * Impressions des attestations
     */
    public function imprime_salaire_liquidation($beneficiaire_id)
    {
        $nom_edition=$modele;
        $user=User::where('id','=',Session::get('id'))->first();
        //Find Bénéficiaire
        $beneficiaire = Beneficiaire::find($beneficiaire_id);
        if(!$beneficiaire) exit();

        //Paramètres
        $param_EDI_LIEU=Parametre::where('ref','=','EDI_LIEU')->first()->value;
        $param_EDI_SIGNATAIRE=Parametre::where('ref','=','EDI_SIGNATAIRE')->first()->value;
        $date=date('d/m/Y');
        $cadre=0;

        /* Corps */
        $nom_edition="sal_liquid";
        $titre="FEUILLES DE LIQUIDATION - SALAIRES";
        $titre_doc="EDI_SALAIRES_LIQUIDATION";

        //Création de la page
        $fpdf = new Fpdf();
        $fpdf->AddPage();
        //Zone Entete adresse
        $this->en_tete($fpdf,$nom_edition);

        //Corps
        $h=7;
        $fpdf->ln(20);
        $depX=20;$fpdf->SetX($depX);
        $fpdf->SetFont('Times','',12);
        $fpdf->MultiCell(0,7,utf8_decode($corps),'','L');


        //Titre Service
        $formule_finale="Fait pour servir et valoir ce que de droit";
        $fpdf->ln(20);
        $depX=20;$fpdf->SetX($depX);
        $fpdf->Cell(200,$h,$formule_finale,$cadre,0,'L');

        //Lieu
        $fpdf->ln(20);
        $depX=20;$fpdf->SetX($depX);
        $fpdf->Cell(70,$h,$param_EDI_LIEU." le ".$date,$cadre,0,'L');
        $fpdf->Cell(70,$h,$param_EDI_SIGNATAIRE,$cadre,0,'R');

        $fpdf->Output($nom_fichier[$modele]." N°".$beneficiaire_id.".pdf","I");
        exit();
    }

    /**
     * Liste des cotisations
     */
    public function en_tete($fpdf,$modele)
    {

        $param_EDI_CLR=Parametre::where('ref','=','EDI_CLR')->first()->value;

        $titre="SERVICE DE L'AIDE SOCIALE"."\n"."A L'ENFANT";
        
        if ($modele=="sal_liquid") $titre_doc="FEUILLES DE LIQUIDATION - SALAIRES";

        $fpdf->SetFont('Times','',10);
        $h=4;
        $cadre=0;
        $depX=10;
        $depY=10;
        $fpdf->SetXY($depX,$depY);
        $fpdf->MultiCell(82,$h,$param_EDI_CLR,'','L');
        //Titre Service
        $depX=130;
        $fpdf->SetX($depX);
        $fpdf->SetFont('Times','',11);
        $fpdf->MultiCell(60,$h,$titre,'','C');
        //Cadre
        $y=$fpdf->GetY()-$depY;$h=12;
        $x=$depX;$l=60;
        $fpdf->Rect($x,$y,$l,$h);
        //Titre
        $fpdf->SetFont('Times','',14);
        $fpdf->ln(20);
        $fpdf->Cell(200,$h,$titre_doc,$cadre,0,'C');
    }


    /**
     * Mise en forme du corps avec infos bénéf
     */
    public function setCorps($beneficiaire,$nom_corps,$enfants)
    {

        $nom_directeur=Parametre::where('ref','=','EDI_NOM_DIRECTEUR')->first()->value;
        $civilite_directeur=Parametre::where('ref','=','EDI_CIVILITE_DIRECTEUR')->first()->value;

        return $corps;
    }



   /**
     * Impressions des attestations
     */



    /**
     * Liste des cotisations
     */
    public function en_tete_recouvrement($fpdf,$modele)
    {

        $param_EDI_CLR=Parametre::where('ref','=','EDI_CLR')->first()->value;

        $titre="RECOUVREMENT";
        
        if ($modele=="recouvrement_recu") $titre_doc="COTISATION CLR/CCPF";

        $fpdf->SetFont('Times','',10);
        $h=4;
        $cadre=0;
        $depX=10;
        $depY=10;
        $fpdf->SetXY($depX,$depY);
        $fpdf->MultiCell(82,$h,$param_EDI_CLR,'','L');
        //Titre Service
        $depX=130;
        $fpdf->SetX($depX);
        $fpdf->SetFont('Times','',11);
        $fpdf->MultiCell(60,$h,$titre,'','C');
        //Cadre
        $y=$fpdf->GetY()-$depY;$h=12;
        $x=$depX;$l=60;
        $fpdf->Rect($x,$y,$l,$h);
        //Titre
        $fpdf->SetFont('Times','',14);
        $fpdf->ln(20);
        $fpdf->Cell(200,$h,$titre_doc,$cadre,0,'C');
    }

    public function recouvrement_recu($cotisation_id)
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $cotisation=Cotisation::find($cotisation_id);
        if(!$cotisation) exit();

        $parametre=Parametre::first();
        $t_type_pmt=$parametre->getTypesPaiementLibelle();

        //Find Bénéficiaire
        $employeur = Employeur::find($cotisation->sonum);
        

        //Paramètres
        $param_EDI_LIEU=Parametre::where('ref','=','EDI_LIEU')->first()->value;
        $param_EDI_SIGNATAIRE=Parametre::where('ref','=','EDI_SIGNATAIRE')->first()->value;
        $date=date('d/m/Y');
        $cadre=0;
        $mois = array(1=>'janvier', 'février', 'mars', 'avril', 'mai', 'juin', 'juillet', 'août', 'septembre', 'octobre', 'novembre', 'décembre');


        //Mise en forme du corps
        $corps="Test";

        $titre="RECU";
        $nom_fichier="RECOUVREMENT RECU";
        $nom_edition="recouvrement_recu";
        $titre_doc=$nom_edition;

        //Création de la page
        $fpdf = new Fpdf();
        $fpdf->AddPage();
        //Zone Entete adresse
        $this->en_tete_recouvrement($fpdf,$nom_edition);



        $h=7;
        $w1=80;
        $fpdf->ln(20);
        $depX="70";$fpdf->SetX($depX);
        $fpdf->SetFont('Times','B',14);
        $fpdf->Cell($w1,$h,utf8_decode("Reçu N°").$cotisation->id." du ".$cotisation->date,1,'0','C');
        $fpdf->ln(20);

        //Corps
        $h=7;
        $w1=55;$w2=100;
        $fpdf->SetFont('Times','B',14);
        $fpdf->Cell($w1,$h,utf8_decode("Employeur/Société"),0,0,'L');
        $fpdf->SetFont('Times','',14);
        $depX=$w1;$fpdf->SetX($depX);
        $fpdf->MultiCell($w2,$h,utf8_decode($employeur->nom),'','L');
        $fpdf->SetX($depX);
        $fpdf->MultiCell($w2,$h,utf8_decode($employeur->adresse),'','L');
        $fpdf->ln(10);

        //Montant
        $w1=30;$w2=100;
        $fpdf->SetFont('Times','B',14);
        $fpdf->Cell($w1,$h,"Montant",0,'L');
        $fpdf->SetFont('Times','',14);
        $fpdf->Cell($w2,$h,number_format($cotisation->credit,0,","," ")." CFP",0,0,'L');
        $fpdf->ln(10);

        //Type de paiement
        $w1=150;
        $fpdf->SetFont('Times','B',14);
        $fpdf->Cell($w1,$h,utf8_decode($t_type_pmt[$cotisation->typepmt]),0,0,'L');
        $fpdf->ln(10);

        //Date et Durée
        $fpdf->SetFont('Times','B',14);
        $fpdf->Cell(70,$h,"Pour le ".$cotisation->date." sur ".$cotisation->nbmois." mois",0,0,'L');
        $fpdf->ln(10);

        //Cadre
        $dep_x=70;$fin_x=160;
        $dep_y=5;$fin_y=205;
        $fpdf->line($dep_y,$dep_x,$dep_y,$fin_x);
        $fpdf->line($fin_y,$dep_x,$fin_y,$fin_x);
        $fpdf->line($dep_y,$dep_x,$fin_y,$dep_x);
        $fpdf->line($dep_y,$fin_x,$fin_y,$fin_x);
        //$fpdf->line(80,10,80,180);




        //Titre Service
        $formule_finale="Fait pour servir et valoir ce que de droit";
        $fpdf->ln(20);
        $depX=20;$fpdf->SetX($depX);
        $fpdf->Cell(200,$h,$formule_finale,$cadre,0,'L');

        //Lieu
        $fpdf->ln(20);
        $depX=20;$fpdf->SetX($depX);
        $fpdf->Cell(70,$h,$param_EDI_LIEU." le ".$date,$cadre,0,'L');
        $fpdf->Cell(70,$h,$param_EDI_SIGNATAIRE,$cadre,0,'R');

        $fpdf->Output($nom_fichier." N°".$cotisation->id.".pdf","I");
        exit();
    }

}