<?php namespace App\Http\Controllers;

use App\Models\Employeur;
use App\Models\Beneficiaire;
use App\Models\Cotisation;
use App\Models\Controle;
use App\Models\User;
use App\Models\Role2;
use App\Models\MyApp;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use App\Http\Requests\EmployeurRequest;
use App\Http\Requests\EmployeurListeRequest;
use App\Http\Requests\AutoResponsableRequest;
use Illuminate\Http\Request;
use Response;

class EmployeursController extends Controller {
 

     /**
     * Display a listing of the user.
     *
     * @return Response
     */
    public function index($statut="")
    {
        
        $user=User::where('id','=',Session::get('id'))->first();
        $titre2="";

        if($statut=="") $statut="ACT"; //Activité par défaut
        if($statut=="0") $statut=""; //
        $statuts=MyApp::STATUTS_ENTREPRISE;
        $statuts=$statuts+["ALL"=>"Tous"];
        if(($statut!="ALL"))  {
            $titre2.=" avec le statut : ".$statuts[$statut];
            $employeurs = Employeur::where('statut',"=",$statut)->orderBy('nom')->get();
        } else $employeurs = Employeur::all();

        //Filtre sur Ile
        /*
        if($param!="" )  {
            $titre2.=($param=="W")?"Wallis":"Futuna";
            $employeurs = Employeur::whereIn('ile', ['W'])->orderBy('nom')->get();
        } else {
            $employeurs = Employeur::all();
        }*/

        return View::make('tiers.employeurs.index', [
            'employeurs' => $employeurs, 
            'user'=>$user, 
            'titre2' => $titre2, 
            'statut' => $statut, 'statuts' =>$statuts,
        ]);
    }
 
    /**
     * Show the form for creating a new user.
     *
     * @return Response
     */
    public function create()
    {
        return View::make('tiers.employeurs.create', []);
    }
 
    /**
     * Store a newly created user in storage.
     *
     * @return Response
     */
    public function store(EmployeurRequest $request)
    {
        $employeur=$this->setData($request);
        return Redirect::to('/tiers/employeurs');
    }
 
    /**
     * Show the form for editing the specified user.
     *
     * @param  int  $id
     * @return Response
     */
    public function edit($id)
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $ile="";
        $employeur = Employeur::find($id);
        $employes=Beneficiaire::where("sonum","=",$id)->get();
        $date1=intVal(date('Y'));$date2=$date1-1;
        $t_date=array($date1,$date2);
        $cotisations=Cotisation::where("sonum","=",$id)
            ->whereIn('exercice',$t_date)
            ->orderBy('date','DESC')
            ->get();

        $salaires=$employeur->getSalairesActifs();
        $controles=Controle::where("sonum","=",$id)->orderBy('date_cont','DESC')->get();
        $exercices=MyApp::getListeExercices();
        return View::make('tiers.employeurs.edit', [ 'employeur'=> $employeur, 
            'cotisations'=> $cotisations,
            'controles'=> $controles,
            'user'=>$user,'ile'=>$ile,
            'employes'=>$employes,
            'salaires'=>$salaires,
            'exercices'=> $exercices,
        ]);
    }


    /**
     * Show the form for editing the specified user.
     *
     * @param  int  $id
     * @return Response
     */
    public function show($id)
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $employeur = Employeur::find($id);
        $employes=Beneficiaire::where("sonum","=",$id)->get();
        $date1=intVal(date('Y'));$date2=$date1-1;
        $t_date=array($date1,$date2);
        $cotisations=Cotisation::where("sonum","=",$id)
            ->whereIn('exercice',$t_date)
            ->orderBy('date','DESC')
            ->get();
        $controles=Controle::where("sonum","=",$id)->orderBy('date_cont','DESC')->get();
        $salaires=$employeur->getSalairesActifs();
        $exercices=MyApp::getListeExercices();

         return View::make('tiers.employeurs.show', [ 'employeur'=> $employeur, 
            'cotisations'=> $cotisations,
            'controles'=> $controles,
            'user'=>$user,
            'employes'=> $employes,
            'salaires'=>$salaires,
            'exercices'=> $exercices,
            ]);
    }
 
    /*
     * Update the specified user in storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function update($id,EmployeurRequest $request)
    {
        $employeur=$this->setData($request,$id);


        return Redirect::to('/tiers/employeurs');
    }
 
    /**
     * Remove the specified user from storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function destroy($id)
    {
        $nb_employes=Beneficiaire::count("sonum","=",$id);
        if($nb_employes==0) {
             //LOG de la transaction
            $employeur=Employeur::find($id);
            $employeur->log_transaction('','D');
            Employeur::destroy($id);
        }
 
        return Redirect::to('/tiers/employeurs');
    }
 

     public function setData($request,$id="")
    {

        if($id) $employeur = Employeur::find($id);
        else $employeur = new Employeur;

        $employeur->sec_id = $request->sec_id;
        $employeur->nom = strtoupper($request->nom);
        $employeur->adresse = $request->adresse;
        $employeur->ile = $request->ile;
        $employeur->tel = $request->tel;
        $employeur->fax = $request->fax;
        $employeur->email = $request->email;
        $employeur->responsable = $request->responsable;
        
        $employeur->statut = $request->statut;
        $date = $request->date_deb;
        $employeur->date_deb = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
        $date = $request->date_fin;
        $employeur->date_fin = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
        $employeur->numrc = $request->numrc;
        $employeur->verrou = ($request->verrou=='on')?1:0;;
        $employeur->compte = $request->compte;
        $employeur->iban = $request->iban;
        $employeur->banque_id = $request->banque_id;
        $employeur->mode_cotis = $request->mode_cotis;
        $employeur->der_cotis = $request->der_cotis;
        $date = $request->der_mois;
        $employeur->der_mois = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
        $employeur->soldei = $request->soldei;
        $employeur->nom_cont = $request->nom_cont;
        $date = $request->date_cont;
        $employeur->date_cont = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
        $employeur->district = $request->district;
        $employeur->cp = $request->cp;
        $date = $request->date_med;
        $employeur->date_med = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
        $date = $request->date_maj;
        $employeur->date_maj = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
        $employeur->observation = $request->observation;
        $employeur->contact_nom = isset($request->contact_nom)?$request->contact_nom:"";
        $employeur->contact_tel = $request->contact_tel;
        $employeur->contact_email = $request->contact_email;
        //$employeur->date_contr  = $request->date_contr;


        $employeur->save();


        //LOG de la transaction
        if(!$id) $employeur->log_transaction('','I');
        else $employeur->log_transaction($request->url(),'U');

        

        //MAJ compte_aux
        if(!$employeur->compte_aux) {
            $employeur->compte_aux = "474".str_pad($employeur->id,4,0,STR_PAD_LEFT);
            $employeur->save();
        }

        return $employeur;

    }


    public function autocomplete_employes(Request $request)
    {        
        $param      = $request->input('term');
        $param = "OR";
        $associate = array();
        $search    = DB::select(
            "select id ,CONCAT(TRIM(nom) ,'  ',TRIM(prenom)) as value
            from beneficiaires
            where nom like ('{$param}%')
            "
        );

        foreach ($search as $result) {
            $associate[] = $result;
        }
        return json_encode($associate);
        
    }




    public function autocomplete_employeur(Request $request)
    {       
        $param = trim($request->input('term'));
        $associate = array();
        if(($param=='**')||(strtoupper($param)=='TOUS')) {
            $search = ['id'=>"TOUS"];
        } else {  
            $sql="select id as id,CONCAT(id,' ',TRIM(nom)) as value from employeurs
                where nom like ('%{$param}%') or id like ('%{$param}%') order by id";
            $search = DB::select($sql);
        }
        foreach ($search as $result) {
            $associate[] = $result;
        }


        return json_encode($associate);
        
    }
}