<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\Models\Enfant;
use App\Models\Beneficiaire;
use App\Models\User;
use App\Models\Role2;
use App\Models\Beneftype;
use App\Models\Benefstatut;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use App\Http\Requests\EnfantRequest;

class EnfantsController extends Controller {
 
    /**
     * Display a listing of the user.
     *
     * @return Response
     */
    public function index($benef_type="",$mode="")
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $liste_beneftype=Beneftype::orderby('libelle')
            ->select("libelle", "ref")->get()
            ->pluck("libelle", "ref")->toArray(); 

        $statut_def=DB::table('model_has_roles')->join('roles','roles.id','=','role_id')
            ->where('model_has_roles.model_id','=',$user->id)->value('roles.benef_statut');

        if($benef_type=="") $benef_type=$statut_def;
        $titre2=$liste_beneftype[$benef_type];

        $filtre=Beneftype::where('ref','=',$benef_type)->first()->statuts;       
        $t_filtre=explode(';',$filtre);

        if(count($t_filtre)>0) {
            /* VUE : _enfants_parents
                select `enfants`.`id` AS `id`,`enfants`.`nom` AS `nom`,`enfants`.`prenom` AS `prenom`,`enfants`.`datenais` AS `datenais`,`enfants`.`sexe` AS `sexe`,`enfants`.`certif` AS `certif`,`enfants`.`verrou` AS `verrou`,`enfants`.`parents1` AS `parents1`,`b1`.`nom` AS `nom_parent1`,`b1`.`prenom` AS `prenom_parent1`,`b1`.`statut` AS `statut_parent1`,`enfants`.`parents2` AS `parents2`,`b2`.`nom` AS `nom_parent2`,`b2`.`prenom` AS `prenom_parent2`,`b2`.`statut` AS `statut_parent2` from ((`enfants` left join `beneficiaires` `b1` on(`enfants`.`parents1` = `b1`.`id`)) left join `beneficiaires` `b2` on(`enfants`.`parents2` = `b2`.`id`)); 
            */
            $enfants = Enfant::
                join("_enfants_parents","_enfants_parents.id","=","enfants.id")
                ->whereIn('statut_parent1', $t_filtre)
                ->orwhereIn('statut_parent2', $t_filtre)
                ->get();
            
        } else {
            $titre2.=" Tous";
            $enfants = Enfant::orderBy('enfants.nom')->orderBy('enfants.prenom')->get();
        }

        if($mode=="") {
            return View::make('tiers.enfants.index', ['enfants' => $enfants, 'user'=>$user, 
                "benef_type" => $benef_type,"liste_beneftype" =>  $liste_beneftype]);
        } else {
            return View::make('tiers.enfants.index_in', ['enfants' => $enfants, 'user'=>$user, 
                "benef_type" => $benef_type,"liste_beneftype" =>  $liste_beneftype]);
        }
    }


    /**
     * Display a listing of the user.
     *
     * @return Response
     */
    public function index_in($benef_type="",$mode="")
    {

        return $this->index($benef_type,$mode);
    }

    /**
     * Display a listing of the user.
     *
     * @return Response
     */
    public function show($enfant_id)
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $enfant=Enfant::find($enfant_id);

        return View::make('tiers.enfants.visu', ['enfant' => $enfant, 'user'=>$user]);

    }



    /**
     * Show the form for creating a new user.
     *
     * @return Response
     */
    public function create()
    {
        return View::make('tiers.enfants.create');
    }
 
    public function create_avec_benef($beneficiaire_id="")
    {
        $beneficiaire=Beneficiaire::find($beneficiaire_id);

        return View::make('tiers.enfants.create', ['beneficiaire' => $beneficiaire]);
    }

    /**
     * Store a newly created user in storage.
     *
     * @return Response
     */
    public function store(EnfantRequest $request)
    {
        $mode_frame=$request->mode_frame;
        $enfant = new Enfant;
        $enfant->nom  = strtoupper($request->nom);
        $enfant->prenom  = ($request->prenom);
        $enfant->sexe = $request->sexe;
        $date=$request->datenais;
        $enfant->datenais = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;
        $enfant->certif = $request->certif;
        $enfant->parents1 = $request->parents1;
        $enfant->parents2 = $request->parents2;
        $enfant->compte_p = $request->compte_p;
        $enfant->compte_m = $request->compte_m;
        $enfant->obs = $request->obs;
        $enfant->verrou = ($request->verrou=="on")?"1":"0";
        $enfant->save();

        //LOG de la transaction
        $enfant->log_transaction('','I');

        if($mode_frame==true) {
            $title="Création effectuée";
            $msg="<blockquote><h2>La fiche de l'enfant <strong>".$enfant->nomcomplet."</strong> a été créée.</h2></blockquote>".
            "<br><br>".
            "Vous pouvez fermer cette fenêtre la fiche du bénéficiaire sera enregistrée et réactualisée.";
            return View::make('/tiers/enfants/close', ['msg' => $msg
                ,'title' => $title]);
        }
        return Redirect::to('/tiers/enfants');
    }
 
    /**
     * Show the form for editing the specified user.
     *
     * @param  int  $id
     * @return Response
     */
    public function edit($id)
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $enfant=Enfant::find($id);
        return View::make('tiers.enfants.edit', ['enfant' => $enfant, 'user'=>$user]); 
    }
 
     public function edit_avec_benef($id,$beneficiaire_id="")
    {
        $beneficiaire=Beneficiaire::find($beneficiaire_id);
        $user=User::where('id','=',Session::get('id'))->first();
        $enfant=Enfant::find($id);

        return View::make('tiers.enfants.edit', ['enfant' => $enfant, 'user'=>$user,'beneficiaire' => $beneficiaire]);
    }

    /**
     * Update the specified user in storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function update($id,EnfantRequest $request)
    {
        $mode_frame=$request->mode_frame;
        $enfant = Enfant::find($id);
        $enfant->nom  = strtoupper($request->nom);
        $enfant->prenom  = ($request->prenom);
        $enfant->sexe = $request->sexe;
        $date=$request->datenais;
        $enfant->datenais = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;
        $enfant->certif = $request->certif;
        $enfant->parents1 = $request->parents1;
        $enfant->parents2 = $request->parents2;
        $enfant->compte_p = $request->compte_p;
        $enfant->compte_m = $request->compte_m;
        $enfant->obs = $request->obs;
        $enfant->verrou = ($request->verrou=="on")?"1":"0";
        $enfant->save();

        //LOG de la transaction
        $enfant->log_transaction($request->url(),'U');

        if($mode_frame==true) {
            $title="Modification effectuée";
            $msg="<blockquote><h2>La fiche de l'enfant <strong>".$enfant->nomcomplet."</strong> a été modifiée.</h2></blockquote>".
            "<br><br>".
            "Vous pouvez fermer cette fenêtre la fiche du bénéficiaire sera enregistrée et réactualisée.";
            return View::make('/tiers/enfants/close', ['msg' => $msg
                ,'title' => $title]);
        }

        return Redirect::to('/tiers/enfants');
    }
 
    /**
     * Remove the specified user from storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function destroy($id)
    {
         //LOG de la transaction
        $enfant=Enfant::find($id);
        $enfant->log_transaction('','D');
        Enfant::destroy($id);
 
        return Redirect::to('/tiers/enfants');
    }
 

}