<?php

namespace App\Http\Controllers;

use Auth\AuthController;
use App\Models\User;
use App\Models\Parametre;
use Illuminate\Support\Facades\Session;
use View;
use Illuminate\Support\Facades\Mail;

class HomeController extends Controller
{

     public $role_name="";

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }


public function index()
    {
        $user=User::where('id','=',Session::get('id'))->first();
        if(!$user) return view( 'auth.login' );;
      

        $parametres = "";

        //Messages
        $t_msg=array('ADMINISTRATEUR FONCTIONNEL'=>'','TOUS'=>'',);
        $t_msg['TOUS'] = Parametre::where('ref', '=', 'MSG_TOUS')->first()->value;
        
        //if($user->hasRole("ADMINISTRATEUR FONCTIONNEL") ) {
        //    $t_msg['ADMINISTRATEUR FONCTIONNEL'] = Parametre::where('ref', '=', 'MSG_ADMIN')->first()->value;
        //}

        //Evite les doublons
        if($t_msg['ADMINISTRATEUR FONCTIONNEL']==$t_msg['TOUS'] )  $t_msg['ADMINISTRATEUR FONCTIONNEL']=="";

        $nav_bar="";
        Session::put('menu','');
        Session::put('titre_spec','');

        return View::make('accueil', ['user'=>$user,'nav_bar'=>$nav_bar,'messages'=>$t_msg]);       
    }



    public function index_spec($type)
    {
        $user=User::where('id','=',Session::get('id'))->first();
        if(!$user) return view( 'auth.login' );;
        
        $t_msg=array('ADMINISTRATEUR FONCTIONNEL'=>'','TOUS'=>'',);
        $nav_bar="";
        $titre_spec="";
        if($type=="retraites") {
            $nav_bar="retraites";
            $titre_spec="GESTION DES RETRAITES";
        }
        if($type=="allocations") {
            $nav_bar="allocations";
            $titre_spec="GESTION DES ALLOCATIONS";
        }
        if($type=="recouvrement") {
            $nav_bar="recouvrement";
            $titre_spec="GESTION DES RECOUVREMENTS";
        }
        if($type=="aidessociales") {
            $nav_bar="aidessociales";
            $titre_spec="GESTION DES AIDES SOCIALES";
        }
         if($type=="mandatement") {
            $nav_bar="mandatement";
            $titre_spec="GESTION DES MANDATEMENTS";
        }
        if($type=="comptabilite") {
            $nav_bar="comptabilite";
            $titre_spec="COMPTABILITE";
        }
        if($type=="parametres") {
            $nav_bar="parametres";
            $titre_spec="PARAMETRES";
        }
        if($type=="analyses") {
            $nav_bar="analyses";
            $titre_spec="ANALYSES";
        }

        Session::put('menu',$nav_bar);
        Session::put('titre_spec',$titre_spec);

        return View::make('accueil', ['user'=>$user,'messages'=>$t_msg,'nav_bar'=>$nav_bar,'titre_spec'=>$titre_spec]);     
    }


    public function mail()
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $data = [];
        Mail::send('emails.mail_message', $data, function($message) use ($user) {
            $message->to("pn@mail.wf");
            $message->subject('Test Email');
        });
        dd('Mail Send Successfully');
    }

}
