<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\Models\User;
use App\Models\Role2;
use App\Models\Imputation;
use App\Models\Mandat;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use App\Http\Requests\ImputationRequest;
use Request;
use Response;
use App\Models\Parametre;


class ImputationsController extends Controller {
 
    /**
     * Liste
     */
    public function index($exercice="")
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $exercices = $this->getListeExercicesBi();  
        if($exercice!="*") {
            if($exercice=="") $exercice=intval(date('Y'))."-".(intval(date('Y'))-1);
            $list_exercice="";
            if(strlen($exercice)==9)  $list_exercice=explode('-',$exercice);
            if($list_exercice!='') 
                    $obj_mandats = Mandat::wherein('exercice',$list_exercice);
            else  $obj_mandats = Mandat::where('id','<>','');
            $mandats=$obj_mandats->orderby('id','DESC')->pluck('id')->toArray();

            $imputations=Imputation::orderby('id')->whereIn('idmandat',$mandats)->get();
        } else {
            $imputations=Imputation::orderby('id')->get();     
        }

        return View::make('mandatements/imputations.index', [ 
            'user'=>$user,
            'imputations' => $imputations,
           'exercice' => $exercice,
            'exercices' => $exercices,
        ]);
    }


     public function create()
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $comptes=$this->getListeComptes();
        return View::make('mandatements/imputations.create', 
            [
            'user'=>$user,"comptes"=>$comptes
            ]);
    }
 
     public function create_avec_mandat($mandat_id="")
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $comptes=$this->getListeComptes();
        $mandat=Mandat::find($mandat_id);
        return View::make('mandatements.imputations.create', ['user'=>$user,
            'mandat' => $mandat,"comptes"=>$comptes]);
    }

    public function store(ImputationRequest $request)
    {
        $mode_frame=$request->mode_frame;
        $imputation = new Imputation;
        $imputation->cpt_imp = $request->cpt_imp;
        $imputation->designation = $request->designation;
        $imputation->montant = $request->montant;
        $imputation->type_imp = $request->type_imp;
        $imputation->obs = $request->obs;
        $imputation->idmandat = $request->idmandat;
        $imputation->save();
        if($mode_frame==true) {
            $title="Création effectuée";
            $msg="<blockquote><h2>L'imputation a été créée.</h2></blockquote>".
            "<br><br>".
            "Vous pouvez fermer cette fenêtre la fiche Mandat sera enregistrée et réactualisée.";
            return View::make('/mandatements/imputations/close', ['msg' => $msg
                ,'title' => $title]);
        }
        return Redirect::to('mandatements/imputations/');
     }
 

    public function edit($id)
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $comptes=$this->getListeComptes();
        $imputation=Imputation::find($id);
        if(!$imputation) return;
        return View::make('mandatements/imputations.edit', 
            [
            'imputation' => $imputation,
            'user'=>$user,"comptes"=>$comptes,
            ]);

    }

     public function edit_avec_mandat($id,$mandat_id="")
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $comptes=$this->getListeComptes();
        $mandat=Mandat::find($mandat_id);
        $imputation=Imputation::find($id);
        if(!$imputation) return;
        return View::make('mandatements.imputations.edit', [
            'imputation' => $imputation,
            'user'=>$user,
            'mandat' => $mandat,"comptes"=>$comptes]);
    }


    public function show_frame($id)
    {
        return $this->show($id,true);
    }

    public function show($id,$frame=false)
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $comptes=$this->getListeComptes();
        $imputation=Imputation::find($id);
        if(!$imputation) return;
        return View::make('mandatements/imputations.show', 
            [
            'imputation' => $imputation,
            'user'=>$user,
            'frame'=>$frame,"comptes"=>$comptes,
            ]);
     }
 


    public function update($id,ImputationRequest $request)
    {
        $mode_frame=$request->mode_frame;
        $imputation = Imputation::find($id);
        $imputation->cpt_imp = $request->cpt_imp;
        $imputation->designation = $request->designation;
        $imputation->montant = $request->montant;
        $imputation->type_imp = $request->type_imp;
        $imputation->obs = $request->obs;
        $imputation->idmandat = $request->idmandat;
        $imputation->save();
        if($mode_frame==true) {
            $title="Modification effectuée";
            $msg="<blockquote><h2>L'imputation a été modifiée.</h2></blockquote>".
            "<br><br>".
            "Vous pouvez fermer cette fenêtre la fiche Mandat sera enregistrée et réactualisée.";
            return View::make('/mandatements/imputations/close', ['msg' => $msg
                ,'title' => $title]);
        }
        return Redirect::to('mandatements/imputations/');
    }
 

    public function destroy($id)
    {
        Imputation::destroy($id);
 
        return Redirect::to('/mandatements/imputations/');
    }



 /**
     * Listes des Comptes
     */
    public function getListeComptes()
    {
        $comptes = DB::table('plans')
            ->select('numcpt',db::raw("CONCAT(numcpt,' ',nomcpt) as nomcpt"))
            ->distinct('exercice')
            ->pluck('nomcpt','numcpt')->toArray();

        return $comptes;
    }


 /**
     * Listes des exercices
     */
    public function getListeExercices()
    {
        $exercices = DB::table('mandats')->select('exercice')->distinct('exercice')->pluck('exercice')->toArray(); 

        return $exercices;
    }

    /**
     * Listes des exercices sur 2 ans
     */
    public function getListeExercicesBi()
    {
        $exercices = $this->getListeExercices();
        $nb_exercices=count($exercices );
        $k=0;$t=array();
        foreach($exercices as $exercice) {
            $k++;
            $exercice_min=intval($exercice)-1;
            $exercice_max=intval($exercice)+1;
            if($k%2==0) {
                $t[$exercice_min."-".$exercice]=$exercice_min." - ".$exercice;
                if($k<$nb_exercices) $t[$exercice."-".$exercice_max]=$exercice." - ".$exercice_max;
            }
        }
        arsort($t);
        $t['*']='Tous';
        return $t;
    }


 
}