<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\Models\Med;
use App\Models\Employeur;
use App\Models\User;
use App\Models\Role2;
use App\Models\Parametre;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use App\Http\Requests\MedRequest;
use Request;
use Response;


class MedController extends Controller {
 

    public function index($param="")
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $meds = Med::all();
        return View::make('recouvrement.med.index', ['meds' => $meds, 'user'=>$user]);
    }
 
    /**
     * Show the form for creating a new user.
     *
     * @return Response
     */
    public function create($employeur_id="",$exercice="")
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $employeur = Employeur::find($employeur_id);
        $liste_employeur=$this->getListeEmployeur(true);  

        $exercice_encours=Parametre::where('ref','=','CPT_EXERCICE')->first()->value;
        if($exercice=="") $exercice=$exercice_encours-1; 
        $prc_maj=Parametre::where('ref','=','CAL_PRC_MAJ')->first()->value;
        $taux_CLR=Parametre::where('ref','=','TAUX_CLR_CCPF')->first()->getTauxCLRAttribute();
        $taux_CPF=Parametre::where('ref','=','TAUX_CLR_CCPF')->first()->getTauxCCPFAttribute();
        $taux=$taux_CLR[$exercice]+$taux_CPF[$exercice];
        $masse_dernier=$employeur->getMasseDerniersSalaires($exercice);
        $mois_manquants=$employeur->getNbMoisManquantsSalaires($exercice);
        $taux_total=$taux;
        $cotisations=round($masse_dernier*$taux_total/100,0);
        $cotisations=$cotisations*$mois_manquants;
        $majorations=$employeur->getMajoration($exercice);

        return View::make('recouvrement.med.create', [
            "employeur"=>$employeur,
            "liste_employeur"=>$liste_employeur,
            'user'=>$user,
            'cotisations'=>$cotisations,
            'majorations'=>$majorations,
            'nbmois' => $mois_manquants
            ]);
    }
 

    public function store(MedRequest $request)
    {
        $med = new Med;

        $date=$request->date_envoi;
        $med->date_envoi = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;
        $med->sonum = $request->sonum;
        $med->motif = $request->motif;
        $med->nbmois = $request->nbmois;
        $med->cotisations = $request->cotisations;
        $med->majorations = $request->majorations;
        $date=$request->periode_deb;
        $med->periode_deb = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;

        $date=$request->periode_fin;
        $med->periode_fin = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;

        $med->obs = $request->obs;
        $med->numero =DB::table('med')->max('numero')+1;
        $med->save();
        return Redirect::to('/recouvrement/med_prepa');
    }
 

    public function edit($id)
    {
        $ile="";
        $banque = Banque::find($id);
        return View::make('recouvrement.med.edit', [ 'banque'=> $banque]);
    }
 

    public function update($id,MedRequest $request)
    {
        $med = Med::find($id);
        $med->date_envoi = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;
        $med->sonum = $request->sonum;
        $med->motif = $request->motif;
        $med->nbmois = $request->nbmois;
        $med->cotisations = $request->cotisations;
        $med->majorations = $request->majorations;
        $date=$request->periode_deb;
        $med->periode_deb = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;

        $date=$request->periode_fin;
        $med->periode_fin = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;

        $med->obs = $request->obs;
        $med->numero =DB::table('med')->max('numero')+1;
        $med->save();

        return Redirect::to('/recouvrement/med');
    }
 


    public function show($id)
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $med=Med::find($id);

        return View::make('recouvrement.med.show', 
            [
            'med' => $med,
            'user'=>$user,
            ]);
     }


    public function destroy($id)
    {
        Med::destroy($id);
 
        return Redirect::to('/recouvrement/med');
    }



    /**
     * Listes des employeurs
     */
    public function getListeEmployeur($avec_id=false)
    {
        $liste_employeur=Employeur::distinct()->select('nom','id')->orderBy('id')->pluck('nom','id')->toArray();
        $liste_employeur2=array();
        foreach($liste_employeur as $id=>$nom) {
            $nom=trim($nom);
            $liste_employeur2[$id]=htmlentities(str_replace('"','',$nom));
            if($avec_id) $liste_employeur2[$id]=str_pad($id,4,"0", STR_PAD_LEFT)." ".$liste_employeur2[$id];
        }
        return $liste_employeur2;
    }

}