<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\Models\User;
use App\Models\Parametre;
use App\Models\Role2;
use Illuminate\Support\Facades\Session;
use View;
use DB;
use App\Http\Requests\ParamRequest;

class ParametresController extends Controller {

    /**
     * Display a listing of the parametre.
     *
     * @return Response
     */
    public function index()
    {
        $user=User::where('id','=',Session::get('id'))->first();
        //$parametres = Parametre::where('nom', 'not like', 'date_%')->orderBy('position')->get();
        //les paramètres commencant pas np ne sont pas utilisés dans les interfaces
        $parametres = Parametre::where('ref', 'not like', 'np%')->orderBy('position')->get();

        return View::make('param.index', ['parametres' => $parametres,'user' => $user]);
    }

      /**
     * Display a listing of the parametre.
     *
     * @return Response
     */
    public function show($id=0)
    {

        echo  "show";
        exit();
    }


    /**
     * Show the form for creating a new parametre.
     *
     * @return Response
     */
    public function create()
    {
        return View::make('param.parametres.create');
    }
 
    /**
     * Store a newly created parametre in storage.
     *
     * @return Response
     */
    public function store(Request $request)
    {

 
        return Redirect::to('/param/parametres');
    }


    /**
     * Show the form for editing the specified parametre.
     *
     * @param  int  $id
     * @return Response
     */
    public function edit($id)
    {
        $parametre = Parametre::find($id);
        return View::make('param.parametres.edit', [ 'parametre' => $parametres ]);

    }    


    /**
     * Update the specified parametre in storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function update(ParamRequest $request)
    { 
        $parametres = Parametre::where('ref2', 'not like', '')->get(); //sauf les dates
        foreach($parametres as $parametre) {
            $param = Parametre::find($parametre->ref2);
            if($param) {

                if($parametre->ref2=="TAUX_CLR_CCPF") { //Cas particulier ds taux
                    $res="";
                    $t_taux=explode("\r\n",$parametre->value); 
                    rsort($t_taux);
                    $max_annee=(intval(substr($t_taux[0],0,4))+1);
                    sort($t_taux);
                    $min_annee=(intval(substr($t_taux[0],0,4)));
                    for($i=$min_annee;$i<=$max_annee;$i++) {
                        $annee=$request->{$parametre->ref2."_clr_".$i};
                        $ccpf=$request->{$parametre->ref2."_ccpf_".$i};
                        $clr=$request->{$parametre->ref2."_clr_".$i};
                        if($ccpf.$clr!="") $res.=(($res=="")?"":"\r\n").$i.";".$clr.";".$ccpf;
                    }
                    $param->value =$res;
                    $param->save();
                }
                else {
                    //if($parametre->ref2=="LST_PLAFOND_SMIG") dd($request->{$parametre->ref2});
                    $param->value = ($request->{$parametre->ref2});
                    $param->save();
                }
            }
        }
        return redirect('/param/parametres');
    }

    /**
     * Remove the specified parametre from storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function destroy($id)
    {
        Parametre::destroy($id);
 
        return Redirect::to('/param/parametres');
    }
}
