<?php namespace App\Http\Controllers;

 
use Auth\AuthController;
use App\Models\User;
use App\Models\Role2;
use App\Models\Permission2;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;
use App\Http\Requests\PermissionRequest;


class PermissionsController extends Controller {
 
    public function __construct()
    {
        //$this->beforeFilter('auth');
    }
 
    /**
     * Display a listing of the permission.
     *
     * @return Response
     */
    public function index()
    {
        $user=User::where('id','=',Session::get('id'))->first();
        if(!$user->hasRole("ADMINISTRATEUR")) return;

        $permissions = Permission2::where('id', '<>', 'null')->orderBy('name')->get();
        return View::make('acces.permissions.index', ['permissions' => $permissions, 'user'=>$user]);
    }
 

    public function create()
    {
        $user=User::where('id','=',Session::get('id'))->first();
        if(!$user->hasRole("ADMINISTRATEUR")) return;

        return View::make('acces.permissions.create');
    }
 

    public function store(PermissionRequest $request)
    {
        $permission = new Permission2;
 
        $permission->name = $request->name;
        $permission->display_name = $request->display_name;
        $permission->save();

        return Redirect::to('/acces/permissions');
    }
 

    public function edit($id)
    {
        $user=User::where('id','=',Session::get('id'))->first();
        if(!$user->hasRole("ADMINISTRATEUR")) return;

        $permission = Permission2::find($id);
        return View::make('acces.permissions.edit', [ 'permission' => $permission ]);
    }
 

    public function update($id,PermissionRequest $request)
    {

        $permission = Permission2::find($id);
        $permission->name = $request->name;
        $permission->display_name = $request->display_name;
        $permission->save();
 
        return Redirect::to('/acces/permissions');
    }
 

    public function destroy($id)
    {
        $user=User::where('id','=',Session::get('id'))->first();
        if(!$user->hasRole("ADMINISTRATEUR")) return;
        
        Permission2::destroy($id);
 
        return Redirect::to('/acces/permissions');
    }
 


}



