<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\Models\Plan;
use App\Models\User;
use App\Models\Parametre;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use App\Http\Requests\PlanRequest;
use Illuminate\Http\Request;

class PlanController extends Controller {
 

    public function index($exercice="")
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $plans=Plan::all();
        $exercice_encours=Parametre::where('ref','=','CPT_EXERCICE')->first()->value;
        if($exercice=="") $exercice=$exercice_encours;
        $exercices=$this->getListeExercices();
        return View::make('compta.plan.index', ['plans' => $plans, 
            'exercice' => $exercice,
            'exercices' => $exercices,
            'exercice_encours' => $exercice_encours,
            'user'=>$user]);

    }



    public function show($plan_id,$exercice)
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $plan=Plan::find($plan_id);
        if($exercice=="") $exercice=date('Y');
        $comptes = DB::table('plans')
            ->select('numcpt',db::raw("CONCAT(numcpt,' ',nomcpt) as nomcpt"))
            ->distinct('exercice')
            ->pluck('nomcpt','numcpt')->toArray(); 

        return View::make('compta.plan.show', ['plan' => $plan, 
            'exercice' => $exercice,'user'=>$user,"comptes"=>$comptes]);
    }


    public function create()
    {
        $comptes = DB::table('plans')
            ->select('numcpt',db::raw("CONCAT(numcpt,' ',nomcpt) as nomcpt"))
            ->distinct('exercice')
            ->pluck('nomcpt','numcpt')->toArray();; 
        return View::make('compta.plan.create', ["comptes"=>$comptes]);
    }
 


    public function store(PlanRequest $request)
    {

        $credit=$request->credit;
        $debit=$request->debit;
        $budget=$request->budget;
        if($credit=="") $credit=0;
        if($debit=="") $debit=0;
        if($budget=="") $budget=0;

        $plan = new Plan;
        $plan->numcpt=$request->numcpt;
        $plan->nomcpt=$request->nomcpt;
        $plan->categ=$request->categ;
        $plan->categ_bilan=$request->categ_bilan;
        $plan->categ_cr=$request->categ_cr;
        //$plan->poste=$request->$poste;
        $plan->budget=$budget;
        $plan->debit=$debit;
        $plan->credit=$credit;

        $plan->soldei=$budget+ $credit-$debit;
        $plan->amort=$request->amort;
        //$plan->debit_credit=$request->$debit-$request->$credit;
        //$plan->amortissement=$request->$request;
        //$plan->n_classe=$request->$amortissement;
        $plan->save();
        return Redirect::to('/compta/plan');
    }
 

    public function edit($id)
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $comptes = DB::table('plans')
            ->select('numcpt',db::raw("CONCAT(numcpt,' ',nomcpt) as nomcpt"))
            ->distinct('exercice')
            ->pluck('nomcpt','numcpt')->toArray();
        $plan = Plan::find($id);
        return View::make('compta.plan.edit', ['plan' => $plan,
        "comptes"=>$comptes, 'user'=>$user]); 
    }
 



    public function update($id,PlanRequest $request)
    {
        $plan = Plan::find($id);
        $plan->numcpt=$request->numcpt;
        $plan->nomcpt=$request->nomcpt;
        $plan->categ=$request->categ;
        $plan->categ_bilan=$request->categ_bilan;
        $plan->categ_cr=$request->categ_cr;
        //$plan->poste=$request->$poste;
        $plan->budget=$request->budget;
        $plan->debit=$request->debit;
        $plan->credit=$request->credit;
        $plan->soldei=$request->budget+$request->credit-$request->debit;
        $plan->amort=$request->amort;
        //$plan->debit_credit=$request->$debit-$request->$credit;
        //$plan->amortissement=$request->$request;
        //$plan->n_classe=$request->$amortissement;
        $plan->save();

        return Redirect::to('/compta/plan');
    }
 
    /**
     * Remove the specified user from storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function destroy($id)
    {
        plan::destroy($id);
 
        return Redirect::to('/compta/plan');
    }
 

     /**
     * Listes des exercices
     */
    public function getListeExercices()
    {
        $t_exercices=array();
        $exercices = DB::table('journal')
            ->select(db::raw("distinct(LEFT(date,4)) as exercice"))
            ->orderby('exercice','DESC')->get(); 

        foreach($exercices as $exercice) $t_exercices[$exercice->exercice]=$exercice->exercice;
        if(!isset($t_exercices[date('Y')])) $t_exercices[date('Y')]=date('Y');
        arsort($t_exercices);
        return $t_exercices;
    }

    
    public function api_get_budget($compte)
    {
        $associate = array();
        $budget    = DB::table('plans')->select('budget')->where('numcpt','=',$compte)->value('budget');
        if(!isset($budget)) return 0;
        return ($budget);
    }


}