<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\Models\Employeur;
use App\Models\Beneficiaire;
use App\Models\Cotisation;
use App\Models\Parametre;
use App\Models\User;
use App\Models\Role2;
use App\Models\Email;
use App\Models\MyApp;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use Illuminate\Http\Request;
use Response;
use Illuminate\Support\Facades\Mail;
use App\Http\Controllers\Editions\EditionsCotisationsBordereau;

class RecouvrementTaxationController extends Controller {
 

 
    /**
     * Display a listing of the user.
     *
     * @return Response
     */
    public function index($exercice="")
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $titre2="";
       $employeurs = Employeur::where('statut','=','ACT')->get();
//$employeurs = Employeur::where('statut','=','ACT')->where('id','=','1623')->get();

        $exercice_encours=Parametre::where('ref','=','CPT_EXERCICE')->first()->value;
        if($exercice=="") $exercice=$exercice_encours-1; 
        $exercices=MyApp::getListeExercices();
        $prc_maj=Parametre::where('ref','=','CAL_PRC_MAJ')->first()->value;

        $taux_CLR=Parametre::where('ref','=','TAUX_CLR_CCPF')->first()->getTauxCLRAttribute();
        $taux_CPF=Parametre::where('ref','=','TAUX_CLR_CCPF')->first()->getTauxCCPFAttribute();

        $taux=$taux_CLR[$exercice]+$taux_CPF[$exercice];

        return View::make('recouvrement.taxation.index_taxation', ['employeurs' => $employeurs,
            'user'=>$user,
            'exercices'=>$exercices,
            'exercice'=>$exercice,
            'prc_maj'=>$prc_maj,
            'taux'=>$taux
            ]); 

    }


}