<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\Models\Beneficiaire;
use App\Models\Parametre;
use App\Models\User;
use App\Models\Role2;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use App\Http\Requests\AutoResponsableRequest;
use Illuminate\Http\Request;


class RetraitesController extends Controller {
    /**
     * Liste des versements
     */

    public function reajustement_index()
    {
        $user=User::where('id','=',Session::get('id'))->first();        

        return View::make('prestations.retraites.operations.reajustement', [ 
            'user'=>$user,
            'mode'=>'saisie',
        ]);
    }




    public function simulation_index(Request $result)
    {
        $user=User::where('id','=',Session::get('id'))->first();        
        $taux=$result->taux;
        $nb_rap=$result->nb_rap;
        $taux=str_replace(',','.',$taux);
        
        //PRE/PRV/PAV/PRA
       /* $t_filtre=['PRE','PRV','PAV','PRA'];
        ['R','RA','RAU','RAV','RVE','AR','SAR','AAV']
        $beneficiaires = Beneficiaire::whereIn('ret_type', $t_filtre)
            ->whereNotIn('statut',['D'])
            ->orderBy('nom')->orderBy('prenom')->get();
        */

        $beneficiaires=$this->retraitesAReajuster();
        return View::make('prestations.retraites.operations.reajustement', [ 
            'user'=>$user,
            'taux'=>$taux,
            'nb_rap'=>$nb_rap,
            'beneficiaires'=>$beneficiaires,
            'mode'=>'confirm',
        ]);
    }

    public function validation(Request $result)
    {
        $user=User::where('id','=',Session::get('id'))->first();  
        $taux=$result->taux;
        $nb_rap=$result->nb_rap;
        $taux=str_replace(',','.',$taux);
        if(($taux>0)&&($taux<10)) {
            //PRE/PRV/PAV/PRA
            /*$t_filtre=['PRE','PRV','PAV','PRA'];
            $beneficiaires = Beneficiaire::whereIn('ret_type', $t_filtre)
                ->whereNotIn('statut',['D'])
                ->orderBy('nom')->orderBy('prenom')->get();
            */
            $beneficiaires=$this->retraitesAReajuster();
            $nb=0;

            foreach($beneficiaires as $beneficiaire) {
                //if($beneficiaire->ret_date_reajust=="0000-00-00 00:00:00") {
                if(substr($beneficiaire->ret_date_reajust,0,4)!="2020") {
                    $new_montant=round($beneficiaire->ret_montant*(1+($taux/100)),0); 
                    $new_rappel=$beneficiaire->ret_rappel+$nb_rap*(round($beneficiaire->ret_montant*($taux/100),0));
                    //echo $beneficiaire->id." => ".$beneficiaire->ret_montant." => ".$new_montant
                    //    ." => ".$beneficiaire->ret_rappel." => ".$new_rappel."<br/>";
                    $beneficiaire->ret_montant=$new_montant;
                    $beneficiaire->ret_rappel=$new_rappel;
                    $beneficiaire->ret_date_reajust=date('Y-m-d H:i:s');
                    $beneficiaire->save();
                    $nb++;
                }
            }

            return View::make('prestations.retraites.operations.reajustement', [ 
                'user'=>$user,
                'taux'=>$taux,
                'beneficiaires'=>$beneficiaires,
                'mode'=>'validation',
                'nb'=>$nb,
            ]);
        }
    }


    public function retraitesAReajuster()
    {
        $statuts=['R','RA','RAU','RAV','RVE','AR','SAR','AAV'];
        $beneficiaires = Beneficiaire::whereIn('statut', $statuts)->orderBy('nom')->orderBy('prenom')->get();

        return $beneficiaires;
    }



    public function reajustementCSR_index()
    {
        $user=User::where('id','=',Session::get('id'))->first();        

        return View::make('prestations.retraites.operations.reajustementCSR', [ 
            'user'=>$user,
            'mode'=>'saisie',
        ]);
    }

    public function simulationCSR_index(Request $result)
    {
        $user=User::where('id','=',Session::get('id'))->first();        
        $montant_csr=$result->montant_csr;
        
        //PRE/PRV/PAV/PRA
        $t_filtre=['SAV','SAR','SAA'];
        $beneficiaires = Beneficiaire::whereIn('statut', $t_filtre)
            ->orderBy('nom')->orderBy('prenom')->get();

        return View::make('prestations.retraites.operations.reajustementCSR', [ 
            'user'=>$user,
            'montant_csr'=>$montant_csr,
            'beneficiaires'=>$beneficiaires,
            'mode'=>'confirm',
        ]);
    }


    public function validationCSR(Request $result)
    {
        $user=User::where('id','=',Session::get('id'))->first();  
        $montant_csr=$result->montant_csr;

            //PRE/PRV/PAV/PRA
            $t_filtre=['SAV','SAR','SAA'];
            $beneficiaires = Beneficiaire::whereIn('statut', $t_filtre)
                ->orderBy('nom')->orderBy('prenom')->get();
            $nb=0;

            foreach($beneficiaires as $beneficiaire) {
                $beneficiaire->csr_montant=$montant_csr;
                $beneficiaire->save();
                $nb++;
            }

            return View::make('prestations.retraites.operations.reajustementCSR', [ 
                'user'=>$user,
                'montant_csr'=>$montant_csr,
                'beneficiaires'=>$beneficiaires,
                'mode'=>'validation',
                'nb'=>$nb,
            ]);
    }
}