<?php namespace App\Http\Controllers;
 
use Auth\AuthController;
use App\Models\User;
use App\Models\Role2;
use App\Models\Benefstatut;
use App\Models\Permission2;
use App\Models\PermissionGroupe;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;
use App\Http\Requests\RoleRequest;
use Illuminate\Http\Request;
use Input;
use App\Http\Controllers\Logs;

class RolesController extends Controller {
 
    public function __construct()
    {
        //$this->beforeFilter('auth');
    }
 

    public function index()
    {
        $user=User::where('id','=',Session::get('id'))->first();
        if(!$user->can("ROL_VISU")&&(!$user->hasRole("ADMINISTRATEUR"))) return;

        $roles = Role2::where('id', '<>', 'null')->where('name','<>','ADMINISTRATEUR')->orderBy('name')->get();
   
        return View::make('acces.roles.index', ['roles' => $roles, 'user'=>$user]);
    }

    public function index_det()
    {
        $user=User::where('id','=',Session::get('id'))->first();
        if(!$user->can("ROL_VISU")&&(!$user->hasRole("ADMINISTRATEUR"))) return;


        $roles = Role2::where('id', '<>', 'null')->where('name','<>','ADMINISTRATEUR')->orderBy('name')->get();
   
        return View::make('acces.roles.index_ltd', ['roles' => $roles, 'user'=>$user]);
    }


    public function index_tableau($id_groupe="")
    {
        $user=User::where('id','=',Session::get('id'))->first();
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("ROL_VISU")) return Redirect::route('home');

        if(($id_groupe!="")&&($id_groupe!=0)) {
            $permissions= Permission2::where('id_groupe','=',$id_groupe)->where('name','not like','%motif%')->orderby('name','asc')->get();
        } else {
            $permissions= Permission2::orderby('id_groupe','asc')
                ->where('name','not like','%motif%')->where('name','not like','%parametr%')
                //->where('name','like','%motif%')
                ->where('display_name','not like','Permiss%')
                ->orderby('name','asc')->get();
        }
        $roles = Role2::where('name','<>','ADMINISTRATEUR')->orderby('name','ASC')->get();
        

        $liste_groupes = PermissionGroupe::select('id','nom')->orderby('nom','asc')->pluck('nom','id')->toArray();


        return View::make('acces.roles.index_tableau', [
            'roles' => $roles, 
            'user'=>$user,
            'roles'=>$roles,'permissions'=>$permissions,
            'liste_groupes'=>$liste_groupes,
            'id_groupe' => $id_groupe
            ]
        );
    }
 
    public function create()
    {
        $user=User::where('id','=',Session::get('id'))->first();
        if(!$user->can("ROL_AJO")&&(!$user->hasRole("ADMINISTRATEUR"))) return;

        return View::make('acces.roles.create');
    }
 

    public function store(RoleRequest $request)
    {
        $role = new Role;
        $role->name = strtoupper($request->name);
        $role->save();
         //LOG de la transaction
        $role->log_transaction($request->url(),'I');

        return Redirect::to('/acces/roles');
    }
 

    public function edit($id)
    {

        $user=User::where('id','=',Session::get('id'))->first();
        if(!$user->can("ROL_MAJ")&&(!$user->hasRole("ADMINISTRATEUR"))) return;

        $role = Role2::find($id);
        $liste_premissions=Permission2::orderby('display_name')->pluck("display_name", "id")->toArray();;
        $liste_benefstatut=Benefstatut::orderby('libelle')->get()->pluck("libelle", "ref")->toArray();;
        $liste_benefstatut["*"]="Tous";
       // $liste_benefstatut[""]=" ";


        $t_getPermissions=DB::table('role_has_permissions')
            ->where('role_id', '=', $id)
            ->pluck("permission_id")
            ->toArray();

        //if(count($t_getPermissions)) $t_getPermissions=[];

        return View::make('acces.roles.edit', [ 'role' => $role , 
            't_getPermissions' => $t_getPermissions, 
            "liste_benefstatut" =>  $liste_benefstatut
            , 'liste_premissions' => $liste_premissions]);

    }
 

    public function update($id,RoleRequest $request)
    {
        $role = Role2::find($id);
        $role->name  = strtoupper($request->name);
        $role->benef_statut  = strtoupper($request->benef_statut);
        $role->save();

        $log_values="id=>".$role->id.";name=>".$role->name.";benef_statut=>".$role->benef_statut;

        //Attach Permissions
        //Détache les anciennes permissions

        DB::table('role_has_permissions')->where('role_id', '=', $role->id)->delete();
        if(isset($request->role_permissions)) {
            $t_role_permissions = $request->role_permissions;
            if(count($t_role_permissions)>0) {
                //Attache les nouveaux
                foreach($t_role_permissions as $permission_id) {
                    $permission = Permission2::find($permission_id);
                    $role->givePermissionTo($permission );
                }
            }
        }

         //LOG de la transaction
        $role->log_transaction($request->url(),'U',$log_values);

        return Redirect::to('/acces/roles');
    }
 
    public function show($id)
    {

        $user=User::where('id','=',Session::get('id'))->first();
        if(!$user->can("ROL_MAJ")&&(!$user->hasRole("ADMINISTRATEUR"))) return;

        $role = Role2::find($id);
        $liste_premissions=Permission2::orderby('display_name')->pluck("display_name", "id")->toArray();;
        $liste_benefstatut=Benefstatut::orderby('libelle')->get()->pluck("libelle", "ref")->toArray();;
        $liste_benefstatut["*"]="Tous";

        $t_getPermissions=DB::table('role_has_permissions')
            ->where('role_id', '=', $id)
            ->pluck("permission_id")
            ->toArray();

        //if(count($t_getPermissions)) $t_getPermissions=[];

        return View::make('acces.roles.show', [ 'role' => $role , 
            't_getPermissions' => $t_getPermissions, 
            "liste_benefstatut" =>  $liste_benefstatut
            , 'liste_premissions' => $liste_premissions]);

    }
    public function destroy($id)
    {
        $user=User::where('id','=',Session::get('id'))->first();
        if(!$user->can("ROL_SUP")&&(!$user->hasRole("ADMINISTRATEUR"))) return;
        DB::table('role_has_permissions')->where('role_id', '=', $id)->delete();
        $role=Role2::find($id);
        $role->log_transaction('','D');
        Role2::destroy($id);
 
        return Redirect::to('/acces/roles');
    }
 


    public function newprofil()
    {
        //$user=Auth\AuthController::getUserCnx();
        $user=User::where('id','=',Session::get('id'))->first();
        $users_list=array();
        $res_list=array();
        $origine_user_id=User::where('id','=',Session::get('origine_id'))->first();
        if($origine_user_id->HasRole("ADMINISTRATEUR") 
            || $origine_user_id->hasRole("ADMINISTRATEUR FONCTIONNEL")) {
            //$assigned_roles = DB::table('assigned_roles')->where('user_id','=',$user->id)->get();
            $users_list=DB::table('users')->orderby(db::raw("CONCAT(nom,' ',prenom)"))
                ->pluck(db::raw("CONCAT(nom,' ',prenom) as nom"), 'id')->toArray();
            foreach($users_list as $id=>$nom) {
                $user_enc=User::find($id);
                if(!$user_enc->hasrole('ADMINISTRATEUR') && ($origine_user_id->id!=$id) 
                    || (!$user_enc->Sysadmin) ) {
                    $res_list[$id]=$nom;
                }
            }
            return View::make('param.actions.index', ['users_list' => $res_list,'user' => $user]);
        }
        return;
    }



    public function origine_profil()
    {
         $user=User::where('id','=',Session::get('id'))->first();

        $origine_user_id=User::where('id','=',Session::get('origine_id'))->first();
        if($origine_user_id->hasRole("ADMINISTRATEUR") || $origine_user_id->hasRole("ADMINISTRATEUR FONCTIONNEL")) {
            $user = User::find($origine_user_id->id);
            Session::put('id', $user->id);
            return Redirect::to('/accueil');
        }
       return ;
    }
    

    public function changeprofil(Request $request)
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $origine_user_id=User::where('id','=',Session::get('origine_id'))->first();
        if($origine_user_id->hasRole("ADMINISTRATEUR") || $origine_user_id->hasRole("ADMINISTRATEUR FONCTIONNEL")) {
            //Attach Protocole
            $user_id = $request->user_id;
            if($user_id>0) {
                $user = User::find($user_id);  
                Session::put('id', $user->id);
                return Redirect::to('/accueil');
            }
        }
       return ;
    }
}


