<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\Models\Employeur;
use App\Models\Beneficiaire;
use App\Models\Salaire;
use App\Models\Secteur;
use App\Models\User;
use App\Models\Role2;
use App\Models\LogSalaire;
use App\Models\MyApp;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use App\Http\Requests\SalaireRequest;
use App\Http\Requests\AutoResponsableRequest;
use Request;
use Response;
use App\Models\Parametre;


class SalairesController extends Controller {
 

    public function __construct()
    {
        if(!Session::get('id')) return Redirect::route( 'login' );
    }
 
    /**
     * Liste des salaires
     */
    public function index($employeur_id=0,$beneficiaire_id=0,$exercice="")
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $liste_employeur=$this->getListeEmployeur(false);  
        $salaires=array();

        $exercices = ['*'=>'Tous']+$this->getListeExercices(); 
        if(($exercice=="")||($exercice=="0")) $exercice=date('Y');

        $liste_employes=array(0=>" ");
        $employeur_nom="";
        $nb_salaire=array();
        if($employeur_id) {
            if($employeur_id!="999999") {
                $employeur=employeur::find($employeur_id);
                $employeur_nom=$employeur_id." ".trim($employeur->nom);
                
                $liste_employes2=array();
                if($exercice=="*") { //Tous uniquement si toutes les années
                    $liste_employes1=Beneficiaire::
                        join('salaire','salaire.benum','=','beneficiaires.id', 'left outer')
                        ->select(db::raw('CONCAT(TRIM(beneficiaires.nom)," ",TRIM(beneficiaires.prenom)," (",beneficiaires.id,")") as nom'),'beneficiaires.id as id')
                        ->where('salaire.sonum','=',$employeur_id)
                        ->orderBy('beneficiaires.nom')
                        ->pluck('beneficiaires.nom','beneficiaires.id')->toArray();

                    $liste_employes2=Beneficiaire::
                        where('beneficiaires.sonum','=',$employeur_id)
                        ->select(db::raw('CONCAT(TRIM(beneficiaires.nom)," ",TRIM(beneficiaires.prenom)," (",beneficiaires.id,")") as nom'),'beneficiaires.id as id')
                        ->orderBy('beneficiaires.nom')
                        ->pluck('beneficiaires.nom','beneficiaires.id')->toArray();  
                } else { //sinon seuls ceux de lannée en cours
                    $liste_employes1=Beneficiaire::
                        join('salaire','salaire.benum','=','beneficiaires.id', 'left outer')
                        ->select(db::raw('CONCAT(TRIM(beneficiaires.nom)," ",TRIM(beneficiaires.prenom)," (",beneficiaires.id,")") as nom'),'beneficiaires.id as id')
                        ->where('salaire.sonum','=',$employeur_id)
                        ->where('salaire.annee','=',$exercice)
                        /*->where(function($query) use ($exercice) {
                            $query->where('date_sor', '>', $exercice."01-01")
                            ->orwhereNull('date_sor');
                        })*/
                        ->orderBy('beneficiaires.nom')
                        ->pluck('beneficiaires.nom','beneficiaires.id')->toArray();    
                }

                foreach($liste_employes1 as $id=>$nom) $liste_employes[$id]=$nom;
                foreach($liste_employes2 as $id=>$nom) {
                    if(!isset($liste_employes1[$id])) $liste_employes[$id]=$nom;
                }
                asort($liste_employes); 

                $salaires_obj = Salaire::where('sonum','=',$employeur_id);
                if($beneficiaire_id) {
                    $salaires_obj = $salaires_obj->where('benum','=',$beneficiaire_id);
                }
                //if($list_exercice!='') $salaires_obj = $salaires_obj->wherein('annee',$list_exercice); 
                if(($exercice!='')&&($exercice!='*') ) $salaires_obj = $salaires_obj->where('annee',"=",$exercice); 
                $salaires = $salaires_obj->orderBy('annee','DESC')->get();  

            } else {
                $employeur_nom="TOUS";
                $liste_employes1=Beneficiaire::
                    where('beneficiaires.sonum','<>','0')
                    ->orderBy('beneficiaires.nom')
                    ->pluck('beneficiaires.nom','beneficiaires.id')->toArray();
                foreach($liste_employes1 as $id=>$nom) {
                    $liste_employes[$id]=$nom;
                } 
                
                $salaires = Salaire::where('annee','=',$exercice)
                    ->orderBy('annee','DESC')->get();  

            }
            //Pour total salaires
            
            $t_mois=array('jan','fev','mar','avr','mai','jun','jui','aou','sep','oct','nov','dec');
            foreach($t_mois as $mois) $nb_salaire[$mois]=0;
            $nb_salaire["total"]=0;
            foreach ($salaires as $salaire) {
                $t_nb=$salaire->Nbsalaire;
                foreach($t_mois as $mois) $nb_salaire[$mois]+=$t_nb[$mois];
                $nb_salaire["total"]+=$t_nb["total"];
               /* $nb_salaire["total"]++;
                if($salaire->jan>0) $nb_salaire['jan']++;
                if($salaire->fev>0) $nb_salaire['fev']++;
                if($salaire->mar>0) $nb_salaire['mar']++;
                if($salaire->avr>0) $nb_salaire['avr']++;
                if($salaire->mai>0) $nb_salaire['mai']++;
                if($salaire->jun>0) $nb_salaire['jun']++;
                if($salaire->jui>0) $nb_salaire['jui']++;
                if($salaire->aou>0) $nb_salaire['aou']++;
                if($salaire->sep>0) $nb_salaire['sep']++;
                if($salaire->oct>0) $nb_salaire['oct']++;
                if($salaire->nov>0) $nb_salaire['nov']++;
                if($salaire->dec>0) $nb_salaire['dec']++;
                */

            }
        }


        return View::make('recouvrement.salaires.index', [ 
            'salaires' => $salaires,
            'user'=>$user,
            'employeur_id'=>$employeur_id,
            'employeur_nom'=>$employeur_nom,
            'beneficiaire_id'=>$beneficiaire_id,
            'liste_employeur' => $liste_employeur,
            'liste_employes' => $liste_employes,
            'exercices' => $exercices,
            'exercice' => $exercice,
            'nb_salaire' => $nb_salaire
        ]);
    }


    /**
     * Liste des salaires depuis la fiche Employeur
     */
    public function index_beneficiaire_employeur($beneficiaire_id="",$employeur_id="")
    {
        $user=User::where('id','=',Session::get('id'))->first();
        //$employeur = Employeur::find($employeur_id);
        $beneficiaire = Beneficiaire::find($beneficiaire_id);
        $salaires_obj = Salaire::where('benum','=',$beneficiaire_id);
        if($employeur_id) {
            $employeur = Employeur::find($employeur_id);
            $salaires = $salaires_obj->where('sonum','=',$employeur_id);
        }
        $salaires = $salaires_obj->orderBy("annee","DESC")->get();

        return View::make('recouvrement.salaires.index_beneficiaire_employeur', ['beneficiaire' => $beneficiaire,
            'employeur' => $employeur, 
            'salaires' => $salaires,
            'user'=>$user])
            ;
    }
 
     public function  index_iframe_secteur($sec_id,$date)
    {
        $user=User::where('id','=',Session::get('id'))->first();

        $secteur = Secteur::find($sec_id);
        $salaires=Salaire::whereIn('sonum',$secteur->getlisteEmployeurs($date))
            ->where('annee','=',substr($date,0,4))->get();

        return View::make('recouvrement.salaires.index_secteurs_iframe', 
            ['secteur' => $secteur,
            'date' => $date,
            'salaires' => $salaires,
            'user'=>$user])
            ;
    }


    /**
     * Show the form for creating a new user.
     *
     * @return Response
     */
    public function create($beneficiaire_id,$employeur_id)
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $liste_employeur = Employeur::orderBy('nom','ASC')->pluck('nom','id')->toArray();
        $beneficiaire = Beneficiaire::find($beneficiaire_id);
        $employeur = Employeur::find($employeur_id);
        return View::make('recouvrement.salaires.create', 
            ['employeur' => $employeur,
            'beneficiaire' => $beneficiaire,
            'user'=>$user
            ]);
    }
 

 
    /**
     * Store a newly created user in storage.
     *
     * @return Response
     */
    public function store(SalaireRequest $request)
    {
        $salaire_exist=salaire::where('annee','=',$request->annee)
            ->where('benum','=',$request->benum)
            ->where('sonum','=',$request->sonum)
            ->first();

        $t_error=array();
        if($salaire_exist) {
            $t_error['doublon']="Cette année de salaire existe déjà pour cet employé et cet employeur, vous ne pouvez pas la créer une nouvelle fois !";
        }

        if(intval($request->annee)>(intval(date('Y'))+10)) {
            $t_error['doublon']="Vous ne pouvez pas saisir les salaires d'une années supérieur à l'année en cours plus 10 ans.";
        }
        if (count($t_error)>0) {
            //Session::flash('nom_compte2', $plan2->nomcpt);
            return redirect()->back()
                ->withInput()
                ->withErrors($t_error);
        }

        $salaire = $this->setData($request);

        //Changement d'Employeur si besoin
        $employeur_id=$salaire->sonum;
        $beneficiaire=Beneficiaire::find($salaire->benum);
        $salaire_last=Salaire::where('benum','=',$salaire->benum)->orderby('annee','DESC')->first();
        if( ($salaire_last->annee==$salaire->annee) && ($salaire->sonum!=$beneficiaire->sonum) ) {
            $beneficiaire->sonum=$salaire->sonum;
            $beneficiaire->save();
        }

        return Redirect::to('recouvrement/salaire_annee/'.$request->sonum.'/'.$salaire->benum.'/'.$salaire->annee);
    }
 
    /**
     * Show the form for editing the specified user.
     *
     * @param  int  $id
     * @return Response
     */
    public function edit($id)
    {
        $salaire=Salaire::find($id);
        $user=User::where('id','=',Session::get('id'))->first();
        $liste_employeur = Employeur::orderBy('nom','ASC')->pluck('nom','id')->toArray();
        $beneficiaire=Beneficiaire::find($salaire->benum);
        $employeur = Employeur::find($salaire->sonum);

        return View::make('recouvrement.salaires.edit', 
            [
            'employeur' => $employeur,
            'salaire' => $salaire,
            'user'=>$user
            ]);
    }


    /**
     * Show the form for editing the specified user.
     *
     * @param  int  $id
     * @return Response
     */
    public function show($id)
    {
        $salaire = Salaire::find($id);
        return View::make('recouvrement.salaires.show', [ 'salaire'=> $salaire]);
    }
 
    /*
     * Update the specified user in storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function update($id,SalaireRequest $request)
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $salaire = $this->setData($request,$id);

        //Changement d'Employeur si besoin
        $employeur_id=$salaire->sonum;
        $beneficiaire=Beneficiaire::find($salaire->benum);
        $salaire_last=Salaire::where('benum','=',$salaire->benum)->orderby('annee','DESC')->first();
        if( ($salaire_last->id==$salaire->id) && ($salaire->sonum!=$beneficiaire->sonum) ) {
            $beneficiaire->sonum=$salaire->sonum;
            $beneficiaire->save();
        }

        return Redirect::to('recouvrement/salaire_annee/'.$request->sonum.'/0/'.$salaire->annee);

        //return Redirect::to('recouvrement/salaire_employe/'.$request->benum.'/'.$request->sonum);
    }
 

     public function setData($request,$id="")
    {
        $user=User::where('id','=',Session::get('id'))->first();

        $tmois=['jan','fev','mar','avr','mai','jun','jui','aou','sep','oct','nov','dec'];
        if($id) $salaire = Salaire::find($id);
        else $salaire = new Salaire;

        //Si modification on logs
        if($id) {
            $t_salaire_old=[];
            $t_cols=['benum','sonum','sonum','dat_ent','date_sor','annee','jan','fev','mar','avr','mai','jun','jui','aou','sep','oct','nov','dec'];
            foreach($t_cols as $col) $t_salaire_old[$col]=$salaire->{$col};
        }

        $salaire->benum = $request->benum;
        $salaire->sonum = $request->sonum;
        $date = $request->dat_ent;
        $salaire->dat_ent = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null  ;
        $date = $request->date_sor;
        $salaire->date_sor = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null  ;
        $salaire->annee = $request->annee;
        $suspendus="";$k=0;
        foreach($tmois as $mois) {
            $k++;
            $salaire->{$mois} = $request->{$mois};
            if($request->{$mois.'_vent'}<>0) $salaire->{$mois}+=$request->{$mois.'_vent'};
            //Suspendus
            if($request->{"box_".$mois}=="1") {
                $suspendus.=(($suspendus=="")?"":"|").$k;
                $salaire->{$mois}=null;
            }
        }
        $salaire->suspendus = $suspendus;
        $salaire->save();

        //LOG de la transaction
        $type_log=($id)?'I':'U';
        $salaire->log_transaction($request->url(),$type_log);

        //LOG Modifications
        if($id) {
            foreach($t_cols as $col) {
                if($t_salaire_old[$col]!=$salaire->{$col}) {
                    $log_salaire = new LogSalaire;
                    $log_salaire->id_salaire=$salaire->id;
                    $log_salaire->benum=$salaire->benum;
                    $log_salaire->sonum=$salaire->sonum;
                    $log_salaire->col=$col;
                    $log_salaire->val_old=$t_salaire_old[$col];
                    $log_salaire->val_new=$salaire->{$col};
                    $log_salaire->login=$user->login;
                    $log_salaire->ip=MyApp::getUserIP();
                    $log_salaire->save();
                }
            }
        }

        return $salaire;
    }



    /**
     * Remove the specified user from storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function destroy($id,$employeur_id='999999',$beneficiaire_id=0,$exercice="")
    {


        $salaire = Salaire::find($id);
        if(!$salaire) return Redirect::to('recouvrement/salaire_annee/'.$employeur_id.'/'.$beneficiaire_id.'/'.$exercice);

        $sonum = $salaire->sonum;
        $benum = $salaire->benum;
        Salaire::destroy($id);
 
        if(($employeur_id==0)||($employeur_id=='999999')) $sonum="999999";
        if($beneficiaire_id==0) $benum="0";

        return Redirect::to('recouvrement/salaire_annee/'.$sonum.'/'.$benum.'/'.$exercice);
        //return Redirect::to('recouvrement.salaires');
    }



    /**
     * Listes des employeurs
     */
    public function getListeEmployeur($avec_id=false)
    {
        $liste_employeur=Employeur::distinct()->select('nom','id')
            ->whereIn('statut',array('ACT','ASV'))
            ->orderBy(($avec_id)?'id':'nom')->pluck('nom','id')->toArray();
        $liste_employeur2=array();
        foreach($liste_employeur as $id=>$nom) {
            $id_pad=str_pad($id,4,"0", STR_PAD_LEFT);
            $nom=trim($nom);
            $liste_employeur2[$id]=htmlentities(str_replace('"','',$nom));
            if($avec_id) $liste_employeur2[$id]=$id_pad." ".$liste_employeur2[$id];
            else $liste_employeur2[$id]=$liste_employeur2[$id]." (".$id_pad.")";
        }
        asort($liste_employeur2);
        return $liste_employeur2;
    }


    /**
     * Listes des exercices
     */
    public function getListeExercices()
    {
        $exercices = Parametre::where('ref','=','TAUX_CLR_CCPF')->first()->Exercices; 

        return $exercices;
    }

    public function getListeExercicesBi()
    {
        $exercices = $this->getListeExercices();
        $nb_exercices=count($exercices );
        $k=0;$t=array();
        foreach($exercices as $exercice) {
            $k++;
            $exercice_min=intval($exercice)-1;
            $exercice_max=intval($exercice)+1;
            if($k%2==0) {
                $t[$exercice_min."-".$exercice]=$exercice_min." - ".$exercice;
                if($k<$nb_exercices) $t[$exercice."-".$exercice_max]=$exercice." - ".$exercice_max;
            }
        }
        arsort($t);
        $t['*']='Tous';
        return $t;
    }





}