<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\Models\Secteur;
use App\Models\Employeur;
use App\Models\User;
use App\Models\Parametre;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use App\Http\Requests\SecteurRequest;
use App\Http\Requests\AutoResponsableRequest;
use Request;
use Response;


class SecteursController extends Controller {
 
    /**
     * Display a listing of the user.
     *
     * @return Response
     */
    public function index($exercice="")
    {
        $user=User::where('id','=',Session::get('id'))->first();

        $exercices = ['*'=>'Tous']+$this->getListeExercices(); 
        if(($exercice=="")||($exercice=="0")) $exercice=date('Y');

        $secteurs = Secteur::all();
        return View::make('param.secteurs.index', ['secteurs' => $secteurs, 'user'=>$user]);
    }
 
    /**
     * Show the form for creating a new user.
     *
     * @return Response
     */
    public function create()
    {
        return View::make('param.secteurs.create', []);
    }
 
    /**
     * Store a newly created user in storage.
     *
     * @return Response
     */
    public function store(SecteurRequest $request)
    {
        $secteur = new Secteur;
        //$secteur->id = $request->id;
        $secteur->nom = $request->nom;
        $secteur->save();
        return Redirect::to('/param/secteurs');
    }
 
    /**
     * Show the form for editing the specified user.
     *
     * @param  int  $id
     * @return Response
     */
    public function edit($id)
    {
        $ile="";
        $secteur = Secteur::find($id);
        return View::make('param.secteurs.edit', [ 'secteur'=> $secteur]);
    }
 
    /*
     * Update the specified user in storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function update($id,SecteurRequest $request)
    {
        $secteur = Secteur::find($id);
        $secteur->nom = $request->nom;
        $secteur->save();

        return Redirect::to('/param/secteurs');
    }
 
    /**
     * Remove the specified user from storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function destroy($id)
    {
        $nb_employeur=Employeur::count("sec_id","=",$id);
        if($nb_employeur==0) Secteur::destroy($id);
 
        return Redirect::to('/param/secteurs');
    }




    /**
     * Listes des exercices
     */
    public function getListeExercices()
    {
        $exercices = Parametre::where('ref','=','TAUX_CLR_CCPF')->first()->Exercices; 
        return $exercices;
    }
}