<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\Models\Employeur;
use App\Models\Beneficiaire;
use App\Models\Enfant;
use App\Models\Beneftype;
use App\Models\Benefstatut;
use App\Models\Versement_b;
use App\Models\Parametre;
use App\Models\User;
use App\Models\Role2;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use App\Http\Requests\VersementRequest;
use App\Http\Requests\AutoResponsableRequest;
use Response;
use Illuminate\Http\Request;
use App\Http\Controllers\Logs;

class VersementsRAZController extends Controller {

    public function index($type,$nbraz="")
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $libelle_beneficiaire=" bénéficiaires ";
        $titre_versement="Remise à zéro des Rappels pour les ";
       
        if($type=="ALL") $benef_type="A";
        if($type=="RET") $benef_type="R";
        if($type=="SOC") $benef_type="S"; 

        $t_info=$user->getIconeTypeTab($benef_type); 
        $titre_versement.= $t_info["titre"];
        $libelle_beneficiaire= $t_info["libelle"];
        $icone=$t_info["icone"];


        //Mode <>"" si message de fin d'opération
        $versements_b=array();
        if($nbraz=="") {
            $versements_b=Versement_b::where('type','=',$type)->get();
        }
        return View::make('prestations.versements.raz', [ 
            'user'=>$user,
            'type'=>$type,
            'benef_type' => $benef_type,
            'titre_versement' => $titre_versement,
            'nbraz' => $nbraz,
            'versements_b' => $versements_b,
            'icone' => $icone,
            'libelle_beneficiaire' => $libelle_beneficiaire
        ]);
    }


    public function index_certificats_etrangers($type,$nb_modif="")
    {
        return $this->index_certificats($type,$nb_modif,true);
    }

    public function index_certificats($type,$nb_modif="",$etrangers=false)
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $libelle_beneficiaire=" bénéficiaires ";
        $titre_versement="Remise à zéro des Certificats pour les ";
        if($etrangers) $titre_versement="Remise à zéro des Certificats Etrangers pour les ";
        else $titre_versement="Remise à zéro des Certificats pour les ";
  
        if($type=="ALL") $benef_type="A";
        if($type=="RET") $benef_type="R";
        if($type=="SOC") $benef_type="S"; 

        $t_info=$user->getIconeTypeTab($benef_type); 
        $titre_versement.= $t_info["titre"];
        $libelle_beneficiaire.= $t_info["libelle"];
        $icone=$t_info["icone"];

        $filtre=Beneftype::where('ref','=',$benef_type)->value('statuts');       
        $t_filtre=explode(';',$filtre);
        //$nbraz= Beneficiaire::whereIn('statut', $t_filtre)
        //    ->where('rappel','<>',"0")->count();

        //Mode <>"" si message de fin d'opération
        return View::make('prestations.versements.maj_certificats', [ 
            'user'=>$user,
            'type'=>$type,
            'benef_type' => $benef_type,
            'titre_versement' => $titre_versement,
            'nb_modif' => $nb_modif,
            'icone' => $icone,
            'etrangers' => $etrangers,
            'libelle_beneficiaire' => $libelle_beneficiaire
        ]);
    }


   public function info_certificats($type,$etrangers=false)
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $libelle_beneficiaire=" bénéficiaires ";
        
        if($etrangers) $titre_versement="Certificats Etrangers à mettre à jour pour les bénéficiaires ";
        else $titre_versement="Certificats à mettre à jour pour les bénéficiaires ";

        if($type=="ALL") $benef_type="A";
        if($type=="RET") $benef_type="R";
        if($type=="SOC") $benef_type="S"; 

        $t_info=$user->getIconeTypeTab($benef_type); 
        $titre_versement.= $t_info["titre"];
        $libelle_beneficiaire.= $t_info["libelle"];
        $icone=$t_info["icone"];

        //Recherche des enfants
        $filtre=Beneftype::where('ref','=',$benef_type)->value('statuts');       
        $t_filtre=explode(';',$filtre);
        $beneficiaires = Beneficiaire::whereIn('statut', $t_filtre)
            ->get();

        $nb_change=0;$t_enfants=array();
        foreach($beneficiaires as $beneficiaire) {
            $enfants = Enfant::
                where('parents1','=',$beneficiaire->id)
                ->orwhere('parents2','=',$beneficiaire->id)
                ->get();
            foreach($enfants as $enfant) {
                //Si pas étrangers
                if(!$etrangers) {
                    foreach($enfants as $enfant) {
                        if( ($enfant->certif!=3)  ) {
                            $t_enfants[]=$enfant->id;
                            $nb_change++;
                        }
                    }
                } else {
                    foreach($enfants as $enfant) {
                        if( ($enfant->certif==3)  ) {
                            $t_enfants[]=$enfant->id;
                            $nb_change++;
                        }
                    }
                }
            }
        }

        $enfants = Enfant::whereIn("id",$t_enfants)
            ->orderby("nom")
            ->orderby("prenom")
            ->get();


        //Mode <>"" si message de fin d'opération
        return View::make('prestations.versements.info_certificats', [ 
            'user'=>$user,
            'type'=>$type,
            'benef_type' => $benef_type,
            'titre_versement' => $titre_versement,
            'enfants' => $enfants,
            'icone' => $icone,
            'etrangers' => $etrangers,
            'libelle_beneficiaire' => $libelle_beneficiaire
        ]);
    }



    public function raz_rappel($type)
    {
        $user=User::where('id','=',Session::get('id'))->first();

        if($type=="ALL") $benef_type="A";
        if($type=="RET") $benef_type="R";
        if($type=="SOC") $benef_type="S"; 

        $filtre=Beneftype::where('ref','=',$benef_type)->value('statuts');       
        $t_filtre=explode(';',$filtre);

        if($type=="RET") {
            $beneficiaires = Beneficiaire::whereIn('statut', $t_filtre)
                    ->where('ret_rappel','<>',"0")->get();
            //$tot= Beneficiaire::whereIn('statut', $t_filtre)
            //    ->where('ret_rappel','<>',"0")->count();
        } else {
            $beneficiaires = Beneficiaire::whereIn('statut', $t_filtre)
                ->where('rappel','<>',"0")->get();
            //$tot= Beneficiaire::whereIn('statut', $t_filtre)
            //    ->where('rappel','<>',"0")->count();
        }
        $nb=0;

        foreach($beneficiaires as $beneficiaire) {
            $ben=Beneficiaire::find($beneficiaire->id);
            if(($type=="ALL")||($type=="SOC")) {
                $old_ret_rappel=$ben->rappel;
                $ben->rappel = 0;
            }
            if($type=="RET") {
                $old_ret_rappel=$ben->ret_rappel;
                $ben->ret_rappel = 0;
            }

            $ben->save();
            //LOG de la transaction
            $log_txt="id=>".$ben->id.";ret_rappel_old=>".$old_ret_rappel.";ret_rappel=>0";
            $beneficiaire->log_transaction('','U',$log_txt);
            $nb++;
        }
        return Redirect::to('/raz_rappel/'.$type."/".$nb);
    }



    public function maj_certificats_etrangers($type)
    {
        return $this->maj_certificats($type,true);
    }

    public function maj_certificats($type,$etrangers=false)
    {
        $user=User::where('id','=',Session::get('id'))->first();

        if($type=="ALL") $benef_type="A";
        if($type=="RET") $benef_type="R";
        if($type=="SOC") $benef_type="S"; 

        //Recherche des enfants
        $filtre=Beneftype::where('ref','=',$benef_type)->value('statuts');       
        $t_filtre=explode(';',$filtre);
        $beneficiaires = Beneficiaire::whereIn('statut', $t_filtre)->get();
        $nb_change=0;
        foreach($beneficiaires as $beneficiaire) {
            $enfants = Enfant::
                where('parents1','=',$beneficiaire->id)
                ->orwhere('parents2','=',$beneficiaire->id)
                ->get();

            //Si pas étrangers
            if(!$etrangers) {
                foreach($enfants as $enfant) {
                    if( ($enfant->certif!=3) && ($enfant->NewCertificat<>$enfant->certif) ) {
                        $old_certif=$enfant->certif;
                        $enfant->certif=$enfant->NewCertificat;
                        $enfant->save();
                        //LOG de la transaction
                        $log_txt="id=>".$enfant->id.";enfant_certif_old=>".$old_certif.";enfant_certif=>".$enfant->certif;
                        $enfant->log_transaction('','U',$log_txt);
                        $nb_change++;
                    }
                }
            } else {
                foreach($enfants as $enfant) {
                    if( ($enfant->certif==3) && ($enfant->NewCertificat<>$enfant->certif) ) {
                        $old_certif=$enfant->certif;
                        $enfant->certif=$enfant->NewCertificat;
                        $enfant->save();
                        //LOG de la transaction
                        $log_txt="id=>".$enfant->id.";enfant_certif_old=>".$old_certif.";enfant_certif=>".$enfant->certif;
                        $enfant->log_transaction('','U',$log_txt);
                        $nb_change++;
                    }
                }
            }
        }

        if($etrangers) $url='/maj_certificats/'.$type."/".$nb_change;
        else $url='/maj_certificats_etrangers/'.$type."/".$nb_change;
        return Redirect::to($url);
    }

 
}