<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\Models\Employeur;
use App\Models\Beneficiaire;
use App\Models\Enfant;
use App\Models\Beneftype;
use App\Models\Benefstatut;
use App\Models\Versement_b;
use App\Models\Parametre;
use App\Models\User;
use App\Models\Role2;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use App\Http\Requests\VersementRequest;
use App\Http\Requests\AutoResponsableRequest;
use Response;
use Illuminate\Http\Request;
use App\Http\Controllers\Logs;

class VersementsSPECController extends Controller {

    public function calcul_soc_2018($type,$nbraz="")
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $libelle_beneficiaire=" bénéficiaires ";

        $benef_type="S"; 
        $filtre=Beneftype::where('ref','=',$benef_type)->value('statuts');       
        $t_filtre0=explode(';',$filtre);
        $t_filtre=array();
        foreach($t_filtre0 as $stat) if($stat!="") $t_filtre[]=$stat;



        $beneficiaires_obj = Beneficiaire::whereIn('statut', $t_filtre)
            ->where('statut','not like','%AU%');
        $beneficiaires=$beneficiaires_obj->orderBy('nom')->orderBy('prenom')->get();
        $nb_bene=count($beneficiaires);
        
        $t_benef=array('benum'=>'',
            'nb_enfants_avant_2018',
            'nb_enfants_2018',
            'mois_naiss_2018',
            'montant_anciencalcul'=>'',
            'rappel_2018'=>'',
            'total'=>''
            );
        foreach($beneficiaires as $beneficiaire) {
            $montant_c=0;
            $montant_r=0;
            $ret_type="";
            $ret_date="";
            $ret_num="";
            $verif_ok=true;


                $nb_enfant=$beneficiaire->NbEnfantsSoc;
                if($nb_enfant==0) $verif_ok=false;
                
                //Calcul sur tableau 2018 si présent dans parame^tres
                $montant_soc_2018=Parametre::where('ref','=','CAL_MONTANT_SOC_2018')->first()->value;
                if(isset($montant_soc_2018) && $montant_soc_2018!="") {
                    $t_montant_soc_2018=explode(";",$montant_soc_2018);
                    //Préparation dutableau de calcul
                    //Dans la BDD sous la forme 1;5000 2;6000 3;8000 4;10000 5;12000 6;15000 7;18000
                    $indemnite_nbenfant=0;
                    $indemnite_montant=0;
                    $t=array();
                    for($i=1;$i<=20;$i++) { //Nb enfant max 20
                        if(isset($t_montant_soc_2018[$i-1])&&($t_montant_soc_2018[$i-1]!="")) {
                            $t_indemnite=$t_montant_soc_2018[$i-1];
                            $indemnite=explode("=",$t_indemnite);
                            $indemnite_nbenfant=$indemnite[0];
                            $indemnite_montant=$indemnite[1];
                        }
                        $t[$i]=$indemnite_montant;
                    }
                    $t_montant_soc_2018=$t;
                    for($i=1;$i<=$nb_enfant;$i++) { 
                        $indemnite_montant=$t_montant_soc_2018[$i];
                        $montant_c+=$indemnite_montant;
                    }


                $obs_vers=$beneficiaire->obs_vers;
                $montant_r=$beneficiaire->rappel;
            }

            if($verif_ok) {

                $t_benef[
                'benum'=>$beneficiaire->id,
                'nom'=>$beneficiaire->NomComplet,
                'nb_enfants_avant_2018'=>0,
                'nb_enfants_2018'=>0,
                'mois_naiss_2018'=>0,
                'montant_anciencalcul'=>0,
                'rappel_2018'=>0,
                'total'=>0][]
            }
        }

        return View::make('prestations.versements.index_beneficiaire_spec_2018', [ 
            'user'=>$user,
            't_benef'=>$t_benef,
        ]);

    }

}