<?php namespace App\Http\Requests;
 
use Illuminate\Foundation\Http\FormRequest;
 
class BanqueRequest extends FormRequest {
    public function rules() {
        return [
            'nom' => 'required|max:50',
            'adresse' => '',
            'cp' => 'max:5',
            'ville' => 'max:50', 
            'tel' => 'max:20',
            'tel2' => 'max:20',
            'fax' => 'max:20',
            'email' => 'max:255',
            'contact' => 'required|max:255',
            'agence' => 'max:5',
            'bic' => 'max:11',
            'active' => '',
        ];
    }
 

    public function attributes() {
        return [
            'nom' => 'Nom',
            'adresse' => 'Adresse',
            'cp' => 'Code Postal',
            'ville' => 'Ville', 
            'tel' => 'Télépphone1',
            'tel2' => 'Télépphone2',
            'fax' => 'Fax',
            'email' => 'Email',
            'contact' => 'Contact',
            'contact2' => 'Contact2',
            'agence' => 'Agence',
            'bic' => 'Code BIC',
            'active' => 'Active',
        ];
    }


    public function authorize() {
        return true;
    }
}












