<?php namespace App\Http\Requests;
 
use Illuminate\Foundation\Http\FormRequest;
 
class JournalRequest extends FormRequest {
    public function rules() {
        return [
            'date' => 'required',
            'numcpt' => 'required|max:6|min:6',
            'ref' => 'required',
            'libelle' => 'required',
            'debit' => '',
            'credit' => '',
            'enc' => '',
            'budget' => '',
            'amortissement' => ''
        ];
    }


     public function attributes() {
        return [
            'date' => 'Date',
            'numcpt' => 'Numéro de compte',
            'ref' => 'Référence',
            'libelle' => 'Libellé',
            'debit' => 'Débit',
            'credit' => 'Crédit',
            'enc' => 'ENC',
            'amortissement' => 'Amortissement',
            'budget' => 'Budget', 
        ];
    }


    public function authorize() {
        return true;
    }
}












