<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use Zizaco\Entrust\Traits\EntrustUserTrait;
use App\Http\Controllers\Logs;

class Beneficiaire extends Model {
	
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'beneficiaires';



  public function enfants()
    {
        return $this->hasMany('Enfant','parents1','benjum');
    }

    public function enfants_conjoint()
    {
        return $this->hasMany('Enfant','parents2','benjum');
    }


    /* Dates */
    public function getDates()
    {
            return array('date_naiss','ret_dateed','date_pi');
    }


     public function getDateNaissAttribute($value)
    {
        return (($this->attributes['datenaiss']!="0000-00-00")&&($this->attributes['datenaiss']!=null))?date('d/m/Y', strtotime($this->attributes['datenaiss'])):"";
    }

     public function getDateDecesAttribute($value)
    {
        return (($this->attributes['date_deces']!="0000-00-00")&&($this->attributes['date_deces']!=null))?date('d/m/Y', strtotime($this->attributes['date_deces'])):"";
    }

     public function getRetDateedAttribute($value)
    {
        return (($this->attributes['ret_dateed']!="0000-00-00")&&($this->attributes['ret_dateed']!=null))?date('d/m/Y', strtotime($this->attributes['ret_dateed'])):"";
    }
     public function getDatePiAttribute($value)
    {
        return (($this->attributes['date_pi']!="0000-00-00")&&($this->attributes['date_pi']!=null))?date('d/m/Y', strtotime($this->attributes['date_pi'])):"";
    }

        /* Nom */
    public function getNomCompletAttribute()
    {
            return $this->nom." ".$this->prenom;
    }


    public function getNomReduitAttribute()
    {
        $taillemax=20;

        $nom=trim($this->nom);
        if(strlen($nom)>$taillemax) $nom=substr($nom,0,$taillemax);
        return trim($nom);
    }

    public function getNomCompletReduitAttribute()
    {
        $taillemax=20;
        $t_prenom=explode(' ',$this->prenom);

        $prenom=trim($t_prenom[0]);
        if(strlen($prenom)>$taillemax) $prenom=substr($prenom,0,$taillemax);
        return trim($this->nom)." ".$prenom;
    }

    /***********/
    /* BANQUES */
    /***********/
    public function getLastCompte()
    {
        $bénéficiaire_banque=BeneficiaireBanque::where("id_benef","=",$this->id)
          ->where("actif","=","1")->orderby("id","DESC")->first();
          if(!$bénéficiaire_banque) return "";
          return $bénéficiaire_banque;
    }
    public function getIBANcompletAttribute()
    {
        $bénéficiaire_banque=$this->getLastCompte();
        if($bénéficiaire_banque=="") return ""; 
        $IBAN_pays=($bénéficiaire_banque->IBAN_pays)?$bénéficiaire_banque->IBAN_pays:"";
        $IBAN_cle=($bénéficiaire_banque->IBAN_cle)?$bénéficiaire_banque->IBAN_cle:"";
        
        return $IBAN_pays.$IBAN_cle.$bénéficiaire_banque->RIBcomplet;
    }

    public function getRIBcompletAttribute()
    {
        $bénéficiaire_banque=$this->getLastCompte();
        if($bénéficiaire_banque=="") return ""; 
        $IBAN_banque=($bénéficiaire_banque->IBAN_banque)?$bénéficiaire_banque->IBAN_banque:"";
        $IBAN_guichet=($bénéficiaire_banque->IBAN_guichet)?$bénéficiaire_banque->IBAN_guichet:"";
        $IBAN_compte=($bénéficiaire_banque->IBAN_compte)?$bénéficiaire_banque->IBAN_compte:"";
        $IBAN_clerib=($bénéficiaire_banque->IBAN_clerib)?$bénéficiaire_banque->IBAN_clerib:"";
        return $IBAN_banque.$IBAN_guichet.$IBAN_compte.$IBAN_clerib;
    }

    public function getIBAN_paysAttribute()
    {
        $bénéficiaire_banque=$this->getLastCompte();
        if($bénéficiaire_banque=="") return ""; 
        return $IBAN_pays;
    }

    public function getNomBanqueAttribute($ref)
    {
        $bénéficiaire_banque=$this->getLastCompte();
        if($bénéficiaire_banque=="") return ""; 
        $banque=Banque::find($bénéficiaire_banque->banque_id);
        if(!$banque) return "";
        return $banque->nom;
    }


    public function getBanqueIdAttribute($ref)
    {
        $bénéficiaire_banque=$this->getLastCompte();
        if($bénéficiaire_banque=="") return ""; 
        if(!$bénéficiaire_banque) return "";
        return $bénéficiaire_banque->banque_id;
    }


    /***********/



        /* Nom */
    public function getCiviliteLibelleAttribute()
    {
            if($this->civilite=="Mll") return "Madame";
            if($this->civilite=="Mme") return "Madame";
            if($this->civilite=="Mr") return "Monsieur";
            return "";
    }


        /* Conjoint */
    public function getNomConjointAttribute()
    {
        $nom_conjoint="";
        $conjoint  = DB::table('beneficiaires')->where('id', '=', $this->conjoint)->first();
        if($conjoint) $nom_conjoint =trim($conjoint->nom)." ".trim($conjoint->prenom);
        return $nom_conjoint;
    }



    
	/**
     * Get the user's full name by concatenating the first and last names
     *
     * @return string
     */
    public function getEmployeurAttribute()
    {
    	$nom_employeur="";
    	if($this->sonum<>0) $nom_employeur=DB::table('employeurs')->where('id', '=', $this->sonum)->value('nom');
        return $nom_employeur;
    }

    /**
     * Get the user's full name by concatenating the first and last names
     *
     * @return string
     */
    public function getEmployeurCourtAttribute()
    {
        $nom_employeur="";
        $max=25;
        if($this->sonum<>0) $nom_employeur=DB::table('employeurs')->where('id', '=', $this->sonum)->value('nom');
        if(strlen($nom_employeur)>$max) $nom_employeur=substr($nom_employeur,0,$max)."...";
        return $nom_employeur;
    }

    /**
     * Nombre d'enfants
     * @return int
     */
    public function getNbEnfantsAttribute()
    {
        $nb=DB::table('enfants')->where('parents1', '=', $this->id)
        ->orwhere('parents2', '=', $this->id)
        ->count();
        return $nb;
    }

    /**
     * Nombre d'enfants à une date donnée
     */
    public function getNbEnfants($date)
    {
        $nb=0;

        $res=DB::select(DB::raw("SELECT count(*) as nb FROM enfants WHERE datenais < '".$date."' AND (parents1='".$this->id."' OR parents2='".$this->id."')"));
        if($res) $nb=$res[0]->nb;

        return $nb;
    }

        /* Conjoint */
    public function getAgeAttribute()
    {
        $date=$this->attributes['datenaiss'];
        $age= (int) ((time() - strtotime($date)) / 3600 / 24 / 365);

        return $age;
    }

    /**
     * Nombre d'enfants responsable
     */
    public function getNbEnfantsResponsableAttribute()
    {
        $nb=DB::table('enfants')->where('parents1', '=', $this->id)
        ->count();
        return $nb;
    }

    /**
     * Nombre d'enfants pour allocations
     */
    public function getNbEnfantsAllocAttribute()
    {
        $nb=DB::table('enfants')
        ->where('parents1', '=', $this->id)
        ->whereIn('certif',array('1','2','3','4'))
        ->count();
        return $nb;
    }


    /**
     * Nombre d'enfants pour Aide Sociale
     */
    public function getNbEnfantsSocAttribute()
    {
        $nb=DB::table('enfants')
        ->where('parents1', '=', $this->id)
        ->whereIn('certif',array('1','2','3','4'))
        ->count();
        return $nb;
    }

    /**
     * Nombre de salaires
     * @return int
     */
    public function getNbSalairesAttribute()
    {
        $nb=DB::table('salaire')->where('benum', '=', $this->id)->count();
        return $nb;
    }

    /**
     * Salaire moyen sur une année
     * @return int
     */
    public function getSalaireMoyen($annee)
    {
        $salaires=DB::table('salaire')
          ->where('benum', '=', $this->id)
          ->where('annee', '=', $annee)
          ->get();

        $t_mois=[1=>"jan",2=>"fev",3=>"mar",4=>"avr",5=>"mai",
            6=>"jun",7=>"jui",8=>"aou",9=>"sep",10=>"oct",11=>"nov",12=>"dec"];
        $total=0;$nbmois=0;
        if(!$salaires) return 0;

        foreach($salaires as $salaire) {
          foreach($t_mois as $mois) {
            if($salaire->{$mois}>0) {
              $total+=$salaire->{$mois};
              $nbmois++;
            }
          }
        }
        $moyenne_an=0;
        if($nbmois>0) $moyenne_an=round($total/$nbmois,0);
        return $moyenne_an;
    }

    /**
     * Salaire moyen sur une année
     * @return int
     */
    public function getMasseSalariale($annee)
    {
        $total_salaires=DB::table('salaire as s')
          ->select(DB::raw('(SUM(
            s.jan+s.fev+s.mar+s.avr+s.mai+s.jun+s.jui+s.aou+s.sep+s.oct+s.nov+s.dec
          )) as total'))
          ->where('benum', '=', $this->id)
          ->where('annee', '=', $annee)
          ->value('total');

        if($total_salaires>0) return round($total_salaires,0);
        return 0;
    }



  /**
   * Secteur du Dernier employeur
   * @return int
   */
  public function getSecteurLastSalaire($annee)
  {
    //recherche du dernier salaire
    $last_salaire=DB::table('salaire')
      //->where('annee', '=', $annee)
      ->where('benum', '=', $this->id)
      ->orderby('annee','DESC')
      ->first();

    if(isset($last_salaire)) {
      $employeur=Employeur::where('id', '=', $last_salaire->sonum)->first();
       if(isset($employeur))  return $employeur->Secteur;
    }
    return "";
  }


  /**
   * Nombre de salaires
   * @return int
   */
  public function getSalaireDateEntreeAttribute()
  {
     /* $salaire=Salaire::where('benum', '=', $this->id)
        ->where('sonum', '=', $this->sonum)
        ->where('dat_ent','<>','0000-00-00')
        ->orderby('dat_ent','ASC')->first();
*/
      $salaire=Salaire::where('benum', '=', $this->id)
        ->where('sonum', '=', $this->sonum)
        ->whereNotNull('dat_ent')
        ->orderby('dat_ent','ASC')->first();

      if(!$salaire) return "";
      return $salaire->dat_ent;
  }


  /**
   * Premier salaire
   * @return int
   */
  public function getDatePremierSalaireAttribute($format="")
  {
    $salaire=Salaire::where('benum', '=', $this->id)
      ->where(DB::raw("jan+fev+mar+avr+mai+jun+jui+aou+sep+oct+nov+salaire.dec"),">","0")
      ->orderby('annee','ASC')->first();

    if(!$salaire) return "";
    if($format=="US") return $salaire->annee."-".$salaire->FirstMoisSalaire."-01";
    return "01/".$salaire->FirstMoisSalaire."/".$salaire->annee;
  }


  /**
   * Premier immat/salaire
   * @return int
   */
  public function getDatePremierSalaireImmatAttribute($format="")
  {
    $premier_salaire=$this->getDatePremierSalaireAttribute("US");
    $date_pi=$this->attributes['date_pi'];

    if(($premier_salaire<$date_pi)||($date_pi=="0000-00-00"))  {
      return ($format=="")?$premier_salaire:$this->getDatePremierSalaireAttribute();
    }
    return ($format=="")?$date_pi:$this->date_pi;
  }


  /**
   * Nombre de mois de salaire
   * @return int
   */
  public function getNbMoisSalairesAttribute($format="",$annee_obs="")
  {
    $t_mois=[0=>"jan",1=>"fev",2=>"mar",3=>"avr",4=>"mai",
        5=>"jun",6=>"jui",7=>"aou",8=>"sep",9=>"oct",10=>"nov",11=>"dec"];

    $nb=0;
    $salaires=DB::table('salaire')
      ->select(DB::raw('benum,annee,SUM(jan) as jan,SUM(fev) as fev,SUM(mar) as mar,SUM(avr) as avr,SUM(mai) as mai,SUM(jun) as jun,SUM(jui) as jui,SUM(aou) as aou,SUM(sep) as sep,SUM(oct) as oct,SUM(nov) as nov,SUM(salaire.dec) as "dec"'))
      ->where('benum','=',$this->id)
      ->groupby('benum','annee')
      ->get();

    foreach($salaires as $salaire) {
        for($i=0;$i<12;$i++) { 
          if($salaire->{$t_mois[$i]}) $nb++;
        }
    }

    return $nb;
  }


  public function getOPTI_InfoSalairesAttribute($annee_obs="")
  {
      if($annee_obs=="") $annee_obs=date('Y');
      $max_sal=180;
      $t_mois=[0=>"jan",1=>"fev",2=>"mar",3=>"avr",4=>"mai",
          5=>"jun",6=>"jui",7=>"aou",8=>"sep",9=>"oct",10=>"nov",11=>"dec"];

      $nb=0;$masse=0;$t_mois_salaire=array();
      $salaires=DB::table('salaire')
        ->select(DB::raw('benum,annee,SUM(jan) as jan,SUM(fev) as fev,SUM(mar) as mar,SUM(avr) as avr,SUM(mai) as mai,SUM(jun) as jun,SUM(jui) as jui,SUM(aou) as aou,SUM(sep) as sep,SUM(oct) as oct,SUM(nov) as nov,SUM(salaire.dec) as "dec"'))
        ->where('benum','=',$this->id)
        ->where('annee','<=',$annee_obs)
        ->groupby('benum','annee')
        ->get();

      foreach($salaires as $salaire) {
        for($i=0;$i<12;$i++) { 
          $s=$salaire->{$t_mois[$i]};
          if($s>0) {
            $nb++;
            if($salaire->annee<=$annee_obs) { 
              if(intVal($salaire->annee)==intVal($annee_obs)) $masse+=$s;
              $num_mois=str_pad(($i+1),2,'0',STR_PAD_LEFT);
              $t_mois_salaire[$salaire->annee."-".$num_mois]=
                str_pad($s,7,"0",STR_PAD_LEFT);

            }
          }
        }
      }

      arsort($t_mois_salaire);
      $k=1;$total=0;

      foreach($t_mois_salaire as $id_mois => $value) {  
        if($k>$max_sal) break;
        $total+=intVal($value);

        $k++;
      }

      $salaire_moyen=round($total/$max_sal,0);
      return $nb."~".$masse."~".$salaire_moyen;
  }



  /* FIN 260321 
  public function getSelectMeilleursSalaires($annee_obs="")
  {
      $t_salaires=array();
      $k=0;
      $t_mois=[0=>"jan",1=>"fev",2=>"mar",3=>"avr",4=>"mai",
          5=>"jun",6=>"jui",7=>"aou",8=>"sep",9=>"oct",10=>"nov",11=>"dec"];


      if($annee_obs!="") {
        $salaires=Salaire_cumules::where('benum', '=', $this->id)->where('annee','<=',$annee_obs)->orderby('annee')->get();
      }
      else {
        $salaires=Salaire_cumules::where('benum', '=', $this->id)->orderby('annee')->get();
      }

      foreach($salaires as $salaire) {
        for($i=0;$i<12;$i++) {
          $montant=$salaire->{$t_mois[$i]};
          if($montant>0) {
            $num_mois=str_pad(($i+1),2,'0',STR_PAD_LEFT);
            $t_salaires[$salaire->annee."-".$num_mois]=
              str_pad($montant,7,"0",STR_PAD_LEFT)
              ."-".$salaire->annee
              ."-".$num_mois;
          }
        }
      }
      
      arsort($t_salaires);
      return $t_salaires;
  }
  */


  /**
   * Liste des meilleurs salaires en t[mois]=valeur;
   * @return int
   */
  public function getSelectMeilleursSalaires($annee_obs="")
  {
     
    if($annee_obs=="") $annee_obs=date('Y');
    $t_mois=[0=>"jan",1=>"fev",2=>"mar",3=>"avr",4=>"mai",
        5=>"jun",6=>"jui",7=>"aou",8=>"sep",9=>"oct",10=>"nov",11=>"dec"];

    $t_mois_salaire=array();
    $salaires=DB::table('salaire')
      ->select(DB::raw('benum,annee,SUM(jan) as jan,SUM(fev) as fev,SUM(mar) as mar,SUM(avr) as avr,SUM(mai) as mai,SUM(jun) as jun,SUM(jui) as jui,SUM(aou) as aou,SUM(sep) as sep,SUM(oct) as oct,SUM(nov) as nov,SUM(salaire.dec) as "dec"'))
      ->where('benum','=',$this->id)
      ->where('annee','<=',$annee_obs)
      ->groupby('benum','annee')
      ->get();

    foreach($salaires as $salaire) {
        for($i=0;$i<12;$i++) { 
          $s=$salaire->{$t_mois[$i]};
          if($s>0) {
            if($salaire->annee<=$annee_obs) { 
              $num_mois=str_pad(($i+1),2,'0',STR_PAD_LEFT);
              $t_mois_salaire[$salaire->annee."-".$num_mois]=
                str_pad($s,7,"0",STR_PAD_LEFT);
            }
          }
        }
    }

    arsort($t_mois_salaire);
    return $t_mois_salaire;
  }


  /**
   * Liste des meilleurs salaires en t[]=id.'~'.mois;
   * @return int
   */
  public function getRefMeilleursSalaires($n=9999,$annee_obs="")
  {
      $t_mois=[1=>"jan",2=>"fev",3=>"mar",4=>"avr",5=>"mai",
          6=>"jun",7=>"jui",8=>"aou",9=>"sep",10=>"oct",11=>"nov",12=>"dec"];

      $t_id_salaires=array();$k=1;
      $t_salaires=array();
      $salaires=$this->getSelectMeilleursSalaires($annee_obs);

      foreach($salaires as $id_mois => $value) {
        $t_salaires[$id_mois]=$value;
        $k++;
        if($k>$n) break;
      }

      return $t_salaires;
  }

  /**
   * Liste des meilleurs salaires en t[]=id.'~'.mois;
   * @return int
   */
  // ATTENTION :OBsolète
  /*
  public function getIdMeilleursSalaires($n=9999,$annee_obs="")
  {
      $t_mois=[1=>"jan",2=>"fev",3=>"mar",4=>"avr",5=>"mai",
          6=>"jun",7=>"jui",8=>"aou",9=>"sep",10=>"oct",11=>"nov",12=>"dec"];

      $t_id_salaires=array();$k=1;
      $salaires=$this->getSelectMeilleursSalaires($annee_obs);
      foreach($salaires as $id_mois => $value) {
        $t_id_mois=explode('-',$id_mois);
        $t_value=explode('-',$value);
        $id=$t_id_mois[0];
        $mois=$t_id_mois[1];
        $montant=intval($t_value[0]);
        $annee=$t_value[1];
        $mois=$t_value[2];
        $t_id_salaires[$id."-".$t_mois[intval($mois)]]=$montant;
        $k++;
        if($k>$n) break;
      }

      return $t_id_salaires;
  }
  */


  /**
   * Meilleurs salaires
   * @return int
   */
  public function getMeilleursSalairesAttribute($annee_obs="")
  {
      $t_salaires=array();

      $salaires=$this->getSelectMeilleursSalaires($annee_obs);
      foreach($salaires as $id_mois => $value) {
        $t_id_mois=explode('-',$id_mois);
        $t_value=explode('-',$value);
        $id=$t_id_mois[0];
        $mois=$t_id_mois[1];
        $montant=intval($t_value[0]);
        $annee=$t_value[1];
        $mois=$t_value[2];
        $t_salaires[]=$montant;
      }

      return $t_salaires;
  }

  public function getMoyenneMeilleursSalairesAttribute($annee_obs="")
  {
      //$nb_meilleurs=180;
      $nb_meilleurs=Parametre::where('ref','=','CAL_PRET_NBMOIS')->first()->value;
      $taux_1=Parametre::where('ref','=','CAL_PRC_RET1')->first()->value;
      $taux_2=Parametre::where('ref','=','CAL_PRC_RET2')->first()->value;
      $plafond=Parametre::where('ref','=','CAL_PFD_RET')->first()->value;
      $montant=0;$nb=0;$nbtot=0;
      $pension=0;$pension_masse=0;

      //$t_salaires=$this->getMeilleursSalairesAttribute($annee_obs);

      $salaires=$this->getSelectMeilleursSalaires($annee_obs);
      foreach($salaires as $id_mois => $value) {
        $t_value=explode('-',$value);
        $salaire=intval($t_value[0]);
        if($salaire>0) {
          $nbtot++;
          if($nb<$nb_meilleurs) {$montant+=$salaire;$nb++;}
          //else {$nb--;break;}
        }
      }

      if($nb>=$nb_meilleurs) $moyenne=round($montant/$nb_meilleurs,0);
      else {
        if($nb>0) $moyenne=round($montant/$nb,0);
        else $moyenne=0;
      }

      $ret_calc=($moyenne*$taux_1/100*$nb_meilleurs/12);
      if($nb_meilleurs<$nbtot) $ret_calc+=($moyenne*$taux_2/100*($nbtot-$nb_meilleurs)/12);     
      $ret_plafonnee=$moyenne*$plafond;
      $ret_calc=($ret_calc>$ret_plafonnee)?$ret_plafonnee:$ret_calc;
      $ret_calc=round($ret_calc,0);


      return $moyenne."~".$nb."~".$montant."~".$pension."~".$nbtot."~".$ret_calc;
  }

  public function getSalaireMoyenMeilleursAnneesAttribute($annee_obs="")
  {
      if($annee_obs=="") $salaire_moyen=$this->getMoyenneMeilleursSalairesAttribute();
      else $salaire_moyen=$this->getMoyenneMeilleursSalairesAttribute($annee_obs);

      return $salaire_moyen;
  }



  /**
   * Nombre de versements
   * @return int
   */
  public function getNbVersemAttribute()
  {
      $nb=DB::table('versem')->where('benum', '=', $this->id)->count();
      return $nb;
  }


  /**
   * Nombre de controles benef
   * @return int
   */
  /*
  public function getNbControleAttribute()
  {
      $nb=DB::table('controle_benef')->where('benum', '=', $this->id)->count();
      return $nb;
  }
  */

  /**
   * Get the user's full name by concatenating the first and last names
   *
   * @return string
   */
  public function getHasCascadeAttribute()
  {
      if($this->sonum>0) return false;
      if($this->nb_enfants>0) return false;
      if($this->nb_versem>0) return false;
      if($this->nb_salaires>0) return false;
      if($this->nb_controle>0) return false;
      return true;
  }



  public function getBenefTypeAttribute()
  {
    $statut=$this->statut;
    $type="";
    $benef_type=DB::table('benef_types')
      ->where('statuts', 'like',';'.$statut.'%')
      ->orwhere('statuts', '=',';'.$statut)
      ->first();
    if(isset($benef_type)) $type=$benef_type->ref;
    return $type;
  }


  //LOG
  public function log_transaction($url,$operation,$values="") {
    $log=new Logs;
    if($values=="") {
      $t_values=$this->getAttributes();
      foreach($t_values as $nom=>$value) $values.=(($values=="")?"":";").$nom."=>".$value; 
    } 

    $log->addlog(['url'=>$url,'table'=>$this->table ,'operation'=>$operation,'values'=>$values]);
  }


  /**
   * ayantdroit (salaires sur période en cours)
   * @return int
   */
  public function getAyantDroitAttribute()
  {

    $t_mois=[1=>"jan",2=>"fev",3=>"mar",4=>"avr",5=>"mai",
    6=>"jun",7=>"jui",8=>"aou",9=>"sep",10=>"oct",11=>"nov",12=>"dec"];
    $totat_salaires=0;
    $annee=date('Y');

    //recherche du dernier salaire
    $last_salaire=DB::table('salaire')->where('benum', '=', $this->id)
    ->orderby('annee','DESC')->first();

    //Si pas de salaire
    if(!$last_salaire) return false;
    //Si plus de 2 ans faux
    if(($annee-2)>$last_salaire->annee) return false; 
    //Si plus de 1 ans et mois en cours >3 faux
    if((($annee-1)>=$last_salaire->annee) 
      && ($last_salaire->dec+$last_salaire->nov+$last_salaire->oct==0)) return false; 

    //regarde si salaire les 3 derniers mois
    $nummois=intval(date('m'));
    $mois=$t_mois[$nummois];

    //Si premiers mois de l'année on regarde année précédente
    if($nummois<=3) {
      //salaires année en cours
      $totat_salaires=$last_salaire->{$mois};
      if(($totat_salaires==0)&&($nummois-1>0)) $totat_salaires=$last_salaire->{$t_mois[$nummois-1]};
      if(($totat_salaires==0)&&($nummois-2>0)) $totat_salaires=$last_salaire->{$t_mois[$nummois-2]};
      if($totat_salaires>0) return true;
      //Année précédente
      $last_salaire=DB::table('salaire')
        ->where('benum', '=', $this->id)->where('annee', '=', $annee-1)
        ->orderby('annee','DESC')->first();  
      //Si pas de salaire en n-1 
      if(!$last_salaire) return false;
      //Si salaire sur les 3 derniers mois true
      if($last_salaire->dec+$last_salaire->nov+$last_salaire->oct>0) return true; 

    } else {
      //salaires année en cours
      $totat_salaires=$last_salaire->{$mois};
      if(($totat_salaires==0)&&($nummois-1>0)) $totat_salaires=$last_salaire->{$t_mois[$nummois-1]};
      if(($totat_salaires==0)&&($nummois-2>0)) $totat_salaires=$last_salaire->{$t_mois[$nummois-2]};
      if($totat_salaires>0) return true;
    }
    return false;
  }


}
