<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use Zizaco\Entrust\Traits\EntrustUserTrait;
use App\Http\Controllers\Logs;

class BeneficiaireBanque extends Model {
	
	protected $table = 'beneficiaires_banques';


    public function getNomCompletBeneficiaireAttribute()
    {
        $beneficiaire=Beneficiaire::find($this->id_benef);
        if(!$beneficiaire) return "";
        return $beneficiaire->NomComplet;
    }


    public function getNomBanqueAttribute($ref)
    {
        $banque=Banque::find($this->banque_id);
        if(!$banque) return "";
        return $banque->nom;
    }

    public function getRIBcompletAttribute()
    {
        $IBAN_banque=($this->IBAN_banque)?$this->IBAN_banque:"";
        $IBAN_guichet=($this->IBAN_guichet)?$this->IBAN_guichet:"";
        $IBAN_compte=($this->IBAN_compte)?$this->IBAN_compte:"";
        $IBAN_clerib=($this->IBAN_clerib)?$this->IBAN_clerib:"";
        return $IBAN_banque.$IBAN_guichet.$IBAN_compte.$IBAN_clerib;
    }



    public function getlibelleInfomodifAttribute()
    {
        $modif=$this->infomodif ;

        $t_compte_champs=["banque_id","IBAN_pays","IBAN_cle","IBAN_banque","IBAN_guichet","IBAN_compte","IBAN_clerib"];

        if(($modif=="00") || ($modif=="")) return "CREATION";
        if($modif=="7F") return "TOTALE";
        if($modif=="3F") return "IBAN COMPLET";

        $modif_bin=decbin(hexdec ($modif));
        $modif_bin=str_pad($modif_bin,8,"0",STR_PAD_LEFT);
        $msg="";
        $sep="<br/>";
        if(substr($modif_bin,0,1)=="1") $msg.=(($msg=="")?"":$sep)."BANQUE";
        if(substr($modif_bin,1,1)=="1") $msg.=(($msg=="")?"":$sep)."IBAN PAYS";
        if(substr($modif_bin,2,1)=="1") $msg.=(($msg=="")?"":$sep)."IBAN CLE";
        if(substr($modif_bin,3,1)=="1") $msg.=(($msg=="")?"":$sep)."IBAN BANQUE";
        if(substr($modif_bin,4,1)=="1") $msg.=(($msg=="")?"":$sep)."IBAN GUICHET";
        if(substr($modif_bin,5,1)=="1") $msg.=(($msg=="")?"":$sep)."IBAN COMPTE";
        if(substr($modif_bin,6,1)=="1") $msg.=(($msg=="")?"":$sep)."IBAN CLERIB";
        
        return $msg;
    }

/*
    public function getNbVersementsAttribute()
    {
      if(trim($this->RIBcomplet)=="") return 0;
      $nb=DB::table('versem')->where('compte', '=', $this->RIBcomplet)->count();
      return $nb;
    }

    public function getTotalVersementsAttribute()
    {
      if(trim($this->RIBcomplet)=="") return 0;
      $total=DB::table('versem')->where('compte', '=', $this->RIBcomplet)->SUM('montant');
      return $total;
    }
*/

  //LOG
  public function log_transaction($url,$operation,$values="") {
    $log=new Logs;
    if($values=="") {
      $t_values=$this->getAttributes();
      foreach($t_values as $nom=>$value) $values.=(($values=="")?"":";").$nom."=>".$value; 
    } 

    $log->addlog(['url'=>$url,'table'=>$this->table ,'operation'=>$operation,'values'=>$values]);
  }
  
}
