<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Controle extends Model {
	
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'controle';


    /* Dates */
    public function getDates()
    {
            return array('date_cont','date_valid');
    }


    public function getDateContAttribute($value)
    {
        return ($this->attributes['date_cont']!="0000-00-00")?date('d/m/Y', strtotime($this->attributes['date_cont'])):"";
    }

     public function getDateValidAttribute($value)
    {
        return ($this->attributes['date_valid']!="0000-00-00")?date('d/m/Y', strtotime($this->attributes['date_valid'])):"";
    }

     public function getNomEmployeurAttribute($value)
    {
        $employeur=Employeur::find($this->sonum);

        return $employeur->nom;
    }


     public function getPJAttribute($value)
    {
        $res="";

        $uploads=Upload::where('ref_id','=',$this->id)
            ->where('module','=','CTRL')->get();

        foreach($uploads as $upload) {
            $delete="<a href='".url('/upload/delete/'.$upload->id).
            "'><span style='color:red' class='glyphicon glyphicon-remove'></span></a>";

            $nom=$upload->nom;
            $size=$upload->sizeko;
            $nom="<a href='".url("/upload/".$nom)."'>".$nom." </a>";
            $res.=$nom."<small>(".$size."Ko)</small>";
            $res.=$delete."<br/>";
        }

        return $res;
    }
}
