<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use Zizaco\Entrust\Traits\EntrustUserTrait;
use App\Http\Controllers\Logs;

class Cotisation extends Model {
	
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'cotis';


    /* Dates */
    public function getDates()
    {
            return array('date','mois','encais_date','date_depot');
    }


     public function getDateAttribute($value)
    {
        return (($this->attributes['date']!="0000-00-00")&&($this->attributes['date']!=null))?date('d/m/Y', strtotime($this->attributes['date'])):"";
    }

     public function getMoisAttribute($value)
    {
        return (($this->attributes['mois']!="0000-00-00")&&($this->attributes['mois']!=null))?date('d/m/Y', strtotime($this->attributes['mois'])):"";
    }

     public function getMoisUSAttribute($value)
    {
        return $this->attributes['mois'];
    }

     public function getEncaisDateAttribute($value)
    {
        return (($this->attributes['encais_date']!="0000-00-00")&&($this->attributes['encais_date']!=null))?date('d/m/Y', strtotime($this->attributes['encais_date'])):"";
    }

     public function getDateDepotAttribute($value)
    {
        return (($this->attributes['date_depot']!="0000-00-00")&&($this->attributes['date_depot']!=null))?date('d/m/Y', strtotime($this->attributes['date_depot'])):"";
    }

     public function getNomEmployeurAttribute($value)
    {
        $employeur=Employeur::find($this->sonum);

        return $employeur->nom;
    }

    public function getAnneeRatachementAttribute($value)
    {
        $annee=substr($this->attributes['mois'],0,4);

        return $annee;
    }


     public function getMoisLettreAttribute($value)
    {
        $mois_lettre="";
        $t_mois=[1=>"Jan",2=>"Fev",3=>"Mar",4=>"Avr",5=>"Mai",6=>"Jun",7=>"Jui",8=>"Aou",9=>"Sep",10=>"Oct",11=>"Nov",12=>"Dec"];
        $mois=(strlen($this->mois)>5)?substr($this->mois,3,2):"0";

        if(intVal($mois)>0) $mois_lettre=$t_mois[intVal($mois)];
        return $mois_lettre;
    }


     public function getPrcCCPFAttribute($value)
    {
        if($this->exercice=="") return "";
        $prc="";
        $taux_ccpf=Parametre::where('ref','=','TAUX_CLR_CCPF')->first()->TauxCCPF;
        if( isset($taux_ccpf[$this->exercice]) ) {
            $prc=$taux_ccpf[$this->exercice]."%";
        }
        
        return $prc;
    }

     public function getPrcCLRAttribute($value)
    {
        if($this->exercice=="") return "";
        $prc="";
        $taux_clr=Parametre::where('ref','=','TAUX_CLR_CCPF')->first()->TauxCLR;
        if( isset($taux_clr[$this->exercice]) ) {
            $prc=$taux_clr[$this->exercice]."%";
        }

        return $prc;
    }

    public function getPrcTotAttribute($value)
    {
        if($this->exercice=="") return "";
        $prc="";
        $taux_clr=Parametre::where('ref','=','TAUX_CLR_CCPF')->first()->TauxCLR;
        $taux_ccpf=Parametre::where('ref','=','TAUX_CLR_CCPF')->first()->TauxCCPF;
        if( isset($taux_clr[$this->exercice]) && isset($taux_ccpf[$this->exercice]) ) {
            $prc=$taux_clr[$this->exercice]+$taux_ccpf[$this->exercice]."%";
        }
        return $prc;
    } 

    public function getisReglementAttribute($value)
    {
        $reglement=false;
        if(($this->lettrage!='')&&($this->credit!=0)) $reglement=true;
        return $reglement;
    } 

    public function getReglementsAttribute($value)
    {
        
        $lettrage=$this->lettrage;
        $fields = explode(',', $lettrage);
        $cotisations=Cotisation::wherein('id',$fields)->orderby('date','DESC')->get();
        return $cotisations;
    } 


    public function getTotalCotisationsAttribute($value)
    {
        $lettrage=$this->lettrage;
        $fields = explode(',', $lettrage);
        $total=Cotisation::wherein('id',$fields)->sum('debit');
        return $total;
    } 
    public function getListeCotisationsAttribute($value)
    {
        $liste="";
        $lettrage=$this->lettrage;
        $fields = explode(',', $lettrage);
        $cotisations=Cotisation::wherein('id',$fields)->select('id')->get();
        if($cotisations) foreach($cotisations as $cotisation) $liste.=(($liste=="")?"":",").$cotisation->id;
        return $liste;
    } 


    public function getTotalReglementsAttribute($value)
    {

        $total=Cotisation::where('lettrage','=',$this->lettrage)->sum('credit');
        return $total;
    } 

    public function getListeReglementsAttribute($value)
    {
        $liste="";
        $cotisations=Cotisation::where('lettrage','=',$this->lettrage)->select('id')->get();
        foreach($cotisations as $cotisation) $liste.=(($liste=="")?"":",").$cotisation->id;
        return $liste;
    } 

    public function getModeReglementLibelleAttribute($value)
    {
        $t_modes=[ 'A'=>'Autre'
            ,'B' => 'Banque'
            ,'E' => 'Espèce'
            ,'T' => 'Trésor'
            ,'V' => 'Virement'
            ,'€' => 'Euro'
            ,'N' => 'Nul'];
        $mode=isset($t_modes[$this->typepmt])?$t_modes[$this->typepmt]:"";
        return $mode;
    } 

    public function getTypesPaiement()
    {
        $t_modes=[ ''=>'','A'=>'Autre'
            ,'B' => 'Banque'
            ,'E' => 'Espèce'
            ,'T' => 'Trésor'
            ,'V' => 'Virement'
            ,'€' => 'Euro'
            ,'N' => 'Nul'
            ,'P' => 'Prélèvement automatique'];
        return $t_modes;
    } 

    public function getEmployeurAttribute()
    {
        $nom_employeur="";
        if($this->sonum<>0) $nom_employeur=DB::table('employeurs')->where('id', '=', $this->sonum)->value('nom');
        return $nom_employeur;
    }


    public function getVerrouDebitAttribute()
    {
       
        if( ($this->statut=="DEB") || ($this->statut=="ALL") ) return true;
        return false;
    }

    public function getVerrouCreditAttribute()
    {
        if( ($this->statut=="CRE") || ($this->statut=="ALL") ) return true;
        return false;
    }


    public function getVerrouAttribute()
    {
        return ($this->VerrouDebit && $this->VerrouCredit );
    }


    //LOG
     public function log_transaction($url,$operation) {
        $log=new Logs;
        $values="";
        $t_values=$this->getAttributes();
        foreach($t_values as $nom=>$value) $values.=(($values=="")?"":";").$nom."=>".$value; 
        $log->addlog(['url'=>$url,'table'=>$this->table ,'operation'=>$operation,'values'=>$values]);
    }
}
