<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use Zizaco\Entrust\Traits\EntrustUserTrait;
use App\Http\Controllers\Logs;

class Enfant extends Model {
	
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'enfants';



  public function parent1()
    {
        return $this->belongsTo('App\Beneficiaire', 'parent1', 'id');
    }

  public function parent2()
    {
        return $this->belongsTo('App\Beneficiaire', 'parent2', 'id');
    }


    /* Dates */
    public function getDates()
    {
            return array('datenais');
    }


    /* Dates */
    public function getAgeAttribute()
    {
        $date=$this->attributes['datenais'];
        if($date=="") return;
        $age = date('Y') - date('Y', strtotime($date));
        if (date('md') < date('md', strtotime($date))) {
            return $age - 1;
        }
        return $age;
    }


    public function getNewCertificatAttribute()
    {
        $date=$this->attributes['datenais'];
        $age=$this->age;
        $certif=$this->certif;
        if($certif=='') $certif=0;

        $res=$certif;

        if($certif==0) {
            if($age<6) $res=1;
            if($age>21) $res=9;
        } 

        if($certif==1) {
            $res=0;
            if($age<6) $res=1;
            if($age>21) $res=9;
        } 

        if($certif==2) {
            $res=0;
            if($age<6) $res=1;
            if($age>21) $res=9;
        }

        if($certif==4) {
            $res=4;
            if($age>21) $res=9;
        }

        if($certif==3) {
            if($age<6) $res=1;
            if($age>21) $res=9;
        }

        if($certif==9) {
            //$res=9;
        }


        return $res;
    }

     public function getDateNaisAttribute($value)
    {
        return ($this->attributes['datenais']!="0000-00-00")?date('d/m/Y', strtotime($this->attributes['datenais'])):"";
    }


        /* Dates */
    public function getNomCompletAttribute()
    {
            return $this->nom." ".$this->prenom;
    }

        /* Dates */
    public function getNomCompletReduitAttribute()
    {
        $taillemax=20;
        $prenom=$this->PrenomReduit;
        if(strlen($prenom)>$taillemax) $prenom=substr($prenom,0,$taillemax);
        return trim($this->nom)." ".$prenom;
    }


        /* Dates */
    public function getPrenomReduitAttribute()
    {
        $prenom=str_replace(',',' ',$this->prenom);
        $prenom=str_replace('  ',' ',$prenom);
        $t_prenom=explode(' ',$prenom);
        $prenom=trim($t_prenom[0]);
        return $prenom;
    }


        /* Parent1 */
    public function getNomParent1Attribute()
    {
        $nom_parent1="";
        $parent1  = Beneficiaire::find($this->parents1);
        if(isset($parent1)) $nom_parent1=trim($parent1->nom)." ".trim($parent1->prenom);
        return $nom_parent1;
    }
    public function getStatutParent1Attribute()
    {
        if($this->parents1=="") return "";
        $beneficiaire=Beneficiaire::find($this->parents1);
        if(!$beneficiaire) return "";
        return $beneficiaire->statut;
    }

        /* Parent1 */
    public function getNomParent1ReduitAttribute()
    {
        $nom_parent1="";
        $parent1  = Beneficiaire::find($this->parents1);
        if(isset($parent1)) $nom_parent1=$parent1->NomCompletReduit;
        return $nom_parent1;
    }

        /* Parent2 */
    public function getNomParent2Attribute()
    {
        $nom_parent2="";
        $parent2  = Beneficiaire::find($this->parents2);
        if(isset($parent2)) $nom_parent2 =trim($parent2->nom)." ".trim($parent2->prenom);
        return $nom_parent2;
    }

        /* Parent2 */
    public function getNomParent2ReduitAttribute()
    {
        $nom_parent2="";
        $parent2  = beneficiaire::find($this->parents2);
        if(isset($parent2)) $nom_parent2 =$parent2->nom_complet_reduit;
        return $nom_parent2;
    }
    public function getStatutParent2Attribute()
    {
        if($this->parents2=="") return "";
        $beneficiaire=Beneficiaire::find($this->parents2);
        if(!$beneficiaire) return "";
        return $beneficiaire->statut;
    }


    //LOG
     public function log_transaction($url,$operation,$values="") {
        $log=new Logs;
        if($values=="") {
          $t_values=$this->getAttributes();
          foreach($t_values as $nom=>$value) $values.=(($values=="")?"":";").$nom."=>".$value; 
        } 
        $log->addlog(['url'=>$url,'table'=>$this->table ,'operation'=>$operation,'values'=>$values]);
    }


}
