<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Auth\Authenticatable;


class GrandLivre extends Model {
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'grand_livre';

    /* Dates */
    public function getDates()
    {
            return array('date_doc','date_lettrage','updated_at','created_at ');
    }


    public function getDateDocAttribute($value)
    {
        return ($this->attributes['date_doc']!=null)?date('d/m/Y', strtotime($this->attributes['date_doc'])):null;
    }

    public function getDateDocUSAttribute($value)
    {
        return ($this->attributes['date_doc']!=null)?date('Y-m-d', strtotime($this->attributes['date_doc'])):null;
    }

    public function getDateLettrageAttribute($value)
    {
        return ($this->attributes['date_lettrage']!=null)?date('d/m/Y', strtotime($this->attributes['date_lettrage'])):null;
    }

    public function getDateModificationAttribute($value)
    {
        return ($this->attributes['updated_at']!=null)?date('d/m/Y', strtotime($this->attributes['updated_at'])):null;
    }
  
     public function getDateCreationAttribute($value)
    {
        return ($this->attributes['created_at']!=null)?date('d/m/Y', strtotime($this->attributes['created_at'])):null;
    }  


    function getCompteLabelAttribute() {
        $plancomptable=PlanComptable::where('compte','=',$this->compte)->first();

        if(!$plancomptable) return "";
        return $plancomptable->libelle;
    }


    function getIdGroupeAttribute() {

        return str_pad($this->transaction,4,"0",STR_PAD_LEFT)."-".str_pad($this->id,5,"0",STR_PAD_LEFT);
    }

    function getIdTransactionAttribute() {

        return str_pad($this->transaction,5,"0",STR_PAD_LEFT);
    }

    function getCompteNomCompletAttribute() {
        $plan=Plan::where('numcpt','=',$this->compte)->first();
        if(!$plan) return "";
        return $plan->CompteNomComplet;
    }

    function getCompteAuxiliaireNomCompletAttribute() {
        $plancomptable=PlanComptable::where('compte','=',$this->compte_aux)->first();
        if(!$plancomptable) return "";
        return $plancomptable->CompteNomComplet;
    }

    function getForfaitAttribute() {
        $forfait=Forfait::where('id','=',$this->id_forfait)->first();
        if(!$forfait) return "";
        return $forfait->nom;
    }

    function getIsSupprimableAttribute() {
        $nb_lignes=GrandLivre::where('transaction','=',$this->transaction)->count();
        if($nb_lignes>1) return false;
        if($this->lettrage_code!="") return false;
        return true;
    }

}