<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use Zizaco\Entrust\Traits\EntrustUserTrait;


class Journal extends Model {
	
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'journal';


    /* Dates */
    public function getDates()
    {
            return array('date');
    }


     public function getDateAttribute($value)
    {
        return (($this->attributes['date']!="0000-00-00")&&($this->attributes['date']!=null))?date('d/m/Y', strtotime($this->attributes['date'])):"";
    }

     public function getNomCompteAttribute()
    {
        $nomcpt=Plan::where('numcpt','=',$this->numcpt)->value('nomcpt');
        if(!isset($nomcpt)) return "";
        return $nomcpt;
    }



     public function getIsCompensableAttribute()
    {

        $ref=$this->ref;
        if(strpos($ref,"MDT")===false) return false;
        //$ref="ema";
        $tot_debit_credit=DB::table('journal')
            ->where('ref','=',$ref)
            ->select(db::raw('SUM(debit) as debit,SUM(credit) as credit'))
            ->groupby('ref')
            ->first();

        //dd($tot_debit_credit->debit." , ".$tot_debit_credit->credit);
        if( ($tot_debit_credit->debit-$tot_debit_credit->credit!=0) ) return true;
        return false;
    }


}
