<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use Zizaco\Entrust\Traits\EntrustUserTrait;


class Log extends Model {
	
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'logs';
    public $timestamps = false;

    /* Dates */
    public function getDates()
    {
            return array('date');
    }


     public function getDateAttribute($value)
    {
        return (($this->attributes['date']!="0000-00-00")&&($this->attributes['date']!=null))?date('d/m/Y', strtotime($this->attributes['date'])):"";
    }

     public function getDateUSAttribute($value)
    {
        return $this->attributes['date'];
    }

    public function getValueUserAttribute()
    {
        $res="";
        $t_values=explode(";",$this->values);

        foreach($t_values as $value) {
            $t_detail=explode("=>",$value);
            if(count($t_detail)>=2) {
                $champ=$t_detail[0];
                $data=$t_detail[1];
                if( ($champ!="password") &&($champ!="id") &&($champ!="created_at")
                    &&($champ!="updated_at")){
                    $res.=(($res=="")?"":"<br>")."[".strtoupper($champ)."] => ".$data." ; ";
                }
            }
        }
        return $res;
    }


    public function getValueRoleAttribute()
    {
        $res="";
        $t_values=explode(";",$this->values);

        foreach($t_values as $value) {
            $t_detail=explode("=>",$value);
            if(count($t_detail)>=2) {
                $champ=$t_detail[0];
                $data=$t_detail[1];
                if($champ=="role_id") {
                    $role=Role2::find($data);
                    $res.=(($res=="")?"":"<br>").$role->name;
                }
            }
        }
        return $res;
    }


}
