<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use Zizaco\Entrust\Traits\EntrustUserTrait;
use App\Http\Controllers\Logs;

class Med extends Model {
	
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'med';

    /* Dates */
    public function getDates()
    {
            return array('date_envoi','periode_deb','periode_fin');
    }


     public function getDateEnvoiAttribute()
    {
        return (($this->attributes['date_envoi']!="0000-00-00")&&($this->attributes['date_envoi']!=null))?date('d/m/Y', strtotime($this->attributes['date_envoi'])):"";
    }
    
     public function getPeriodeDebAttribute()
    {
        return (($this->attributes['periode_deb']!="0000-00-00")&&($this->attributes['periode_deb']!=null))?date('d/m/Y', strtotime($this->attributes['periode_deb'])):"";
    }

     public function getPeriodeFinAttribute()
    {
        return (($this->attributes['periode_fin']!="0000-00-00")&&($this->attributes['periode_fin']!=null))?date('d/m/Y', strtotime($this->attributes['periode_fin'])):"";
    }


     public function getMotifLibelleAttribute()
    {
        $t_values=array('TAR' => 'Production tardive', 
                        'ABS' => 'Absence ou insuffisance de versement', 
                        'BOR' => 'Défaut de production du bordereau de déclaration nomminative',
                        'RET' => 'Retard dans le versement', 
                        'RED' => 'Redressement suite au contrôle');
        if(isset($t_values[$this->motif])) return  $t_values[$this->motif];                
        return "";
    }


    //LOG
     public function log_transaction($url,$operation) {
        $log=new Logs;
        $values="";
        $t_values=$this->getAttributes();
        foreach($t_values as $nom=>$value) $values.=(($values=="")?"":";").$nom."=>".$value; 
        $log->addlog(['url'=>$url,'table'=>$this->table ,'operation'=>$operation,'values'=>$values]);
    }

}
