<?php namespace App\Models;

use Illuminate\Auth\Authenticatable;
use Illuminate\Database\Eloquent\Model;
use App\Http\Controllers\Logs;

class Parametre extends Model {


	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'parametres';
	protected $primaryKey = 'ref';
	public  $timestamps = false;
	


        /* Retourne un tablea de taux ANNEE=>TAUX CLR */
    public function getRefAttribute()
    {

        return $this->ref2;
    }



        /* Retourne un tablea de taux ANNEE=>TAUX CLR */
    public function getTauxCLRAttribute()
    {
    	//if($this->ref!="TAUX_CLR_CCPF") return "";
    	$res_clr=array();
        $t_taux=explode("\r\n",$this->value); 
        foreach($t_taux as $taux) {
            $taux_values=explode(";",$taux);
            $annee=$taux_values[0];
            $taux_clr=$taux_values[1];
            $taux_ccpf=$taux_values[2];
        	$res_clr[$annee]=$taux_clr;
        }
        return $res_clr;
    }


        /* Retourne un tablea de taux ANNEE=>TAUX CCPF */
    public function getTauxCCPFAttribute()
    {
    	//if($this->ref!="TAUX_CLR_CCPF") return "";
    	$res_ccpf=array();
        $t_taux=explode("\r\n",$this->value); 
        foreach($t_taux as $taux) {
            $taux_values=explode(";",$taux);
            $annee=$taux_values[0];
            $taux_clr=$taux_values[1];
            $taux_ccpf=$taux_values[2];
        	$res_ccpf[$annee]=$taux_ccpf;
        }
        return $res_ccpf;
    }


        /* Retourne les exercices ANNEE=>ANNEE */
    public function getExercicesAttribute()
    {
        //dd($this->{'ref'});
        //if($this->ref!="TAUX_CLR_CCPF") return "";


        $exercices=array();
        $t_taux=explode("\r\n",$this->value); 
        foreach($t_taux as $taux) {
            $taux_values=explode(";",$taux);
            $annee=$taux_values[0];
            if($annee<=date("Y")) //Supprime exercices > année en cours
                $exercices[$annee]=$annee;
        }
        arsort($exercices);
        
        return $exercices;
    }


    /* Retourne les types de paiement */
    public function getTypesPaiement()
    {

        $_types=array('A'=>'Autre'
        ,'B' => 'Banque'
        ,'E' => 'Espèce'
        ,'T' => 'Trésor'
        ,'V' => 'Virement'
        ,'€' => 'Euro'
        ,'N' => 'Nul');
        return $_types;
    }

    /* Retourne les types de paiement */
    public function getTypesPaiementLibelle()
    {

        $_types=array('A'=>'Autre'
        ,'B' => 'Règlement par chèque B.W.F.'
        ,'E' => 'Règlement en espèce'
        ,'T' => 'Règlement par chèque Trésor Public'
        ,'V' => 'Règlement par Virement'
        ,'€' => 'Règlement en Virement Euro'
        ,'N' => '');
        return $_types;
    }

    /* Retourne les types de paiement */
    public function getMoisLibelle($mois)
    {
       $t_moislib=array("01"=>"Janvier","02"=>"Février","03"=>"Mars","04"=>"Avril","05"=>"Mai","06"=>"Juin"
                ,"07"=>"Juillet","08"=>"Août","09"=>"Septembre","10"=>"Octobre","11"=>"Novembre","12"=>"Décembre");
        return $t_moislib[$mois];
    }

    //LOG
     public function log_transaction($url,$operation) {
        $log=new Logs;
        $values="";
        $t_values=$this->getAttributes();
        foreach($t_values as $nom=>$value) $values.=(($values=="")?"":";").$nom."=>".$value; 
        $log->addlog(['url'=>$url,'table'=>$this->table ,'operation'=>$operation,'values'=>$values]);
    }
    
}
