<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use Zizaco\Entrust\Traits\EntrustUserTrait;
use App\Http\Controllers\Logs;

class Plan extends Model {
	
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'plans';





     public function getCategLibelleAttribute()
    {
        $t_libelles=[
            'F'=>'CCPF (F)','R' => 'CLR (R)','A' => 'AS/AV (A)','V' => 'Autre (V)'];
        return $t_libelles[$this->categ];
    }


     public function getCategBilanLibelleAttribute()
    {
        if($this->categ_bilan=="A") return "Actif";
        if($this->categ_bilan=="P") return "Passif";  
        return "";
    }

     public function getCategCRLibelleAttribute()
    {
        $t_libelles=[
            ''=>"",
            'CF'=>'Charges CCPF résultat ccpf',
            'CR' => 'Charges CLR résultat clr',
            'CS' => 'Charges aides sociales résultat social',
            'PF'=>'Produits CCPF résultat ccpf',
            'PR' => 'Produits CLR résultat clr',
            'PS' => 'Produits aides sociales résultat social'
        ];


        return $t_libelles[$this->categ_CR];
    }

 
     public function getCreditCalc($exercice="")
    {
    	if($exercice=="") $exercice=date('Y');

        $montant=DB::table('journal')->select(db::raw("SUM(credit) as credit"))
            ->where('numcpt','=',$this->numcpt)
            ->where('date','like',$exercice.'%')
            ->value('credit');
        if(!isset($montant)) $montant=0;  
        return $montant;
    }


     public function getDebitCalc($exercice="")
    {
    	if($exercice=="") $exercice=date('Y');
        $montant=DB::table('journal')->select(db::raw("SUM(debit) as debit"))
            ->where('numcpt','=',$this->numcpt)
            ->where('date','like',$exercice.'%')
            ->value('debit');
        if(!isset($montant)) $montant=0;   
        return $montant;
    }

     public function getSoldeCalc($exercice="")
    {
    	if($exercice=="") $exercice=date('Y');
        $montant=DB::table('journal')->select(db::raw("SUM(credit-debit) as solde"))
            ->where('numcpt','=',$this->numcpt)
            ->where('date','like',$exercice.'%')
            ->value('solde');
        if(!isset($montant)) $montant=0;  
        return $montant;
    }

     public function getSoldeTotCalc($exercice="")
    {
        if($exercice=="") $exercice=date('Y');
        $montant=DB::table('journal')->select(db::raw("SUM(budget+credit-debit) as solde"))
            ->where('numcpt','=',$this->numcpt)
            ->where('date','like',$exercice.'%')
            ->value('solde');
        if(!isset($montant)) $montant=0;  
        return $montant;
    }


     public function getNbEcrituresAttribute()
    {
        $nb=DB::table('journal')->where('numcpt','=',$this->numcpt)
            ->count();  
        $nb2=DB::table('journal_h')->where('numcpt','=',$this->numcpt)
            ->count();  
        return intval($nb+$nb2);
    }


    
    //LOG
     public function log_transaction($url,$operation) {
        $log=new Logs;
        $values="";
        $t_values=$this->getAttributes();
        foreach($t_values as $nom=>$value) $values.=(($values=="")?"":";").$nom."=>".$value; 
        $log->addlog(['url'=>$url,'table'=>$this->table ,'operation'=>$operation,'values'=>$values]);
    }
}
