<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Auth\Authenticatable;


class PlanComptable extends Model {
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'plan_comptable';


    function getActifHTMLAttribute() {
        $actif=$this->actif;
        $txt="";

        if($actif) {
	        $txt='<div class="custom-control custom-switch custom-switch-on-success">';
			$txt.='<input class="custom-control-input" checked="checked" type="checkbox" value="1">';
	        $txt.='<label class="custom-control-label" for="box_actif"></label>';
        	$txt.='</div>';
    	} else {
	        $txt='<div class="custom-control custom-switch custom-switch-off-danger">';
			$txt.='<input class="custom-control-input" checked="checked" type="checkbox" value="0">';
	        $txt.='<label class="custom-control-label" for="box_inactif"></label>';
	    }
        return $txt;
    }

    function getCompteNomCompletAttribute() {
    	return $label=$this->compte." ".$this->libelle;
    }


    function getDepensesMontant($id_forfait) {
    	$montant=0;
    	$ecritures=GrandLivre::where('id_forfait','=',$id_forfait)
    		->where('compte','like',$this->compte.'%')
    		->get();
    	foreach($ecritures as $ecriture) {
    		$montant+=$ecriture->credit-$ecriture->debit;
    	}
    	return $montant;
    }

}