<?php namespace App\Models;

use DB;
use Spatie\Permission\Traits\HasRoles;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use App\Http\Controllers\Logs;
use Auth\AuthController;
use Illuminate\Support\Facades\Auth;

class Role2 extends Role
{
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'roles';

	 /**
	 * Génère un tablea json des liostes des utilisateurs
	 *
	 * @param int       $array - Tableau des différents formulaires
	 *
	 * @return json
	 *
	 */

	public function getusers()
	{
        $t_getusers=DB::table('model_has_roles')
            ->where('role_id', '=', $this->id)
            ->where('model_type','=','App\Models\User')
            ->value("model_id")
            ->toArray();
        $list="";
        foreach($t_getusers as $user_id) {
            $user_role=User::find($user_id);
        	if($user_role) $list.=(($list=="")?"":" ; ").$user_role->name;
        }

	    return $list;
	 }



	public function getNomUsersAttribute()
	{
        $t_getusers=DB::table('model_has_roles')
            ->where('role_id', '=', $this->id)
            ->where('model_type','=','App\Models\User')
            ->pluck("model_id")
            ->toArray();
        $list="";
        foreach($t_getusers as $user_id) {
            $user_role=User::find($user_id);
        	if($user_role) $list.=(($list=="")?"":" ; ").$user_role->FullName;
        }

	    return $list;
	 }


	public function getNbPermissionsAttribute()
	{
        $nb=DB::table('role_has_permissions')
            ->where('role_id', '=', $this->id)
            ->count();

	    return $nb;
	 }
	 /*
	public function getusers()
	{
	    $liste_users="";
		$role_users =  DB::table('role_user')->where('role_id', '=', $this->id)->get();

		foreach ($role_users as $role_user)
		{
			$user=User::find($role_user->user_id);
		    $liste_users .=(($liste_users=="")?"":"<br/>").($user->full_name);
		} 
	    return $liste_users;
	 }
*/


    //LOG
     public function log_transaction($url,$operation,$values="") {
        $log=new Logs;
        if($values=="") {
          $t_values=$this->getAttributes();
          foreach($t_values as $nom=>$value) $values.=(($values=="")?"":";").$nom."=>".$value; 
        } 

        $log->addlog(['url'=>$url,'table'=>$this->table ,'operation'=>$operation,'values'=>$values]);
    }


	public function getDroits()
	{
		$user=Auth::user();
		dd($user->permissions());
	    $liste_permissions="";
		$permissions_role =  DB::table('permission_role')->select('permission_id')->where('role_id', '=', $this->id)->get();
		$t_perm=array();
		foreach ($permissions_role as $permission_role) $t_perm[]=$permission_role->permission_id;

		$permissions = Permission::wherein('id',$t_perm)->orderby('display_name')->get();
		foreach ($permissions as $permission) 
		{
		    $liste_permissions .=(($liste_permissions=="")?"":"\n\r"."<br/>").$permission->display_name;
		} 
	    return $liste_permissions;
	 }
/*
	public function getDroits()
	{
	    $liste_permissions="";
		$permissions_role =  DB::table('permission_role')->select('permission_id')->where('role_id', '=', $this->id)->get();
		$t_perm=array();
		foreach ($permissions_role as $permission_role) $t_perm[]=$permission_role->permission_id;

		$permissions = Permission::wherein('id',$t_perm)->orderby('display_name')->get();
		foreach ($permissions as $permission) 
		{
		    $liste_permissions .=(($liste_permissions=="")?"":"\n\r"."<br/>").$permission->display_name;
		} 
	    return $liste_permissions;
	 }
*/
}