<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use Zizaco\Entrust\Traits\EntrustUserTrait;
use App\Http\Controllers\Logs;

class Salaire extends Model {
	
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'salaire';


    /* Dates */
    public function getDates()
    {
            return array('dat_ent','date_sor');
    }


     public function getDatEntAttribute($value)
    {
        return (($this->attributes['dat_ent']!="0000-00-00")&&($this->attributes['dat_ent']!=null))?date('d/m/Y', strtotime($this->attributes['dat_ent'])):"";
    }

     public function getDateSorAttribute($value)
    {
        return (($this->attributes['date_sor']!="0000-00-00")&&($this->attributes['date_sor']!=null))?date('d/m/Y', strtotime($this->attributes['date_sor'])):"";
    }
  

     public function getBeneficiaireNomAttribute($value)
    {
        $beneficiaire=Beneficiaire::find($this->benum);
        if(!isset($beneficiaire)) return "";
        return $beneficiaire->nom_complet;
    }  

     public function getBeneficiaireNomCompletReduitAttribute($value)
    {
        $beneficiaire=Beneficiaire::find($this->benum);
        if(!isset($beneficiaire)) return "";
        return $beneficiaire->NomCompletReduit;
    }  

    public function getBeneficiaireDateNaissanceAttribute()
    {
        $beneficiaire=Beneficiaire::find($this->benum);
        if(!isset($beneficiaire)) return "";
        return $beneficiaire->datenaiss;
    } 
    
    public function getEmployeurNomAttribute($value)
    {
        $employeur=Employeur::find($this->sonum);
        if(!isset($employeur)) return "";
        return $employeur->nom;
    }  

    public function getEmployeurStatutAttribute($value)
    {
        $employeur=Employeur::find($this->sonum);
        if(!isset($employeur)) return "";
        return $employeur->statut;
    }  

    public function getTotalAnneeAttribute()
    {
        $total=$this->jan+
            $this->fev+
            $this->mar+
            $this->avr+
            $this->mai+
            $this->jun+
            $this->jui+
            $this->aou+
            $this->sep+
            $this->oct+
            $this->nov+
            $this->dec;
        
        return $total;
    }



    public function getIsHorsPlafond($mois)
    {
        $t_mois=["jan"=>"01","fev"=>"02","mar"=>"03","avr"=>"04","mai"=>"05",
            "jun"=>"06","jui"=>"07","aou"=>"08","sep"=>"09","oct"=>"10","nov"=>"11","dec"=>"12"];
        $t=[];
        //foreach($t_mois as $mois=>$nummois) {
            $date=$this->annee."-".$t_mois[$mois]."-28";
            $plafond=MyApp::getPlafondCotisation($date);
            if($this->$mois>$plafond) $t[]=$mois;
        //}

        return $t;
    }

    public function getSuspendu($mois)
    {
        $suspendus=$this->suspendus;

        if(!$suspendus) return "";
        $t_mois=[0=>"jan",1=>"fev",2=>"mar",3=>"avr",4=>"mai",
            5=>"jun",6=>"jui",7=>"aou",8=>"sep",9=>"oct",10=>"nov",11=>"dec"];
        
        $t=explode('|',$suspendus);
        foreach($t as $mois_sus) 
            if($mois==$t_mois[$mois_sus-1]) return true;
        return false;
    }

     public function getSalaireMoyenAttribute()
    {
        $t_mois=[0=>"jan",1=>"fev",2=>"mar",3=>"avr",4=>"mai",
            5=>"jun",6=>"jui",7=>"aou",8=>"sep",9=>"oct",10=>"nov",11=>"dec"];
        $t_column["jan"]=$this->jan;
        $t_column["fev"]=$this->fev;
        $t_column["mar"]=$this->mar;
        $t_column["avr"]=$this->avr;
        $t_column["mai"]=$this->mai;
        $t_column["jun"]=$this->jun;
        $t_column["jui"]=$this->jui;
        $t_column["aou"]=$this->aou;
        $t_column["sep"]=$this->sep;
        $t_column["oct"]=$this->oct;
        $t_column["nov"]=$this->nov;
        $t_column["dec"]=$this->dec;
        $salaire=0;$salaire_reel=0;
        $nb_mois=0;$nb_mois_reel=0;
        for($k=0;$k<12;$k++) {
            $salaire_mois=$t_column[$t_mois[$k]];
            $salaire_reel+=$salaire_mois;
            $nb_mois_reel++;
            if($salaire_mois>0) {
                $salaire+=$salaire_mois;
                $nb_mois++;
            }
            
        }
        $salaire_moy=round($salaire/$nb_mois,0);
        $salaire_moy_reel=round($salaire/$nb_mois_reel,0);
        $res=$nb_mois."~".$salaire_moy."~".$nb_mois_reel."~".$salaire_moy_reel;
        return $res;
    }


    public function getSalairesTab()
    {
        
        $t_mois=[0=>"jan",1=>"fev",2=>"mar",3=>"avr",4=>"mai",
            5=>"jun",6=>"jui",7=>"aou",8=>"sep",9=>"oct",10=>"nov",11=>"dec"];
        $t_column["jan"]=$this->jan;
        $t_column["fev"]=$this->fev;
        $t_column["mar"]=$this->mar;
        $t_column["avr"]=$this->avr;
        $t_column["mai"]=$this->mai;
        $t_column["jun"]=$this->jun;
        $t_column["jui"]=$this->jui;
        $t_column["aou"]=$this->aou;
        $t_column["sep"]=$this->sep;
        $t_column["oct"]=$this->oct;
        $t_column["nov"]=$this->nov;
        $t_column["dec"]=$this->dec;
        $salaire=0;$salaire_reel=0;
        $nb_mois=0;$nb_mois_reel=0;
        $salaire=array();
        for($k=0;$k<12;$k++) {
            $val=$t_column[$t_mois[$k]]; 
            $salaire[$k+1]=$val; 
        }
        return $salaire;
    }

     public function getSalairesMois($mois)
    {
        $t_salaires=$this->getSalairesTab();
        return $t_salaires[$mois];

    }

     public function getFirstMoisSalaireAttribute()
    {
        $mois="";
        if($this->jan>0) $mois="01";
        else if($this->fev>0) $mois="02";
        else if($this->mar>0) $mois="03";
        else if($this->avr>0) $mois="04";
        else if($this->mai>0) $mois="05";
        else if($this->jun>0) $mois="06";
        else if($this->jui>0) $mois="07";
        else if($this->aou>0) $mois="08";
        else if($this->sep>0) $mois="09";
        else if($this->oct>0) $mois="10";
        else if($this->nov>0) $mois="11";
        else if($this->dec>0) $mois="12";
        return $mois;
    }

     public function getLastMoisSalaireAttribute()
    {
        $mois="";
        
        if($this->dec>0) $mois="12";
        else if($this->nov>0) $mois="11";
        else if($this->oct>0) $mois="10";
        else if($this->sep>0) $mois="09";
        else if($this->aou>0) $mois="08";
        else if($this->jui>0) $mois="07";
        else if($this->jun>0) $mois="06";
        else if($this->mai>0) $mois="05";
        else if($this->avr>0) $mois="04";
        else if($this->mar>0) $mois="03";
        else if($this->fev>0) $mois="02";
        else if($this->jan>0) $mois="01";
        return $mois;
    }


    public function getNbsalaireAttribute()
    {
        $t_mois=array('jan','fev','mar','avr','mai','jun','jui','aou','sep','oct','nov','dec');
        foreach($t_mois as $mois) $nb_salaire[$mois]=0;
        $nb_salaire["total"]=0;
        if($this->jan>0) $nb_salaire['jan']++;
        if($this->fev>0) $nb_salaire['fev']++;
        if($this->mar>0) $nb_salaire['mar']++;
        if($this->avr>0) $nb_salaire['avr']++;
        if($this->mai>0) $nb_salaire['mai']++;
        if($this->jun>0) $nb_salaire['jun']++;
        if($this->jui>0) $nb_salaire['jui']++;
        if($this->aou>0) $nb_salaire['aou']++;
        if($this->sep>0) $nb_salaire['sep']++;
        if($this->oct>0) $nb_salaire['oct']++;
        if($this->nov>0) $nb_salaire['nov']++;
        if($this->dec>0) $nb_salaire['dec']++;
        foreach($t_mois as $mois) $nb_salaire['total']+=$nb_salaire[$mois];

        return $nb_salaire;
    }


    public function get_log($id_salaire_log="") {
        if($id_salaire_log=="") $salaires_logs=LogSalaire::where('id_salaire','=',$this->id)->orderby('id','DESC')->get();
        else $salaires_logs=LogSalaire::where('id','=',$id_salaire_log)->get();

        $t_res=[];
        $t_mois=MyApp::MOIS_COURT_LONG;
        foreach($salaires_logs as $salaire_log) {
            $nom_employeur="";$nom_beneficiaire="";
            $date=substr($salaire_log->created_at,0,10);
            $heure=substr($salaire_log->created_at,11,8);
            $col=$salaire_log->col;
            if(isset($t_mois[$salaire_log->col])) $col=$t_mois[$salaire_log->col];
            $beneficiaire=Beneficiaire::find($salaire_log->benum);
            if($beneficiaire) $nom_beneficiaire=$beneficiaire->NomComplet;
            $employeur=Employeur::find($salaire_log->sonum);
            if($employeur) $nom_employeur=$employeur->nom;
   
            $t_res[]=["date"=>$date,
                "heure"=>$heure,
                "login"=>$salaire_log->login,
                "ip"=>$salaire_log->ip,
                "benum"=>$salaire_log->benum,
                "nom_beneficiaire"=>$nom_beneficiaire,
                "sonum"=>$salaire_log->sonum,
                "nom_employeur"=>$nom_employeur,
                "value"=>$col.":".$salaire_log->val_old ."=>".$salaire_log->val_new
            ];
        }

        return $t_res;
    }



/*
    public function old_get_log($avecnull=0,$mode='') {
        $salaires_logs=Log::where('table','=','salaire')
                        ->where('values','like',"id=>".$this->id.";%")
                        ->orderby('date','ASC')
                        ->get();
                        dd($this->id);
        $t_value_prec=[];$sep=":";$t_res=[];
        foreach($salaires_logs as $log)  {
            $t_val=[];
            $t_values=explode(";",$log->values);
            for($i=0;$i<count($t_values);$i++) {
                $t_detail=explode("=>",$t_values[$i]);
                if($mode=="B") $val_html=$t_detail[0]."|".$t_detail[1];
                else $val_html=$t_detail[0].":<span style='color:red;''>".$t_detail[1]."</span>";

                if(isset($t_value_prec[$i])) {
                    $egal=($t_values[$i]==$t_value_prec[$i]);
                    if($mode=="B") {
                        if(!$egal) $t_val=$val_html."|0"; //ajout 3e colonne pour 0=>pas de changement 1=>avec changement
                        else $t_val=$val_html."|1";
                    } else {
                        if(!$egal) $t_val[]=$val_html;
                    }
                } else {
                    if($avecnull || ($t_detail[1]!="")) $t_val[]=$val_html.(($mode=="B")?"|1":"");
                }
            }
           dd($t_val);
            $t_res[$log->DateUS]=["date"=>$log->DateUS,"login"=>$log->login
            ,"ip"=>$log->ip,"value"=>$t_val];
            $t_value_prec=$t_values;
           
        }         
        if($t_res) krsort($t_res);
        return $t_res;
    }
*/


    public function old_get_log($avecnull=0,$mode='') {
        $salaires_logs=Log::where('table','=','salaire')
                        ->where('values','like',"id=>".$this->id.";%")
                        ->orderby('date','ASC')
                        ->get();
                        dd($this->id);
        $t_value_prec=[];$sep=":";$t_res=[];
        foreach($salaires_logs as $log)  {
            $t_val=[];
            $t_values=explode(";",$log->values);
            for($i=0;$i<count($t_values);$i++) {
                $t_detail=explode("=>",$t_values[$i]);
                if($mode=="B") $val_html=$t_detail[0]."|".$t_detail[1];
                else $val_html=$t_detail[0].":<span style='color:red;''>".$t_detail[1]."</span>";

                if(isset($t_value_prec[$i])) {
                    $egal=($t_values[$i]==$t_value_prec[$i]);
                    if($mode=="B") {
                        if(!$egal) $t_val=$val_html."|0"; //ajout 3e colonne pour 0=>pas de changement 1=>avec changement
                        else $t_val=$val_html."|1";
                    } else {
                        if(!$egal) $t_val[]=$val_html;
                    }
                } else {
                    if($avecnull || ($t_detail[1]!="")) $t_val[]=$val_html.(($mode=="B")?"|1":"");
                }
            }
           dd($t_val);
            $t_res[$log->DateUS]=["date"=>$log->DateUS,"login"=>$log->login
            ,"ip"=>$log->ip,"value"=>$t_val];
            $t_value_prec=$t_values;
           
        }         
        if($t_res) krsort($t_res);
        return $t_res;
    }

    public function get_log_general($annee="",$id_employeur=0) {

        return $t_res;
    }


    //LOG
     public function log_transaction($url,$operation) {
        $log=new Logs;
        $values="";
        $t_values=$this->getAttributes();
        foreach($t_values as $nom=>$value) $values.=(($values=="")?"":";").$nom."=>".$value; 
        $log->addlog(['url'=>$url,'table'=>$this->table ,'operation'=>$operation,'values'=>$values]);
    }
}
 