<?php namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Facades\Request;

use Spatie\Permission\Traits\HasRoles;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use App\Http\Controllers\Logs;


class User extends Authenticatable
{
    use HasFactory, Notifiable, HasRoles;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'nom',
        'login',
        'mail',
        'password',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];


    public function getFullNameAttribute()
    {
        return $this->nom . ' ' . $this->prenom;
    }



    public function getRoles()
    {
        $roles=$this->getRoleNames();
        $liste="";
        foreach($roles as $role) $liste.=(($liste=="")?"":"<br/>").$role;
        return $liste;
     }


     /* test si administrateur system */
    public function getSysAdminAttribute()
    {
        if($this->login=="admin") return true; 
        return false;
     }

    public function getLastConnectionAttribute()
    {
        $last_cnx =  Connection::where('login', '=', $this->email)
            ->orderby('date','DESC')
            ->first();

        if($last_cnx) return $last_cnx->date;
        return "";
     }

    public function addConnection() {
        $request = Request::instance();
        $adress=$request->getClientIp();
        $connection = new Connection;
        $connection->ip = $adress;
        $connection->login  = $this->login;
        $connection->date   = date('Y-m-d H:i:s');
        $connection->ucname = gethostbyaddr($adress); 
        $connection->save();
    }


    public function getIconeTypeTab($type) {
        $t_infos=array();
        if($type=="S") $t_infos=["icone"=>"aidesociale.png"
                ,"titre"=>"Aides sociales"
                ,"titre_fiche"=>"Aides sociales"
                ,"libelle"=>"d'Aides Sociales "
                ,"color"=>"rgba(204,228,48, 0.1);"];

        if($type=="A") $t_infos=["icone"=>"allocations.png"
                ,"titre"=>"Allocations"
                ,"titre_fiche"=>"Allocataire"
                ,"libelle"=>"d'Allocations "
                ,"color"=>"rgba(154,205,50, 0.2)"];

        if(($type=="T")||($type=="*")) $t_infos=["icone"=>"autre.png"
                ,"titre"=>"Autres..."
                ,"titre_fiche"=>"Autre"
                ,"libelle"=>"Autres "
                ,"color"=>"rgba(255,140,0, 0.2);"];

        if($type=="D") $t_infos=["icone"=>"decede.png"
                ,"titre"=>"Décédés"
                ,"titre_fiche"=>"Décédé"
                ,"libelle"=>"Décédés "
                ,"color"=>"rgba(119,136,153, 0.2);"];

        if($type=="B") $t_infos=["icone"=>"rembourse.png"
                ,"titre"=>"Remboursés"
                ,"titre_fiche"=>"Remboursé"
                ,"libelle"=>"Remboursés "
                ,"color"=>"rgba(255,69,0, 0.1);"];

        if($type=="R") $t_infos=["icone"=>"retraite.png"
                ,"titre"=>"retraités"
                ,"titre_fiche"=>"Retraité"
                ,"libelle"=>"Retraités "
                ,"color"=>"rgba(128,0,128, 0.1);"];

        if($type=="C") $t_infos=["icone"=>"retraite.png"
                ,"titre"=>"retraités"
                ,"titre_fiche"=>"Retraité"
                ,"libelle"=>"Retraités "
                ,"color"=>"rgba(128,0,128, 0.1);"];

        if($type=="V") $t_infos=["icone"=>"voeuf.png"
                ,"titre"=>"Voeufs"
                ,"titre_fiche"=>"Voeuf"
                ,"libelle"=>"des Voeufs "
                ,"color"=>"rgba(65,105,225, 0.1);"];  

        if($type=="*") $t_infos=["icone"=>"tous.png"
                ,"titre"=>"tous"
                ,"titre_fiche"=>""
                ,"libelle"=>"de Tous "
                ,"color"=>"rgba(128,0,128, 0.2);"];

        if($type=="") $t_infos=["icone"=>""
                ,"titre"=>""
                ,"titre_fiche"=>""
                ,"libelle"=>""
                ,"color"=>""];



        return $t_infos;
    }

    public function getIconeStatut($type) {
        $t_images=["ALL"=>"allocations.png","RET"=>"retraite.png","SOC"=>"aidesociale.png","SAV"=>"retraite.png"];
        return $t_images[$type];
    }


    public function getTitreStatut($type,$prefixe=false) {
        $t_titre=array();
        if(!$prefixe) {
            $t_titre=["ALL"=>"Allocations","RET"=>"Retraites","SOC"=>"Aides sociales","SAV"=>"Contributions Sociales de Retraite"];
        } else {
            $t_titre=["ALL"=>"d'Allocations","RET"=>"de Retraites","SOC"=>"d'Aides sociales","SAV"=>"de Contributions Sociales de Retraite"];
        } 
        return $t_titre[$type];
    }

    public function getParametre($ref) {
        $val=Parametre::where('ref','=',$ref)->first()->value;
        return $val;
    }


    public function getIPattribute() {
        $ip='';
        return $ip;
    }

    //LOG
     public function log_transaction($url,$operation,$values="") {
        $log=new Logs;
        if($values=="") {
          $t_values=$this->getAttributes();
          foreach($t_values as $nom=>$value) $values.=(($values=="")?"":";").$nom."=>".$value; 
        } 

        $log->addlog(['url'=>$url,'table'=>$this->table ,'operation'=>$operation,'values'=>$values]);
    }
}
