<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Http\Controllers\Logs;

class Versement extends Model
{
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'versem';



    /* Dates */
    public function getDates()
    {
            return array('date','ret_date');
    }


     public function getDateAttribute($value)
    {
        return (($this->attributes['date']!="0000-00-00")&&($this->attributes['date']!=null))?date('d/m/Y', strtotime($this->attributes['date'])):"";
    }

     public function getDateUSAttribute($value)
    {
        return (($this->attributes['date']!="0000-00-00")&&($this->attributes['date']!=null))?date('Y-m-d', strtotime($this->attributes['date'])):"";
    }

     public function getRetDateAttribute($value)
    {
        return (($this->attributes['ret_date']!="0000-00-00")&&($this->attributes['ret_date']!=null))?date('d/m/Y', strtotime($this->attributes['ret_date'])):"";
    }

     public function getRetDateUSAttribute($value)
    {
        return (($this->attributes['ret_date']!="0000-00-00")&&($this->attributes['ret_date']!=null))?date('Y-m-d', strtotime($this->attributes['ret_date'])):"";
    }


     public function getMoisAttribute()
    {
        $t_mois = array('01'=>'Janvier', '02'=>'Février', '03'=>'Mars', '04'=>'Avril', 
            '05'=>'Mai', '06'=>'Juin', '07'=>'Juillet', '08'=>'Août', '09'=>'Septembre', 
            '10'=>'Octobre', '11'=>'Novembre', '12'=>'Décembre');
        $mois=date('m', strtotime($this->attributes['ret_date']));
        $libelle=$t_mois[$mois];
        return $libelle;
    }


     public function getRetAnneeAttribute($value)
    {
        $annee=date('Y', strtotime($this->attributes['ret_date']));
        return $annee;
    }

     public function getNomEmployeurAttribute($value)
    {
        $employeur=Employeur::find($this->sonum);
        if($employeur) return $employeur->nom;
        return "";
    }


     public function getNomCompletBeneficiaireAttribute($value)
    {
        $beneficiaire=Beneficiaire::find($this->benum);
        if($beneficiaire) return $beneficiaire->nom_complet;
        return "";
    }

     public function getPrenomBeneficiaireAttribute($value)
    {
        $beneficiaire=Beneficiaire::find($this->benum);
        if($beneficiaire) return $beneficiaire->prenom;
        return "";
    }

     public function getNomBeneficiaireAttribute($value)
    {
        $beneficiaire=Beneficiaire::find($this->benum);
        if($beneficiaire) return $beneficiaire->nom;
        return "";
    }

     public function getNbEnfantsAttribute($value)
    {
        $beneficiaire=Beneficiaire::find($this->benum);
        if($beneficiaire) return $beneficiaire->nb_enfants;
        return "";
    }

     public function getBanqueNomAttribute($value)
    {
        $banque=Banque::find($this->bqcleunik);
        if($banque) return $banque->nom;
        return "";
    }

     public function getNaissanceBeneficiaireAttribute($value)
    {
        $beneficiaire=Beneficiaire::find($this->benum);
        if($beneficiaire) return $beneficiaire->datenaiss;
        return "";
    }
    
     public function getMontantAttribute($value)
    {
        $montant=$this->montant_c+$this->montant_r;
        return $montant;
    }

     public function getMontantEuroAttribute($value)
    {
        $montant=round($this->montant*0.00838,2);
        return $montant;
    }

    //LOG
     public function log_transaction($url,$operation) {
        $log=new Logs;
        $values="";
        $t_values=$this->getAttributes();
        foreach($t_values as $nom=>$value) $values.=(($values=="")?"":";").$nom."=>".$value; 
        $log->addlog(['url'=>$url,'table'=>$this->table ,'operation'=>$operation,'values'=>$values]);
    }
}