<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use Zizaco\Entrust\Traits\EntrustUserTrait;
use App\Http\Controllers\Logs;

class Salaire_cumules extends Model {
	
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'salaires_cumules';


     public function getTotalAnneeAttribute()
    {
        $total=$this->jan+
            $this->fev+
            $this->mar+
            $this->avr+
            $this->mai+
            $this->jun+
            $this->jui+
            $this->aou+
            $this->sep+
            $this->oct+
            $this->nov+
            $this->dec;
        
        return $total;
    }


     public function getSalaireMoyenAttribute()
    {
        $t_mois=[0=>"jan",1=>"fev",2=>"mar",3=>"avr",4=>"mai",
            5=>"jun",6=>"jui",7=>"aou",8=>"sep",9=>"oct",10=>"nov",11=>"dec"];
        $t_column["jan"]=$this->jan;
        $t_column["fev"]=$this->fev;
        $t_column["mar"]=$this->mar;
        $t_column["avr"]=$this->avr;
        $t_column["mai"]=$this->mai;
        $t_column["jun"]=$this->jun;
        $t_column["jui"]=$this->jui;
        $t_column["aou"]=$this->aou;
        $t_column["sep"]=$this->sep;
        $t_column["oct"]=$this->oct;
        $t_column["nov"]=$this->nov;
        $t_column["dec"]=$this->dec;
        $salaire=0;$salaire_reel=0;
        $nb_mois=0;$nb_mois_reel=0;
        for($k=0;$k<12;$k++) {
            $salaire_mois=$t_column[$t_mois[$k]];
            $salaire_reel+=$salaire_mois;
            $nb_mois_reel++;
            if($salaire_mois>0) {
                $salaire+=$salaire_mois;
                $nb_mois++;
            }
            
        }
        $salaire_moy=round($salaire/$nb_mois,0);
        $salaire_moy_reel=round($salaire/$nb_mois_reel,0);
        $res=$nb_mois."~".$salaire_moy."~".$nb_mois_reel."~".$salaire_moy_reel;
        return $res;
    }


     public function getSalairesTab()
    {
        
        $t_mois=[0=>"jan",1=>"fev",2=>"mar",3=>"avr",4=>"mai",
            5=>"jun",6=>"jui",7=>"aou",8=>"sep",9=>"oct",10=>"nov",11=>"dec"];
        $k=0;
        for($k=0;$k<12;$k++)
            $salaire[$k]=$this->{$t_mois[$k]};
        return $salaire;
    }

     public function getSalairesMois($mois)
    {
        $t_salaires=$this->getSalairesTab();
        return $t_salaires[$mois];

    }


     public function getFirstMoisSalaireAttribute()
    {
        $mois="";
        if($this->jan>0) $mois="01";
        else if($this->fev>0) $mois="02";
        else if($this->mar>0) $mois="03";
        else if($this->avr>0) $mois="04";
        else if($this->mai>0) $mois="05";
        else if($this->jun>0) $mois="06";
        else if($this->jui>0) $mois="07";
        else if($this->aou>0) $mois="08";
        else if($this->sep>0) $mois="09";
        else if($this->oct>0) $mois="10";
        else if($this->nov>0) $mois="11";
        else if($this->dec>0) $mois="12";
        return $mois;
    }

     public function getLastMoisSalaireAttribute()
    {
        $mois="";
        
        if($this->dec>0) $mois="12";
        else if($this->nov>0) $mois="11";
        else if($this->oct>0) $mois="10";
        else if($this->sep>0) $mois="09";
        else if($this->aou>0) $mois="08";
        else if($this->jui>0) $mois="07";
        else if($this->jun>0) $mois="06";
        else if($this->mai>0) $mois="05";
        else if($this->avr>0) $mois="04";
        else if($this->mar>0) $mois="03";
        else if($this->fev>0) $mois="02";
        else if($this->jan>0) $mois="01";
        return $mois;
    }


    public function getNbsalaireAttribute()
    {
        $t_mois=array('jan','fev','mar','avr','mai','jun','jui','aou','sep','oct','nov','dec');
        foreach($t_mois as $mois) $nb_salaire[$mois]=0;
        $nb_salaire["total"]=0;
        if($this->jan>0) $nb_salaire['jan']++;
        if($this->fev>0) $nb_salaire['fev']++;
        if($this->mar>0) $nb_salaire['mar']++;
        if($this->avr>0) $nb_salaire['avr']++;
        if($this->mai>0) $nb_salaire['mai']++;
        if($this->jun>0) $nb_salaire['jun']++;
        if($this->jui>0) $nb_salaire['jui']++;
        if($this->aou>0) $nb_salaire['aou']++;
        if($this->sep>0) $nb_salaire['sep']++;
        if($this->oct>0) $nb_salaire['oct']++;
        if($this->nov>0) $nb_salaire['nov']++;
        if($this->dec>0) $nb_salaire['dec']++;
        foreach($t_mois as $mois) $nb_salaire['total']+=$nb_salaire[$mois];

        return $nb_salaire;
    }

}
 