@include('forms.fbncheader')
@include('forms.fdatatables')

{{HTML::style('css/bootstrap-select.min.css');}}
{{HTML::style('css/datepicker3.css');}}


{{HTML::script('js/bootstrap-datepicker.js');}} 
{{HTML::script('js/bootstrap-select.js');}}


<div class="col-lg-10 col-lg-offset-1">
    <h1><i class="fa fa-epreuves"></i>Saisie des Paramètres</h1>
</div>



<div class="col-lg-10 col-lg-offset-1">
{{ Form::model($parametres, ['parametre' => 'form', 'url' => 'param/parametres/0', 'method' => 'PUT']) }}
<div class="table-responsive">


<table id="_table" class="table  table-bordered" cellspacing="0" width="500px">
        <thead>
                <tr>
                    <th width='70%'>Information</th>
                    <th width='25%'>Valeur</th>
                    <th width='5%'>Position</th>
                </tr>
        </thead>
 
 
        <tbody>
            @foreach ($parametres as $parametre)
            <tr>
                <td>{{ $parametre->info }}</td>
                <td>
                <?php if($parametre->type=='T') { ?>
                	{{ InputGroup::withContents(Form::text($parametre->nom, $parametre->value, ['placeholder' => '', 'class' => 'form-control'])) }}
                <?php } ?>

                <?php if($parametre->type=='D') { ?>
                <div class='input-group date' id='datepicker_{{$parametre->nom}}'>
		            {{ Form::text($parametre->nom, $parametre->value, ['placeholder' => $parametre->info, 'class' => 'form-control']) }}
		            <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
		            <script type="text/javascript">
		                $(function () {
		                    $('#datepicker_{{$parametre->nom}}').datepicker({
		                        format: "dd/mm/yyyy",
		                        language: "fr",
		                        autoclose: true
		                    });
		                });
		            </script>
                <?php } ?>
                </td>

                <td>
                    {{ Form::text(("position".$parametre->nom), $parametre->position, ['placeholder' => '', 'class' => 'form-control']) }}
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>

    <div class='form-group'>
        {{ Form::submit('Enregistrer', ['class' => 'btn btn-primary']) }}
    </div>


{{ Form::close() }}
</div>



</body></html>
<!-- @include('forms.fdatatables_script_2') -->

<script>
$(document).ready(function() {
    $('#_table').dataTable( {
    	"width": "10%",
        "bAutoWidth": false,
        "bPaginate": false,
        "bInfo": false,
        "bFilter": false,
        } );
    } );



} );
</script>