@include('forms.fbncheader')
@include('forms.fdatatables')

<div class="col-lg-10 col-lg-offset-1">
    <h1><i class="fa fa-users"></i>Administration des permissions</h1>
 
    <div class="table-responsive">
        <table id="_table" class="table" cellspacing="0" width="100%">
 
            <thead>
                <tr>
                    <th width='1%' >Id</th>
                    <th width='10%' >Nom</th>
                    <th>Nom affiché</th>
                    <th>Rôles autorisés</th>
                    @if($user->HasRole("ADMINISTRATEUR"))
                    <th width='10%'>Date/Heure de création</th>
                    <th width='185px'></th>
                    @endif
                </tr>
            </thead>
 
            <tbody>
                @foreach ($permissions as $permission)
                <tr>
                    <td>{!! $permission->id !!}</td>
                    <td>{!! $permission->name !!}</td>
                    <td nowrap>{!! $permission->display_name !!}</td>
                    <td nowrap>{!! $permission->getroles() !!}</td>
                    @if($user->HasRole("ADMINISTRATEUR"))
                    <td nowrap>{!! $permission->CreatedAt !!}</td>
                    <td nowrap>
                    
                        <a href="./permissions/{!! $permission->id !!}/edit" class="btn btn-info pull-left" style="margin-right: 3px;">Modifier</a>

                        {!! Form::open(['url' => '/acces/permissions/' . $permission->id, 'method' => 'DELETE']) !!}
                        {!! Form::submit('Supprimer', ['class' => 'btn btn-danger'])!!}
                        {!! Form::close() !!}
                    
                    </td>
                    @endif
                </tr>
                @endforeach
            </tbody>
 
        </table>
    </div>
 
@if($user->can("PER_AJO")|| $user->hasrole("ADMINISTRATEUR"))
    <div>
        <h4><a href="./permissions/create" class="btn btn-success">Ajouter une permission</a></h4>
    </div> 
@endif


    
 
</div>

</body></html>

@include('forms.fdatatables_script')