@include('forms.fbncheader')
@include('forms.fdatatables')

<div class="col-lg-10 col-lg-offset-1">
    <h1><i class="fa fa-roles"></i>Administration des Rôles</h1>
 
         <div class="card-header">
                <a href="./roles_tableau" class="btn btn-info pull-left" style="margin-right: 3px;">
                    Tableau croisé
                </a>
        </div>
        
    <div class="">
            <table id="_table" width="100%" class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th width=20%'>Nom</th>
                        <th >Utilisateurs</th>
                        <th width='1px'>
                            @if($user->hasRole("ADMINISTRATEUR") || $user->can("ROL_AJO"))
                            <a href="{!! url('acces/roles/create') !!}" class="btn btn-success">
                                Ajouter</a> 
                            @endif
                        </th>
                    </tr>
                </thead>

                <tbody>
                    @foreach ($roles as $role)
                    <tr>
                        <td>
                            <a href="{!! url('/acces/roles/'.$role->id) !!}" >{!! $role->name !!}</a>
                        </td>
                        <td style=''>{!! $role->NomUsers !!}</td>
                         
                        <td nowrap>
                            @if(($user->hasRole("ADMINISTRATEUR") || $user->can("ROL_SUP"))&&($role->NomUsers=="")&&($role->NbPermissions==0))
                                {!! Form::open(['url' => url('roles/' . $role->id), 'method' => 'DELETE']) !!}
                            @endif

                                @if($user->hasRole("ADMINISTRATEUR")|| $user->can("ROL_MAJ"))
                                <a href="./roles/{!! $role->id !!}/edit" class="btn btn-info pull-left" style="margin-right: 3px;">
                                    Modifier
                                </a>
                                @endif

                            @if(($user->hasRole("ADMINISTRATEUR")|| $user->can("ROL_SUP"))&&($role->NomUsers=="")&&($role->NbPermissions==0))
                                {{ csrf_field() }}
                                <button class="btn btn-danger">Supprimer</button>
                            {!! Form::close() !!}
                            @endif

                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
    </div>
 
 @if($user->can("ROL_AJO")|| $user->hasrole("ADMINISTRATEUR"))
     <div>
        <h4><a href="./roles/create" class="btn btn-success">Ajouter un Rôle</a></h4>
    </div> 
@endif


    
 
</div>

</body></html>



<script>
$(document).ready(function() {
   $.fn.dataTable.moment('D/M/YYYY');
} );
</script>
 @include('forms.fdatatables_script_2')