@include('forms.fbncheader')
@include('forms.fdatatables')


<div class="card">
    <div class="card-body">
        <table id="_table" width="100%" class="table table-striped table-bordered">
            <thead>
                <tr>
                    <th width='10%'>Permissions</th>
                    @foreach ($roles as $role)
                        <th>{!! $role->name !!}</th>
                    @endforeach
                </tr>
            </thead>

            <tbody>
                @foreach ($permissions as $permission)
                    <tr>
                        <td>{!! $permission->display_name !!}</td>
                        @foreach ($roles as $role)
                        <td align='center' style="{!! $role->hasPermissionTo($permission->name)?'background-color:lightgreen':'' !!}">

                            @if($role->hasPermissionTo($permission->name)) 
                                {!! "OUI" !!}
                            @else
                                {!! "-" !!}
                            @endif
                        </td>
                        @endforeach
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>




    <script>
    $(document).ready(function() {
        var table =$('#_table').dataTable( {
            bAutoWidth: false,
            bPaginate: true,
            bInfo: false,
            bFilter: true,
            deferRender: true,
            oLanguage: {
                "sZeroRecords": "Aucune ligne",
                "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
                "sInfoEmpty": "Showing 0 to 0 of 0 records",
                "sInfoFiltered": "(sur un total de _MAX_ lignes)",
                "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                    ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                    "sSearch":"Chercher ",
                buttons: {
                    colvis: 'Colonnes à afficher',
                    copy: 'Copier',
                    copyTitle: 'Ajouté au presse-papiers',
                    copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                    copySuccess: {
                        _: '%d lignes copiées',
                        1: '1 ligne copiée'
                    }
                }

                },
                //"dom": '<"top"fBl>rt<"bottom"ip><"clear">',
                dom: "<'row'<'col-sm-4 text-left'f><'col-sm-4'><'col-sm-6 text-right'B>>" +
                "<'row'<'col-sm-12'tr>>" +"<'row'<'col-sm-5'i><'col-sm-7'p>>",
                buttons: [ 
                    {extend: 'copy',exportOptions: {columns: ':visible'} },
                    {extend: 'excel',exportOptions: {columns: ':visible'} }, 
                    'colvis'
                ],

            } );

    } );
    </script>



