@extends('layouts.master')
 
@section('title') Create Role @stop
 
@section('content')
 
<div class='col-lg-10 col-lg-offset-2'>
 
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif

    <h1><i class='fa fa-user'></i> Mise à jour du Role</h1>
 
    {!! Form::model($role, ['role' => 'form',  'class' => 'form-horizontal']) !!}
 
 
    <div class='form-group'>
        <div class="col-xs-4">
        {!! Form::label('name', 'Nom') !!}
        {!! Form::text('name', null, ['disabled', 'class' => 'form-control text-uppercase']) !!}
        </div>
    </div>

    @if($role->name=="ADMINISTRATEUR")
        <h3 class="bg-danger alert" style='color:red'>
            Le rôle ADMINISTRATEUR à accès à toutes les permissions. 
        </h3>
        {!! Form::hidden('role_permissions[]', '') !!}
    @else

    <div class='form-group'>
        <div class="col-xs-5">
        {!! Form::label('permissions', 'Permissions') !!}
            {!! Form::select(
                'role_permissions[]',
                $liste_premissions,
                $t_getPermissions,
                [
                    'readonly',
                    'class' => 'selectpicker',
                    'multiple'=> 'multiple',
                    'data-width' => "100%"
                ]
            ) 

            !!}
        </div>
    </div>

    @endif

     <div class='form-group'>
        <div class="col-xs-5">
            {!! Form::label('benef_statut', 'Statut visualisé par défaut pour la liste des bénéficiaires') !!}

                {!! Form::select('benef_statut',
                    $liste_benefstatut
                    ,$role->benef_statut,['readonly','class' => 'form-control']) !!}
        </div>
    </div>

        <div class='form-group'>
            <div class="col-xs-10">
            <a href="{!! url('/acces/roles') !!} ">
            {!! Form::button('Retour', ['class' => 'btn btn-warning']) !!}
            </a>

            </div>
        </div>
     
    {!! Form::close() !!}

</div>
@stop